/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Shape;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.ij.MOPS;
import mpicbg.ij.util.Util;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DMOPS;
import mpicbg.models.AffineModel2D;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;

public class MOPS_ExtractPointRoi
implements PlugIn,
MouseListener,
KeyListener,
ImageListener {
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    private ImagePlus imp1;
    private ImagePlus imp2;
    private ImagePlus impFeature1;
    private ImagePlus impFeature2;
    private final List<Feature> fs1 = new ArrayList<Feature>();
    private final List<Feature> fs2 = new ArrayList<Feature>();
    private final HashMap<Point, Feature> m1 = new HashMap();
    private final HashMap<Point, Feature> m2 = new HashMap();
    private final ArrayList<Feature> i1 = new ArrayList();
    private final ArrayList<Feature> i2 = new ArrayList();
    private static final Param p = new Param();

    public MOPS_ExtractPointRoi() {
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
    }

    public final void run(String args) {
        boolean modelFound;
        TranslationModel2D model;
        this.impFeature1 = null;
        this.impFeature2 = null;
        this.fs1.clear();
        this.fs2.clear();
        this.m1.clear();
        this.m2.clear();
        this.i1.clear();
        this.i2.clear();
        if (IJ.versionLessThan((String)"1.40")) {
            return;
        }
        int[] ids = WindowManager.getIDList();
        if (ids == null || ids.length < 2) {
            IJ.showMessage((String)"You should have at least two images open.");
            return;
        }
        String[] titles = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        GenericDialog gd = new GenericDialog("Extract MOPS Landmark Correspondences");
        gd.addMessage("Image Selection:");
        String current = WindowManager.getCurrentImage().getTitle();
        gd.addChoice("source_image", titles, current);
        gd.addChoice("target_image", titles, current.equals(titles[0]) ? titles[1] : titles[0]);
        gd.addMessage("Scale Invariant Interest Point Detector:");
        gd.addNumericField("initial_gaussian_blur :", (double)MOPS_ExtractPointRoi.p.mops.initialSigma, 2, 6, "px");
        gd.addNumericField("steps_per_scale_octave :", (double)MOPS_ExtractPointRoi.p.mops.steps, 0);
        gd.addNumericField("minimum_image_size :", (double)MOPS_ExtractPointRoi.p.mops.minOctaveSize, 0, 6, "px");
        gd.addNumericField("maximum_image_size :", (double)MOPS_ExtractPointRoi.p.mops.maxOctaveSize, 0, 6, "px");
        gd.addMessage("Feature Descriptor:");
        gd.addNumericField("feature_descriptor_size :", (double)MOPS_ExtractPointRoi.p.mops.fdSize, 0);
        gd.addNumericField("closest/next_closest_ratio :", (double)MOPS_ExtractPointRoi.p.rod, 2);
        gd.addMessage("Geometric Consensus Filter:");
        gd.addNumericField("maximal_alignment_error :", (double)MOPS_ExtractPointRoi.p.maxEpsilon, 2, 6, "px");
        gd.addNumericField("inlier_ratio :", (double)MOPS_ExtractPointRoi.p.minInlierRatio, 2);
        gd.addChoice("expected_transformation :", Param.modelStrings, Param.modelStrings[MOPS_ExtractPointRoi.p.modelIndex]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        Toolbar.getInstance().setTool(Toolbar.getInstance().addTool("Select_a_Feature"));
        this.imp1 = WindowManager.getImage((int)ids[gd.getNextChoiceIndex()]);
        this.imp2 = WindowManager.getImage((int)ids[gd.getNextChoiceIndex()]);
        MOPS_ExtractPointRoi.p.mops.initialSigma = (float)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.mops.steps = (int)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.mops.minOctaveSize = (int)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.mops.maxOctaveSize = (int)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.mops.fdSize = (int)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.rod = (float)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.maxEpsilon = (float)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.minInlierRatio = (float)gd.getNextNumber();
        MOPS_ExtractPointRoi.p.modelIndex = gd.getNextChoiceIndex();
        FloatArray2DMOPS mops = new FloatArray2DMOPS(MOPS_ExtractPointRoi.p.mops);
        MOPS ijMOPS = new MOPS(mops);
        long start_time = System.currentTimeMillis();
        IJ.log((String)"Processing MOPS ...");
        ijMOPS.extractFeatures(this.imp1.getProcessor(), this.fs1);
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        IJ.log((String)(this.fs1.size() + " features extracted."));
        start_time = System.currentTimeMillis();
        IJ.log((String)"Processing MOPS ...");
        ijMOPS.extractFeatures(this.imp2.getProcessor(), this.fs2);
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        IJ.log((String)(this.fs2.size() + " features extracted."));
        start_time = System.currentTimeMillis();
        IJ.log((String)"Identifying correspondence candidates using brute force ...");
        List candidates = FloatArray2DMOPS.createMatches(this.fs1, this.fs2, (double)MOPS_ExtractPointRoi.p.rod, this.m1, this.m2);
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        IJ.log((String)(candidates.size() + " potentially corresponding features identified."));
        start_time = System.currentTimeMillis();
        IJ.log((String)"Filtering correspondence candidates by geometric consensus ...");
        ArrayList inliers = new ArrayList();
        ArrayList p1 = new ArrayList();
        ArrayList p2 = new ArrayList();
        switch (MOPS_ExtractPointRoi.p.modelIndex) {
            case 0: {
                model = new TranslationModel2D();
                break;
            }
            case 1: {
                model = new RigidModel2D();
                break;
            }
            case 2: {
                model = new SimilarityModel2D();
                break;
            }
            case 3: {
                model = new AffineModel2D();
                break;
            }
            case 4: {
                model = new HomographyModel2D();
                break;
            }
            default: {
                return;
            }
        }
        try {
            modelFound = model.filterRansac(candidates, inliers, 1000, (double)MOPS_ExtractPointRoi.p.maxEpsilon, (double)MOPS_ExtractPointRoi.p.minInlierRatio);
        }
        catch (NotEnoughDataPointsException e) {
            modelFound = false;
        }
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        if (modelFound) {
            PointMatch.sourcePoints(inliers, p1);
            PointMatch.targetPoints(inliers, p2);
            this.imp1.setRoi((Roi)Util.pointsToPointRoi(p1));
            this.imp2.setRoi((Roi)Util.pointsToPointRoi(p2));
            for (PointMatch m : inliers) {
                this.i1.add(this.m1.get(m.getP1()));
                this.i2.add(this.m2.get(m.getP2()));
            }
            IJ.log((String)(inliers.size() + " corresponding features with a maximal displacement of " + decimalFormat.format(model.getCost()) + "px identified."));
            IJ.log((String)("Estimated transformation model: " + model));
            this.imp1.getCanvas().addMouseListener((MouseListener)this);
            this.imp2.getCanvas().addMouseListener((MouseListener)this);
            this.imp1.getCanvas().addKeyListener((KeyListener)this);
            this.imp2.getCanvas().addKeyListener((KeyListener)this);
            ImagePlus.addImageListener((ImageListener)this);
        } else {
            IJ.log((String)"No correspondences found.");
        }
    }

    public static Shape createFeatureDescriptorShape(Feature f) {
        GeneralPath path = new GeneralPath();
        int w = (int)Math.sqrt(f.descriptor.length);
        double scale = f.scale * (double)w * 4.0 / 2.0;
        double sin = Math.sin(f.orientation);
        double cos = Math.cos(f.orientation);
        double fx = f.location[0];
        double fy = f.location[1];
        double pd = 4.0 / scale;
        path.moveTo(fx + (-cos + sin) * scale, fy + (-sin - cos) * scale);
        path.lineTo(fx + (sin + cos) * scale, fy + (sin - cos) * scale);
        path.lineTo(fx + (cos - sin) * scale, fy + (sin + cos) * scale);
        path.lineTo(fx - (sin + cos) * scale, fy - (sin - cos) * scale);
        path.closePath();
        path.moveTo(fx + ((1.0 + pd) * cos - (1.0 + pd) * sin) * scale, fy + ((1.0 + pd) * sin + (1.0 + pd) * cos) * scale);
        path.lineTo(fx + ((1.0 + 4.0 * pd) * cos - (1.0 + 2.5 * pd) * sin) * scale, fy + ((1.0 + 4.0 * pd) * sin + (1.0 + 2.5 * pd) * cos) * scale);
        path.lineTo(fx + ((1.0 + 2.75 * pd) * cos - (1.0 + 2.75 * pd) * sin) * scale, fy + ((1.0 + 2.75 * pd) * sin + (1.0 + 2.75 * pd) * cos) * scale);
        path.lineTo(fx + ((1.0 + 2.5 * pd) * cos - (1.0 + 4.0 * pd) * sin) * scale, fy + ((1.0 + 2.5 * pd) * sin + (1.0 + 4.0 * pd) * cos) * scale);
        path.closePath();
        for (int y = 1; y < w; ++y) {
            double dy = 1.0 - (double)y * 2.0 / (double)w;
            path.moveTo(fx + (-cos + dy * sin) * scale, fy + (-sin - dy * cos) * scale);
            path.lineTo(fx + (cos + dy * sin) * scale, fy + (sin - dy * cos) * scale);
        }
        for (int x = 1; x < w; ++x) {
            double dx = 1.0 - (double)x * 2.0 / (double)w;
            path.moveTo(fx + (dx * cos + sin) * scale, fy + (dx * sin - cos) * scale);
            path.lineTo(fx + (dx * cos - sin) * scale, fy + (dx * sin + cos) * scale);
        }
        return path;
    }

    public static void drawFeatureDescriptor(FloatProcessor fp, Feature f) {
        fp.setMinAndMax(0.0, 1.0);
        int w = (int)Math.sqrt(f.descriptor.length);
        for (int y = 0; y < w; ++y) {
            for (int x = 0; x < w; ++x) {
                fp.setf(x, y, f.descriptor[y * w + x]);
            }
        }
    }

    public static ImagePlus createFeatureDescriptorImage(String title, Feature f) {
        int w = (int)Math.sqrt(f.descriptor.length);
        FloatProcessor fp = new FloatProcessor(w, w);
        MOPS_ExtractPointRoi.drawFeatureDescriptor(fp, f);
        return new ImagePlus(title, (ImageProcessor)fp);
    }

    public void imageClosed(ImagePlus imp) {
        if (imp == this.imp1 && this.impFeature1 != null) {
            this.impFeature1.close();
        } else if (imp == this.imp2 && this.impFeature2 != null) {
            this.impFeature2.close();
        }
    }

    public void imageOpened(ImagePlus imp) {
    }

    public void imageUpdated(ImagePlus imp) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            if (this.imp1 != null) {
                this.imp1.getCanvas().removeMouseListener((MouseListener)this);
                this.imp1.getCanvas().removeKeyListener((KeyListener)this);
                this.imp1.getCanvas().setDisplayList(null);
                this.imp1.setRoi((Roi)null);
            }
            if (this.impFeature1 != null) {
                this.impFeature1.close();
            }
            if (this.imp2 != null) {
                this.imp2.getCanvas().removeMouseListener((MouseListener)this);
                this.imp2.getCanvas().removeKeyListener((KeyListener)this);
                this.imp2.getCanvas().setDisplayList(null);
                this.imp2.setRoi((Roi)null);
            }
            if (this.impFeature2 != null) {
                this.impFeature2.close();
            }
        } else if (e.getKeyCode() != 112 || e.getSource() instanceof TextField) {
            // empty if block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            ImageWindow win = WindowManager.getCurrentWindow();
            double x = win.getCanvas().offScreenXD(e.getX());
            double y = win.getCanvas().offScreenYD(e.getY());
            Feature target = null;
            double target_d = Double.MAX_VALUE;
            ArrayList<Feature> fl = win.getImagePlus() == this.imp1 ? this.i1 : this.i2;
            for (Feature f : fl) {
                double dy;
                double dx = win.getCanvas().getMagnification() * (f.location[0] - x);
                double d = dx * dx + (dy = win.getCanvas().getMagnification() * (f.location[1] - y)) * dy;
                if (!(d < 64.0) || !(d < target_d)) continue;
                target = f;
                target_d = d;
            }
            if (target != null) {
                if (this.imp1 != null && this.imp1.isVisible()) {
                    Feature f1 = this.i1.get(fl.indexOf(target));
                    this.imp1.getCanvas().setDisplayList(MOPS_ExtractPointRoi.createFeatureDescriptorShape(f1), Roi.getColor(), null);
                    if (this.impFeature1 == null || !this.impFeature1.isVisible()) {
                        this.impFeature1 = MOPS_ExtractPointRoi.createFeatureDescriptorImage("Feature " + this.imp1.getTitle(), f1);
                        this.impFeature1.updateAndDraw();
                        this.impFeature1.show();
                        this.impFeature1.getWindow().setLocationAndSize(this.impFeature1.getWindow().getX(), this.impFeature1.getWindow().getY(), MOPS_ExtractPointRoi.p.mops.fdSize * 16, MOPS_ExtractPointRoi.p.mops.fdSize * 16);
                    } else {
                        MOPS_ExtractPointRoi.drawFeatureDescriptor((FloatProcessor)this.impFeature1.getProcessor().convertToFloat(), f1);
                        this.impFeature1.updateAndDraw();
                        this.impFeature1.show();
                    }
                }
                if (this.imp2 != null && this.imp2.isVisible()) {
                    Feature f2 = this.i2.get(fl.indexOf(target));
                    this.imp2.getCanvas().setDisplayList(MOPS_ExtractPointRoi.createFeatureDescriptorShape(f2), Roi.getColor(), null);
                    if (this.impFeature2 == null || !this.impFeature2.isVisible()) {
                        this.impFeature2 = MOPS_ExtractPointRoi.createFeatureDescriptorImage("Feature " + this.imp2.getTitle(), f2);
                        this.impFeature2.updateAndDraw();
                        this.impFeature2.show();
                        this.impFeature2.getWindow().setLocationAndSize(this.impFeature2.getWindow().getX(), this.impFeature2.getWindow().getY(), MOPS_ExtractPointRoi.p.mops.fdSize * 16, MOPS_ExtractPointRoi.p.mops.fdSize * 16);
                    } else {
                        MOPS_ExtractPointRoi.drawFeatureDescriptor((FloatProcessor)this.impFeature2.getProcessor().convertToFloat(), f2);
                        this.impFeature2.updateAndDraw();
                        this.impFeature2.show();
                    }
                }
            } else {
                if (this.imp1 != null && this.imp1.isVisible()) {
                    this.imp1.getCanvas().setDisplayList(null);
                }
                if (this.imp2 != null && this.imp2.isVisible()) {
                    this.imp2.getCanvas().setDisplayList(null);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta (right button) ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        if ((s = s + "]").equals(" [ ]")) {
            s = " [no modifiers]";
        }
        return s;
    }

    private static class Param {
        public final FloatArray2DMOPS.Param mops = new FloatArray2DMOPS.Param();
        public float rod = 0.92f;
        public float maxEpsilon = 25.0f;
        public float minInlierRatio = 0.05f;
        public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine", "Perspective"};
        public int modelIndex = 1;

        private Param() {
        }
    }
}

