/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.io.IOException;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;

public abstract class SpatialMetadataToImagePlus<T extends SpatialMetadata & N5DatasetMetadata>
implements ImageplusMetadata<T> {
    @Override
    public void writeMetadata(T t, ImagePlus ip) throws IOException {
        AffineTransform3D xfm = t.spatialTransform3d();
        ip.setTitle(t.getPath());
        Calibration cal = ip.getCalibration();
        cal.pixelWidth = xfm.get(0, 0);
        cal.pixelHeight = xfm.get(1, 1);
        cal.pixelDepth = xfm.get(2, 2);
        cal.setUnit(t.unit());
        cal.xOrigin = xfm.get(0, 3);
        cal.yOrigin = xfm.get(1, 3);
        cal.zOrigin = xfm.get(2, 3);
        int nd = ((N5DatasetMetadata)t).getAttributes().getNumDimensions();
        long[] dims = ((N5DatasetMetadata)t).getAttributes().getDimensions();
        if (nd == 3) {
            ip.setDimensions(1, (int)dims[2], 1);
        } else if (nd == 4) {
            ip.setDimensions(1, (int)dims[2], (int)dims[3]);
        }
    }

    @Override
    public abstract T readMetadata(ImagePlus var1) throws IOException;
}

