/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

class RollingBall {
    float[] data;
    int width;
    int shrinkFactor;

    RollingBall(double radius) {
        int arcTrimPer;
        if (radius <= 10.0) {
            this.shrinkFactor = 1;
            arcTrimPer = 24;
        } else if (radius <= 30.0) {
            this.shrinkFactor = 2;
            arcTrimPer = 24;
        } else if (radius <= 100.0) {
            this.shrinkFactor = 4;
            arcTrimPer = 32;
        } else {
            this.shrinkFactor = 8;
            arcTrimPer = 40;
        }
        this.buildRollingBall(radius, arcTrimPer);
    }

    void buildRollingBall(double ballradius, int arcTrimPer) {
        this.shrinkFactor = this.shrinkFactor;
        double smallballradius = ballradius / (double)this.shrinkFactor;
        if (smallballradius < 1.0) {
            smallballradius = 1.0;
        }
        double rsquare = smallballradius * smallballradius;
        int xtrim = (int)((double)arcTrimPer * smallballradius) / 100;
        int halfWidth = (int)Math.round(smallballradius - (double)xtrim);
        this.width = 2 * halfWidth + 1;
        this.data = new float[this.width * this.width];
        int p = 0;
        for (int y = 0; y < this.width; ++y) {
            int x = 0;
            while (x < this.width) {
                int xval = x - halfWidth;
                int yval = y - halfWidth;
                double temp = rsquare - (double)(xval * xval) - (double)(yval * yval);
                this.data[p] = temp > 0.0 ? (float)Math.sqrt(temp) : 0.0f;
                ++x;
                ++p;
            }
        }
    }
}

