/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.imaris;

import io.scif.formats.imaris.HDFPreprocessor;
import io.scif.formats.imaris.HDFWriter;
import io.scif.formats.imaris.PipelineImage;
import io.scif.formats.imaris.ResolutionLevel;
import io.scif.formats.imaris.ResolutionLevelMaker;
import java.awt.Color;
import java.util.LinkedList;

public class ImarisWriter {
    private static final int SLICES_FIRST = 1;
    private static final int CHANNELS_FIRST = 2;
    private volatile LinkedList<PipelineImage> writingQueue_;
    private volatile LinkedList<PipelineImage> preprocessQueue_;
    private volatile boolean preprocessFinished_ = false;
    private final Thread writingThread_;
    private final int numSlices_;
    private final int numChannels_;
    private int imageOrder_ = 0;
    private final HDFWriter writer_;
    private final HDFPreprocessor preprocessor_;
    private final int slicesPerWrite_;

    public ImarisWriter(String path, long width, long height, long numSlices, long numChannels, long numFrames, double pixelSizeXY, double pixelSizeZ, int bitDepth, Color[] channelColors) {
        ResolutionLevel[] resLevels = ResolutionLevelMaker.calcLevels((int)width, (int)height, (int)numSlices, (int)numFrames, 1 + (bitDepth > 8 ? 1 : 0));
        this.preprocessor_ = new HDFPreprocessor((int)width, (int)height, bitDepth, resLevels);
        this.writer_ = new HDFWriter(path, (int)numChannels, (int)numFrames, (int)numSlices, bitDepth, pixelSizeXY, pixelSizeZ, channelColors, (int)width, (int)height, resLevels);
        this.slicesPerWrite_ = resLevels[resLevels.length - 1].getReductionFactorZ();
        this.numSlices_ = (int)numSlices;
        this.numChannels_ = (int)numChannels;
        this.writingQueue_ = new LinkedList();
        this.preprocessQueue_ = new LinkedList();
        this.writingThread_ = new Thread(new Runnable(){

            @Override
            public void run() {
                ImarisWriter.this.imarisWriting();
            }
        });
        this.writingThread_.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(Object pixels, int slice, int channel, int frame, String dateAndTime) {
        LinkedList<PipelineImage> singleChannelBatch;
        if (this.imageOrder_ == 0 && slice == 1) {
            this.imageOrder_ = 1;
        } else if (this.imageOrder_ == 0 && channel == 1) {
            this.imageOrder_ = 2;
        }
        this.preprocessQueue_.add(new PipelineImage(pixels, channel, slice, frame, dateAndTime));
        if (slice == this.numSlices_ - 1 && this.slicesPerWrite_ > 1) {
            this.addDummySlices(slice, frame, channel);
        }
        if (this.imageOrder_ == 1 && this.preprocessQueue_.size() == this.slicesPerWrite_ || this.imageOrder_ == 0 && this.slicesPerWrite_ == 1) {
            PipelineImage pi = this.preprocessor_.process(this.preprocessQueue_);
            this.preprocessQueue_.clear();
            LinkedList<PipelineImage> linkedList = this.writingQueue_;
            synchronized (linkedList) {
                this.writingQueue_.add(pi);
            }
        } else if (this.imageOrder_ == 2 && this.preprocessQueue_.size() == this.slicesPerWrite_ * this.numChannels_) {
            for (int c = 0; c < this.numChannels_; ++c) {
                singleChannelBatch = new LinkedList();
                for (int s = 0; s < this.slicesPerWrite_; ++s) {
                    singleChannelBatch.add(this.preprocessQueue_.get(s * this.numChannels_ + c));
                }
                PipelineImage pi = this.preprocessor_.process(singleChannelBatch);
                LinkedList<PipelineImage> linkedList = this.writingQueue_;
                synchronized (linkedList) {
                    this.writingQueue_.add(pi);
                    continue;
                }
            }
            this.preprocessQueue_.clear();
        }
        int size = 0;
        singleChannelBatch = this.writingQueue_;
        synchronized (singleChannelBatch) {
            size = this.writingQueue_.size();
        }
        while (size > 2) {
            try {
                Thread.sleep(10L);
                singleChannelBatch = this.writingQueue_;
                synchronized (singleChannelBatch) {
                    size = this.writingQueue_.size();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() {
        this.preprocessFinished_ = true;
        try {
            this.writingThread_.join();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.writer_.close();
    }

    private void addDummySlices(int sliceIndex, int frameIndex, int channelIndex) {
        if (this.imageOrder_ == 2) {
            int s = sliceIndex + 1;
            while (s % this.slicesPerWrite_ != 0) {
                for (int c = 0; c < this.numChannels_; ++c) {
                    this.preprocessQueue_.add(new PipelineImage(null, c, s, frameIndex, null));
                }
                ++s;
            }
        } else {
            int s = sliceIndex + 1;
            while (s % this.slicesPerWrite_ != 0) {
                this.preprocessQueue_.add(new PipelineImage(null, channelIndex, s, frameIndex, null));
                ++s;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imarisWriting() {
        while (true) {
            PipelineImage toWrite = null;
            LinkedList<PipelineImage> linkedList = this.writingQueue_;
            synchronized (linkedList) {
                if (!this.writingQueue_.isEmpty()) {
                    toWrite = this.writingQueue_.removeFirst();
                }
            }
            if (toWrite == null) {
                if (this.preprocessFinished_) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            try {
                this.writer_.writeImage(toWrite);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

