/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.pde.ExplicitDiffusionScheme2D;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class StandardDiffusionScheme2D<T extends RealType<T>>
extends ExplicitDiffusionScheme2D<T> {
    private static final float DEFAULT_DT = 0.25f;
    private float dt;

    public StandardDiffusionScheme2D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, float dt) {
        super(input, D);
        this.dt = dt;
    }

    public StandardDiffusionScheme2D(Img<T> input, Img<FloatType> D) {
        this((RandomAccessibleInterval<T>)input, (RandomAccessibleInterval<FloatType>)D, 0.25f);
    }

    @Override
    protected final float diffusionScheme(float[] U, float[][] D) {
        float Ucc = U[0];
        float Ucm = U[1];
        float Upm = U[2];
        float Upc = U[3];
        float Upp = U[4];
        float Ucp = U[5];
        float Ump = U[6];
        float Umc = U[7];
        float Umm = U[8];
        float Acc = D[0][0];
        float Apc = D[0][1];
        float Amc = D[0][2];
        float Bcm = D[1][1];
        float Bpc = D[1][3];
        float Bcp = D[1][5];
        float Bmc = D[1][7];
        float Ccc = D[2][0];
        float Ccm = D[2][1];
        float Ccp = D[2][2];
        float Icp = (Ucp - Ucc) * (Ccp + Ccc) / 2.0f;
        float Imc = (Umc - Ucc) * (Amc + Acc) / 2.0f;
        float Ipc = (Upc - Ucc) * (Apc + Acc) / 2.0f;
        float Icm = (Ucm - Ucc) * (Ccm + Ccc) / 2.0f;
        float Imp = (Ump - Ucc) * (Bmc - Bcp) / 4.0f;
        float Ipp = (Upp - Ucc) * (Bpc - Bcp) / 4.0f;
        float Imm = (Umm - Ucc) * (Bmc - Bcm) / 4.0f;
        float Ipm = (Upm - Ucc) * (Bpc - Bcm) / 4.0f;
        return this.dt * (Icm + Ipm + Ipc + Ipp + Icp + Imp + Imc + Imm);
    }
}

