/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.localSauvola;

import net.imagej.ops.Ops;
import net.imagej.ops.map.neighborhood.CenterAwareComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.threshold.LocalThresholdMethod;
import net.imagej.ops.threshold.apply.LocalThreshold;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.LocalSauvolaThreshold.class, priority=-100.0)
public class LocalSauvolaThreshold<T extends RealType<T>>
extends LocalThreshold<T>
implements Ops.Threshold.LocalSauvolaThreshold {
    @Parameter(required=false)
    private double k = 0.5;
    @Parameter(required=false)
    private double r = 0.5;

    @Override
    protected CenterAwareComputerOp<T, BitType> unaryComputer(T inClass, BitType outClass) {
        LocalThresholdMethod op = new LocalThresholdMethod<T>(){
            private UnaryComputerOp<Iterable<T>, DoubleType> mean;
            private UnaryComputerOp<Iterable<T>, DoubleType> stdDeviation;

            @Override
            public void compute(Iterable<T> neighborhood, T center, BitType output) {
                if (this.mean == null) {
                    this.mean = Computers.unary(this.ops(), Ops.Stats.Mean.class, new DoubleType(), neighborhood, new Object[0]);
                }
                if (this.stdDeviation == null) {
                    this.stdDeviation = Computers.unary(this.ops(), Ops.Stats.StdDev.class, new DoubleType(), neighborhood, new Object[0]);
                }
                DoubleType meanValue = new DoubleType();
                this.mean.compute(neighborhood, meanValue);
                DoubleType stdDevValue = new DoubleType();
                this.stdDeviation.compute(neighborhood, stdDevValue);
                double threshold = meanValue.get() * (1.0 + LocalSauvolaThreshold.this.k * (Math.sqrt(stdDevValue.get()) / LocalSauvolaThreshold.this.r - 1.0));
                output.set(center.getRealDouble() >= threshold);
            }
        };
        op.setEnvironment(this.ops());
        return op;
    }

    @Override
    public boolean conforms() {
        RectangleShape rect;
        RectangleShape rectangleShape = rect = this.getShape() instanceof RectangleShape ? (RectangleShape)this.getShape() : null;
        if (rect == null) {
            return true;
        }
        return rect.getSpan() <= 2;
    }
}

