/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.correlate;

import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.plugins.commands.correlate.Correlation3x3Operation;
import net.imagej.plugins.commands.correlate.ShadowsEast;
import net.imagej.plugins.commands.correlate.ShadowsNorth;
import net.imagej.plugins.commands.correlate.ShadowsNortheast;
import net.imagej.plugins.commands.correlate.ShadowsNorthwest;
import net.imagej.plugins.commands.correlate.ShadowsSouth;
import net.imagej.plugins.commands.correlate.ShadowsSoutheast;
import net.imagej.plugins.commands.correlate.ShadowsSouthwest;
import net.imagej.plugins.commands.correlate.ShadowsWest;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.input.KeyCode;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Shadows", mnemonic=115), @Menu(label="Shadows Demo", weight=200.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class ShadowsDemo
extends ContextCommand {
    private static final double[][] KERNELS = new double[][]{ShadowsNorth.KERNEL, ShadowsNortheast.KERNEL, ShadowsEast.KERNEL, ShadowsSoutheast.KERNEL, ShadowsSouth.KERNEL, ShadowsSouthwest.KERNEL, ShadowsWest.KERNEL, ShadowsNorthwest.KERNEL};
    @Parameter
    private EventService eventService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ImageDisplayService imgDispService;
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ImageDisplay display;
    private boolean userHasQuit = false;

    public void run() {
        if (this.unsupportedImage(this.display)) {
            this.cancel("This command only works with a single plane of data");
            return;
        }
        this.statusService.showStatus("Press ESC to terminate");
        Dataset input = this.imgDispService.getActiveDataset(this.display);
        RealRect selection = this.overlayService.getSelectionBounds(this.display);
        Dataset originalData = input.duplicate();
        this.userHasQuit = false;
        block2: while (!this.userHasQuit) {
            for (int i = 0; i < KERNELS.length; ++i) {
                Correlation3x3Operation operation = new Correlation3x3Operation(input, selection, KERNELS[i]);
                operation.run();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                originalData.copyInto(input);
                if (this.userHasQuit) continue block2;
            }
        }
        this.statusService.showStatus("Shadows demo terminated");
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    @EventHandler
    protected void onEvent(KyPressedEvent event) {
        if (event.getCode() == KeyCode.ESCAPE) {
            Display disp = event.getDisplay();
            if (disp != null) {
                if (disp == this.display) {
                    this.userHasQuit = true;
                }
            } else if (this.imgDispService.getActiveImageDisplay() == this.display) {
                this.userHasQuit = true;
            }
        }
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent event) {
        if (event.getObject() == this.display) {
            this.userHasQuit = true;
        }
    }

    private boolean unsupportedImage(ImageDisplay disp) {
        Dataset input = this.imgDispService.getActiveDataset(disp);
        for (int i = 0; i < input.numDimensions(); ++i) {
            AxisType axis = ((CalibratedAxis)input.axis(i)).type();
            if (axis == Axes.X || axis == Axes.Y || axis == Axes.CHANNEL && input.isRGBMerged() || input.dimension(i) == 1L) continue;
            return true;
        }
        return false;
    }
}

