/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.misc;

import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.LinearAxis;
import net.imagej.display.ColorMode;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.overlay.ThresholdOverlay;
import net.imagej.threshold.ThresholdService;
import net.imagej.types.DataType;
import net.imagej.types.DataTypeService;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Show Info...", accelerator="^I")}, headless=true, attrs={@Attr(name="no-legacy")})
public class ShowInfo
implements Command {
    @Parameter
    private DataTypeService typeService;
    @Parameter
    private ThresholdService thresholdService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private ImageDisplay disp;
    @Parameter
    private Dataset ds;
    @Parameter(type=ItemIO.OUTPUT)
    private String info;

    public String getInfo() {
        return this.info;
    }

    public void run() {
        this.info = this.infoString();
    }

    private String infoString() {
        StringBuilder builder = new StringBuilder();
        this.add(this.textString(), builder);
        this.add(this.titleString(), builder);
        this.add(this.widthString(), builder);
        this.add(this.heightString(), builder);
        this.add(this.depthString(), builder);
        this.add(this.resolutionString(), builder);
        this.add(this.pixelVoxelSizeString(), builder);
        this.add(this.originString(), builder);
        this.add(this.typeString(), builder);
        this.add(this.displayRangesString(), builder);
        this.add(this.currSliceString(), builder);
        this.add(this.compositeString(), builder);
        this.add(this.thresholdString(), builder);
        this.add(this.calibrationString(), builder);
        this.add(this.sourceString(), builder);
        this.add(this.selectionString(), builder);
        return builder.toString();
    }

    private void add(String s, StringBuilder builder) {
        if (s != null) {
            builder.append(s);
        }
    }

    private String textString() {
        return null;
    }

    private String titleString() {
        return "Title: " + this.ds.getName() + '\n';
    }

    private String widthString() {
        return this.dimString(0, "Width: ");
    }

    private String heightString() {
        return this.dimString(1, "Height: ");
    }

    private String depthString() {
        int zIndex = this.ds.dimensionIndex(Axes.Z);
        if (zIndex < 0) {
            return null;
        }
        return this.dimString(zIndex, "Depth: ");
    }

    private String resolutionString() {
        return null;
    }

    private String pixelVoxelSizeString() {
        double zSize;
        CalibratedAxis zAxis;
        int xIndex = this.ds.dimensionIndex(Axes.X);
        int yIndex = this.ds.dimensionIndex(Axes.Y);
        int zIndex = this.ds.dimensionIndex(Axes.Z);
        CalibratedAxis xAxis = xIndex < 0 ? null : (CalibratedAxis)this.ds.axis(xIndex);
        CalibratedAxis yAxis = yIndex < 0 ? null : (CalibratedAxis)this.ds.axis(yIndex);
        CalibratedAxis calibratedAxis = zAxis = zIndex < 0 ? null : (CalibratedAxis)this.ds.axis(zIndex);
        if (xAxis == null) {
            return null;
        }
        if (yAxis == null) {
            return null;
        }
        if (!(xAxis instanceof LinearAxis)) {
            return null;
        }
        if (!(yAxis instanceof LinearAxis)) {
            return null;
        }
        if (zAxis != null && !(zAxis instanceof LinearAxis)) {
            return null;
        }
        double xCal = xAxis.averageScale(0.0, 1.0);
        double yCal = yAxis.averageScale(0.0, 1.0);
        double zCal = zAxis == null ? Double.NaN : zAxis.averageScale(0.0, 1.0);
        double xSize = Double.isNaN(xCal) ? 1.0 : xCal;
        double ySize = Double.isNaN(yCal) ? 1.0 : yCal;
        double d = zSize = Double.isNaN(zCal) ? 1.0 : zCal;
        if (zAxis == null) {
            return "Pixel size: " + this.dToS(xSize) + " x " + this.dToS(ySize) + '\n';
        }
        return "Voxel size: " + this.dToS(xSize) + " x " + this.dToS(ySize) + " x " + this.dToS(zSize) + '\n';
    }

    private String originString() {
        StringBuilder builder = new StringBuilder("Axis origins:\n");
        for (int d = 0; d < this.ds.numDimensions(); ++d) {
            builder.append(((CalibratedAxis)this.ds.axis(d)).type() + ": " + this.dToS(((CalibratedAxis)this.ds.axis(d)).calibratedValue(0.0)) + "\n");
        }
        return builder.toString();
    }

    private String typeString() {
        Object dataObj = this.ds.getImgPlus().firstElement();
        DataType type = this.typeService.getTypeByClass(dataObj.getClass());
        if (type == null) {
            return "Type: unknown\n";
        }
        return "Type: " + type.longName() + '\n';
    }

    private String displayRangesString() {
        int chAxis = this.disp.dimensionIndex(Axes.CHANNEL);
        if (chAxis < 0) {
            return null;
        }
        long numChan = this.disp.dimension(chAxis);
        StringBuilder builder = new StringBuilder();
        int c = 0;
        while ((long)c < numChan) {
            DatasetView datasetView = this.imageDisplayService.getActiveDatasetView(this.disp);
            double min = datasetView.getChannelMin(c);
            double max = datasetView.getChannelMax(c);
            builder.append("Display range channel " + c + ": " + min + "-" + max + "\n");
            ++c;
        }
        return builder.toString();
    }

    private String currSliceString() {
        Position position = this.disp.getActiveView().getPlanePosition();
        if (position.numDimensions() == 0) {
            return null;
        }
        String tmp = "";
        for (int i = 0; i < position.numDimensions(); ++i) {
            long dim = this.disp.dimension(i + 2);
            long pos = position.getLongPosition(i) + 1L;
            String label = ((CalibratedAxis)this.disp.axis(i + 2)).type().toString();
            tmp = tmp + "View position " + label + ": " + pos + "/" + dim + '\n';
        }
        return tmp;
    }

    private String compositeString() {
        ColorMode mode = ((DatasetView)this.disp.getActiveView()).getColorMode();
        return "Composite mode: " + mode + '\n';
    }

    private String thresholdString() {
        if (this.thresholdService.hasThreshold(this.disp)) {
            ThresholdOverlay thresh = this.thresholdService.getThreshold(this.disp);
            return "Threshold: " + thresh.getRangeMin() + "-" + thresh.getRangeMax() + '\n';
        }
        return "Threshold: none\n";
    }

    private String calibrationString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.ds.numDimensions(); ++i) {
            CalibratedAxis axis = (CalibratedAxis)this.ds.axis(i);
            builder.append(axis.type());
            builder.append(" axis equation: ");
            builder.append(axis.particularEquation());
            builder.append('\n');
        }
        return builder.toString();
    }

    private String sourceString() {
        String source = this.ds.getSource();
        if (source == null) {
            return null;
        }
        return "Source: " + source + '\n';
    }

    private String selectionString() {
        return null;
    }

    private String dimString(int axisIndex, String label) {
        CalibratedAxis axis = (CalibratedAxis)this.ds.axis(axisIndex);
        if (!(axis instanceof LinearAxis)) {
            return label + "varies nonlinearly";
        }
        double cal = axis.averageScale(0.0, 1.0);
        long size = this.ds.dimension(axisIndex);
        String unit = axis.unit();
        String tmp = label;
        if (Double.isNaN(cal) || cal == 1.0) {
            tmp = tmp + size;
            if (unit != null) {
                tmp = tmp + " " + unit;
            }
        } else {
            tmp = tmp + this.dToS(cal * (double)size);
            if (unit != null) {
                tmp = tmp + " " + unit;
            }
            tmp = tmp + " (" + size + ")";
        }
        tmp = tmp + "\n";
        return tmp;
    }

    private String dToS(double num) {
        return String.format("%1.4f", num);
    }
}

