/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.bdv;

import bdv.util.BdvFunctions;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import java.util.Iterator;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.sequence.TimePoint;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.labkit.ui.bdv.BdvShowable;

class SpimBdvShowable
implements BdvShowable {
    private final AbstractSpimData<?> spimData;

    SpimBdvShowable(AbstractSpimData<?> spimData) {
        this.spimData = spimData;
    }

    @Override
    public Interval interval() {
        AbstractSequenceDescription seq = this.spimData.getSequenceDescription();
        BasicViewSetup setup = this.getFirst(seq);
        Dimensions size = setup.getSize();
        if (size == null) {
            RandomAccessibleInterval image = seq.getImgLoader().getSetupImgLoader(setup.getId()).getImage(0, new ImgLoaderHint[0]);
            return new FinalInterval((Interval)image);
        }
        return new FinalInterval(size);
    }

    @Override
    public AffineTransform3D transformation() {
        AbstractSequenceDescription seq = this.spimData.getSequenceDescription();
        BasicViewSetup setup = this.getFirst(seq);
        TimePoint firstTime = (TimePoint)seq.getTimePoints().getTimePointsOrdered().get(0);
        ViewRegistration registration = this.spimData.getViewRegistrations().getViewRegistration(firstTime.getId(), setup.getId());
        return registration.getModel();
    }

    @Override
    public BdvStackSource<?> show(String title, BdvOptions options) {
        return (BdvStackSource)BdvFunctions.show(this.spimData, (BdvOptions)options).get(0);
    }

    private BasicViewSetup getFirst(AbstractSequenceDescription<?, ?, ?> seq) {
        Iterator iterator = seq.getViewSetupsOrdered().iterator();
        if (iterator.hasNext()) {
            BasicViewSetup setup = (BasicViewSetup)iterator.next();
            return setup;
        }
        throw new IllegalStateException("SpimData contains no setup.");
    }
}

