/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.translation;

import edu.utexas.clm.archipelago.network.translation.FileTranslator;

public class PathSubstitutingFileTranslator
implements FileTranslator {
    private final String localFileRoot;
    private final String remoteFileRoot;

    public PathSubstitutingFileTranslator(String local, String remote) {
        this.localFileRoot = local.endsWith("/") || local.endsWith("\\") ? local.substring(0, local.length() - 1) : local;
        this.remoteFileRoot = remote.endsWith("/") || remote.endsWith("\\") ? remote.substring(0, remote.length() - 1) : remote;
    }

    @Override
    public String getLocalPath(String remotePath) {
        if (remotePath.startsWith(this.remoteFileRoot)) {
            return remotePath.replace(this.remoteFileRoot, this.localFileRoot);
        }
        return remotePath;
    }

    @Override
    public String getRemotePath(String localPath) {
        if (localPath.startsWith(this.localFileRoot)) {
            return localPath.replace(this.remoteFileRoot, this.localFileRoot);
        }
        return localPath;
    }
}

