/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.TransformEventHandler;
import bdv.cache.CacheControl;
import bdv.gui.BigWarpViewerOptions;
import bdv.tools.brightness.ConverterSetup;
import bdv.ui.BdvDefaultCards;
import bdv.ui.CardPanel;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.splitpanel.SplitPanel;
import bdv.util.AWTUtils;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.BigWarpViewerPanel;
import bdv.viewer.BigWarpViewerSettings;
import bdv.viewer.ConverterSetups;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bigwarp.BigWarp;
import bigwarp.ui.keymap.KeymapManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.MouseAndKeyHandler;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class BigWarpViewerFrame
extends JFrame {
    protected final BigWarpViewerPanel viewer;
    private final InputActionBindings keybindings;
    private final TriggerBehaviourBindings triggerbindings;
    private final BigWarp<?> bw;
    private SplitPanel splitPanel;
    private CardPanel cards;
    private final Behaviours transformBehaviours;
    private final ConverterSetups setups;
    private final KeymapManager keymapManager;
    private final AppearanceManager appearanceManager;
    private static final long serialVersionUID = -7630931733043185034L;

    public BigWarpViewerFrame(BigWarp<?> bw, int width, int height, List<SourceAndConverter<?>> sources, List<ConverterSetup> converterSetups, BigWarpViewerSettings viewerSettings, CacheControl cache, String title, boolean isMoving) {
        this(bw, width, height, sources, converterSetups, viewerSettings, cache, new KeymapManager(BigWarp.configDir), new AppearanceManager(BigWarp.configDir), BigWarpViewerOptions.options(), title, isMoving);
    }

    public BigWarpViewerFrame(BigWarp<?> bw, int width, int height, List<SourceAndConverter<?>> sources, List<ConverterSetup> converterSetups, BigWarpViewerSettings viewerSettings, CacheControl cache, KeymapManager keymapManager, AppearanceManager appearanceManager, BigWarpViewerOptions optional, String title, boolean isMoving) {
        super(title, AWTUtils.getSuitableGraphicsConfiguration((ColorModel)AWTUtils.RGB_COLOR_MODEL));
        this.bw = bw;
        this.keymapManager = keymapManager;
        this.appearanceManager = appearanceManager;
        this.viewer = new BigWarpViewerPanel(bw.getData(), viewerSettings, cache, optional.size(width / 2, height), isMoving);
        this.setups = new ConverterSetups((ViewerState)this.viewer.state());
        this.setups.listeners().add(s -> this.viewer.requestRepaint());
        if (converterSetups.size() != bw.getData().sources.size()) {
            System.err.println("WARNING! Constructing BigWarp with converterSetups.size() that is not the same as sources.size().");
        }
        int numSetups = Math.min(converterSetups.size(), bw.getData().sources.size());
        for (int i = 0; i < numSetups; ++i) {
            SourceAndConverter source = bw.getData().sources.get(i);
            ConverterSetup setup = converterSetups.get(i);
            if (setup == null) continue;
            this.setups.put(source, setup);
        }
        if (!isMoving && bw.getData().numTargetSources() > 0) {
            this.viewer.state().setCurrentSource(bw.getData().getTargetSource(0));
        }
        this.keybindings = new InputActionBindings();
        this.triggerbindings = new TriggerBehaviourBindings();
        this.cards = new CardPanel();
        BdvDefaultCards.setup((CardPanel)this.cards, (AbstractViewerPanel)this.viewer, (ConverterSetups)this.setups);
        this.splitPanel = new SplitPanel((AbstractViewerPanel)this.viewer, this.cards);
        this.getRootPane().setDoubleBuffered(true);
        this.add((Component)this.splitPanel, "Center");
        this.pack();
        this.setPreferredSize(new Dimension(width, height));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BigWarpViewerFrame.this.bw.closeAll();
            }
        });
        bw.getLandmarkPanel().getJTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BigWarpViewerFrame.this.viewer.requestRepaint();
            }
        });
        SwingUtilities.replaceUIActionMap((JComponent)((Object)this.viewer), this.keybindings.getConcatenatedActionMap());
        SwingUtilities.replaceUIInputMap((JComponent)((Object)this.viewer), 1, this.keybindings.getConcatenatedInputMap());
        MouseAndKeyHandler mouseAndKeyHandler = new MouseAndKeyHandler();
        mouseAndKeyHandler.setInputMap(this.triggerbindings.getConcatenatedInputTriggerMap());
        mouseAndKeyHandler.setBehaviourMap(this.triggerbindings.getConcatenatedBehaviourMap());
        mouseAndKeyHandler.setKeypressManager(optional.values.getKeyPressedManager(), this.viewer.getDisplayComponent());
        this.viewer.getDisplay().addHandler((Object)mouseAndKeyHandler);
        this.transformBehaviours = new Behaviours((InputTriggerAdder.Factory)optional.values.getInputTriggerConfig(), new String[]{"bigwarp", "navigation"});
        this.updateTransformBehaviors(optional);
    }

    public void updateTransformBehaviors(BigWarpViewerOptions optional) {
        Behaviours transformBehaviours = new Behaviours((InputTriggerAdder.Factory)optional.values.getInputTriggerConfig(), new String[]{"bdv"});
        transformBehaviours.install(this.triggerbindings, "transform");
        TransformEventHandler tfHandler = this.viewer.getTransformEventHandler();
        tfHandler.install(transformBehaviours);
        this.viewer.getDisplay().setTransformEventHandler(tfHandler);
    }

    public boolean isMoving() {
        return this.viewer.getIsMoving();
    }

    public BigWarpViewerPanel getViewerPanel() {
        return this.viewer;
    }

    public CardPanel getCardPanel() {
        return this.cards;
    }

    public SplitPanel getSplitPanel() {
        return this.splitPanel;
    }

    public ConverterSetups getConverterSetups() {
        return this.setups;
    }

    public void expandAndFocusCardPanel() {
        this.getSplitPanel().setCollapsed(false);
        this.getSplitPanel().getRightComponent().requestFocusInWindow();
    }

    public void collapseCardPanel() {
        this.getSplitPanel().setCollapsed(true);
        this.viewer.requestFocusInWindow();
    }

    public InputActionBindings getKeybindings() {
        return this.keybindings;
    }

    public TriggerBehaviourBindings getTriggerBindings() {
        return this.triggerbindings;
    }

    public void setTransformEnabled(boolean enabled) {
        this.viewer.setTransformEnabled(enabled);
        if (enabled) {
            this.triggerbindings.removeInputTriggerMap("block_transform");
        } else {
            this.triggerbindings.addInputTriggerMap("block_transform", new InputTriggerMap(), new String[]{"transform"});
        }
    }

    public Behaviours getTransformBehaviours() {
        return this.transformBehaviours;
    }
}

