/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.viewer.BigWarpViewerPanel;
import bigwarp.BigWarp;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;

public class BigWarpDragOverlay {
    private BigWarp<?> bw;
    private BigWarpViewerPanel viewer;
    private boolean inProgress = false;
    private boolean completedOK = false;
    private final RealPoint movingPoint;
    private final RealPoint targetPoint;
    private final RealPoint movingPointScreen;
    private final RealPoint targetPointScreen;
    WarpDragMouseListener mouseListener;
    private final AffineTransform3D transform = new AffineTransform3D();
    final int ndim;
    private double arad = 4.0;
    private Color baseColor;

    public BigWarpDragOverlay(BigWarp<?> bw, BigWarpViewerPanel viewer, BigWarp.SolveThread solveThread) {
        this.bw = bw;
        this.viewer = viewer;
        this.ndim = 3;
        this.movingPoint = new RealPoint(3);
        this.targetPoint = new RealPoint(3);
        this.movingPointScreen = new RealPoint(3);
        this.targetPointScreen = new RealPoint(3);
        this.arad = viewer.getSettings().getSpotSize();
        this.baseColor = viewer.getSettings().getSpotColor();
        this.mouseListener = new WarpDragMouseListener(bw, viewer, solveThread);
    }

    public void reset() {
        this.completedOK = false;
    }

    public void paint(Graphics2D g) {
        this.arad = this.viewer.getSettings().getSpotSize();
        this.baseColor = this.viewer.getSettings().getSpotColor();
        if (this.inProgress) {
            this.viewer.state().getViewerTransform(this.transform);
            this.transform.apply((RealLocalizable)this.movingPoint, (RealPositionable)this.movingPointScreen);
            this.transform.apply((RealLocalizable)this.targetPoint, (RealPositionable)this.targetPointScreen);
            g.setColor(this.baseColor.brighter());
            g.fillRect((int)(this.movingPointScreen.getDoublePosition(0) - this.arad), (int)(this.movingPointScreen.getDoublePosition(1) - this.arad), (int)(2.0 * this.arad), (int)(2.0 * this.arad));
            g.setColor(this.baseColor.darker());
            g.fillRect((int)(this.targetPointScreen.getDoublePosition(0) - this.arad), (int)(this.targetPointScreen.getDoublePosition(1) - this.arad), (int)(2.0 * this.arad), (int)(2.0 * this.arad));
            g.setColor(this.baseColor);
            g.drawLine((int)this.movingPointScreen.getDoublePosition(0), (int)this.movingPointScreen.getDoublePosition(1), (int)this.targetPointScreen.getDoublePosition(0), (int)this.targetPointScreen.getDoublePosition(1));
        }
    }

    protected class WarpDragMouseListener
    implements MouseListener,
    MouseMotionListener {
        private BigWarp bw;
        private BigWarpViewerPanel thisViewer;
        private int index;
        double[] targetPtArray;
        private final BigWarp.SolveThread solverThread;

        public WarpDragMouseListener(BigWarp bw, BigWarpViewerPanel thisViewer, BigWarp.SolveThread solverThread) {
            this.targetPtArray = new double[BigWarpDragOverlay.this.ndim];
            this.bw = bw;
            this.setViewer(thisViewer);
            thisViewer.getDisplay().addHandler((Object)this);
            this.solverThread = solverThread;
        }

        protected void setViewer(BigWarpViewerPanel thisViewer) {
            this.thisViewer = thisViewer;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.thisViewer.isMoving && !this.bw.isMovingDisplayTransformed()) {
                return;
            }
            if (this.bw.isInLandmarkMode() && this.bw.isRowIncomplete()) {
                return;
            }
            if (this.bw.isInLandmarkMode() && e.isShiftDown()) {
                this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarpDragOverlay.this.movingPoint);
                this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarpDragOverlay.this.targetPoint);
                double[] movingPtArray = new double[BigWarpDragOverlay.this.ndim];
                BigWarpDragOverlay.this.movingPoint.localize(movingPtArray);
                this.bw.getLandmarkPanel().getTableModel().pointEdit(-1, movingPtArray, true, true, true, true, (RealTransform)this.bw.getBwTransform().getTransformation());
                this.index = this.bw.getLandmarkPanel().getTableModel().getRowCount() - 1;
                this.bw.getLandmarkPanel().getTableModel().pointEdit(this.index, movingPtArray, false, false, false, false, (RealTransform)this.bw.getBwTransform().getTransformation());
                BigWarpDragOverlay.this.inProgress = true;
                BigWarpDragOverlay.this.completedOK = false;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.bw.isInLandmarkMode() && this.bw.isRowIncomplete()) {
                return;
            }
            if (this.bw.isInLandmarkMode() && e.isShiftDown()) {
                BigWarpDragOverlay.this.completedOK = true;
                BigWarpDragOverlay.this.reset();
                this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarpDragOverlay.this.targetPoint);
                BigWarpDragOverlay.this.targetPoint.localize(this.targetPtArray);
                this.bw.getLandmarkPanel().getTableModel().pointEdit(this.index, this.targetPtArray, false, false, false, true, (RealTransform)this.bw.getBwTransform().getTransformation());
                if (this.bw.isUpdateWarpOnChange()) {
                    this.bw.restimateTransformation();
                }
            } else {
                BigWarpDragOverlay.this.reset();
            }
            BigWarpDragOverlay.this.inProgress = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.bw.isInLandmarkMode() && e.isShiftDown()) {
                this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarpDragOverlay.this.targetPoint);
                BigWarpDragOverlay.this.targetPoint.localize(this.targetPtArray);
                if (this.bw.isMovingDisplayTransformed() && this.bw.getLandmarkPanel().getTableModel().isActive(this.index)) {
                    this.solverThread.requestResolve(false, this.index, this.targetPtArray);
                }
                this.thisViewer.requestRepaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

