/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class NIOShortArray
implements ArrayDataAccess<NIOShortArray>,
ShortAccess {
    protected ShortBuffer data;

    public NIOShortArray(int numEntities) {
        this.data = ByteBuffer.allocateDirect(numEntities * 8).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    public NIOShortArray(short[] data) {
        ShortBuffer bufferIn = ShortBuffer.wrap(data);
        ShortBuffer copy = ByteBuffer.allocateDirect(bufferIn.capacity()).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.data = copy.put(bufferIn);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public short getValue(int index) {
        return this.data.get(index);
    }

    @Override
    public void setValue(int index, short value) {
        this.data.put(index, value);
    }

    public short[] getCurrentStorageArray() {
        short[] outData = new short[this.data.capacity()];
        this.data.get(outData);
        return outData;
    }

    @Override
    public NIOShortArray createArray(int numEntities) {
        return new NIOShortArray(numEntities);
    }
}

