/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.HashMap;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;

public class N5ViewerMultiscaleMetadataParser
implements N5MetadataParser<N5MultiScaleMetadata> {
    @Override
    public Optional<N5MultiScaleMetadata> parseMetadata(N5Reader reader, N5TreeNode node) {
        HashMap<String, N5TreeNode> scaleLevelNodes = new HashMap<String, N5TreeNode>();
        for (N5TreeNode childNode : node.childrenList()) {
            if (!MultiscaleMetadata.scaleLevelPredicate.test(childNode.getNodeName()) || !childNode.isDataset() || !(childNode.getMetadata() instanceof N5SingleScaleMetadata)) continue;
            scaleLevelNodes.put(childNode.getNodeName(), childNode);
        }
        if (scaleLevelNodes.isEmpty()) {
            return Optional.empty();
        }
        N5DatasetMetadata[] childMetadata = (N5SingleScaleMetadata[])scaleLevelNodes.values().stream().map(N5TreeNode::getMetadata).toArray(N5SingleScaleMetadata[]::new);
        MultiscaleMetadata.sortScaleMetadata((N5DatasetMetadata[])childMetadata);
        return Optional.of(new N5MultiScaleMetadata(node.getPath(), (N5SingleScaleMetadata[])childMetadata));
    }
}

