/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.transforms;

import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale2D;
import net.imglib2.realtransform.Scale3D;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.AbstractLinearSpatialTransform;

public class ScaleSpatialTransform
extends AbstractLinearSpatialTransform<double[]> {
    public double[] scale;
    public transient AffineGet transform;

    public ScaleSpatialTransform(double[] scale) {
        super("scale");
        this.scale = scale;
        this.buildTransform(scale);
    }

    public ScaleSpatialTransform(N5Reader n5, String path) {
        super("scale", path);
        this.scale = this.getParameters(n5);
        this.buildTransform(this.scale);
    }

    public ScaleSpatialTransform(String path) {
        super("scale", path);
        this.scale = null;
    }

    @Override
    public AffineGet buildTransform(double[] parameters) {
        this.scale = parameters;
        this.transform = parameters.length == 2 ? new Scale2D(parameters) : (parameters.length == 3 ? new Scale3D(parameters) : new Scale(parameters));
        return this.transform;
    }

    @Override
    public AffineGet getTransform() {
        if (this.transform == null && this.scale != null) {
            this.buildTransform(this.scale);
        }
        return this.transform;
    }

    @Override
    public double[] getParameters(N5Reader n5) {
        return ScaleSpatialTransform.getDoubleArray(n5, this.getParameterPath());
    }
}

