/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.metrics;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import trainableSegmentation.metrics.Metrics;
import trainableSegmentation.utils.Utils;

public class AdjustedRandError
extends Metrics {
    public AdjustedRandError(ImagePlus originalLabels, ImagePlus proposedLabels) {
        super(originalLabels, proposedLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMetricValue(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double randError = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getAdjustedRandErrorConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                randError += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating rand error in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return randError / (double)labelSlices.getSize();
    }

    public static double adjustedRandError(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(proposal.getWidth(), proposal.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ImagePlus im1 = new ImagePlus("binary labels", (ImageProcessor)binaryLabel);
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)im1, (int)4).allRegions.getProcessor();
        ImagePlus im2 = new ImagePlus("proposal labels", (ImageProcessor)binaryProposal);
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)im2, (int)4).allRegions.getProcessor();
        return 1.0 - AdjustedRandError.adjustedRandIndex(components1, components2);
    }

    public Callable<Double> getAdjustedRandErrorConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return AdjustedRandError.adjustedRandError(image1, image2, binaryThreshold);
            }
        };
    }

    public static double adjustedRandIndex(ShortProcessor cluster1, ShortProcessor cluster2) {
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = pixels1.length;
        int[][] cont = new int[(int)cluster1.getMax()][(int)cluster2.getMax()];
        int i = 0;
        while ((double)i < n) {
            int[] nArray = cont[pixels1[i]];
            short s = pixels2[i];
            nArray[s] = nArray[s] + 1;
            ++i;
        }
        double t2 = 0.0;
        double[] ni = new double[cont.length];
        for (int i2 = 0; i2 < cont.length; ++i2) {
            for (int j = 0; j < cont[i2].length; ++j) {
                int n2 = i2;
                ni[n2] = ni[n2] + (double)cont[i2][j];
            }
        }
        double nis = 0.0;
        for (int k = 0; k < ni.length; ++k) {
            nis += ni[k] * ni[k];
        }
        double[] nj = new double[cont.length];
        for (int j = 0; j < cont[0].length; ++j) {
            for (int i3 = 0; i3 < cont.length; ++i3) {
                int n3 = j;
                nj[n3] = nj[n3] + (double)cont[i3][j];
                t2 += (double)(cont[i3][j] * cont[i3][j]);
            }
        }
        double njs = 0.0;
        for (int k = 0; k < nj.length; ++k) {
            njs += nj[k] * nj[k];
        }
        double t1 = n * (n - 1.0) / 2.0;
        double t3 = 0.5 * (nis + njs);
        double nc = (n * (n * n + 1.0) - (n + 1.0) * nis - (n + 1.0) * njs + 2.0 * (nis * njs) / n) / (2.0 * (n - 1.0));
        double agreements = t1 + t2 - t3;
        double adjustedRandIndex = t1 == nc ? 0.0 : (agreements - nc) / (t1 - nc);
        return adjustedRandIndex;
    }
}

