/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.audioengines;

import java.util.ArrayList;
import org.jogamp.java3d.AudioDevice3D;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.audioengines.AudioEngine;
import org.jogamp.java3d.audioengines.AuralParameters;
import org.jogamp.java3d.audioengines.Sample;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public abstract class AudioEngine3D
extends AudioEngine
implements AudioDevice3D {
    protected ArrayList samples = new ArrayList(64);
    protected View currentView = null;
    protected AuralParameters attribs = new AuralParameters();

    public AudioEngine3D(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    @Override
    public void setView(View reference) {
        this.currentView = reference;
    }

    public View getView() {
        return this.currentView;
    }

    @Override
    public int prepareSound(int soundType, MediaContainer soundData) {
        return -1;
    }

    @Override
    public abstract void clearSound(int var1);

    @Override
    public void setVworldXfrm(int index, Transform3D trans) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.vworldXfrm.set(trans);
        }
    }

    @Override
    public abstract int startSample(int var1);

    @Override
    public abstract int stopSample(int var1);

    @Override
    public abstract void updateSample(int var1);

    @Override
    public abstract void muteSample(int var1);

    @Override
    public abstract void unmuteSample(int var1);

    @Override
    public abstract void pauseSample(int var1);

    @Override
    public abstract void unpauseSample(int var1);

    @Override
    public void setSampleGain(int index, float scaleFactor) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setGain(scaleFactor);
        }
    }

    @Override
    public void setLoop(int index, int count) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setLoopCount(count);
        }
    }

    @Override
    public void setPosition(int index, Point3d position) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setPosition(position);
        }
    }

    @Override
    public void setDistanceGain(int index, double[] frontDistance, float[] frontAttenuationScaleFactor, double[] backDistance, float[] backAttenuationScaleFactor) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setDistanceGain(frontDistance, frontAttenuationScaleFactor, backDistance, backAttenuationScaleFactor);
        }
    }

    @Override
    public void setDirection(int index, Vector3d direction) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setDirection(direction);
        }
    }

    @Override
    public void setAngularAttenuation(int index, int filterType, double[] angle, float[] attenuationScaleFactor, float[] filterCutoff) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setAngularAttenuation(filterType, angle, attenuationScaleFactor, filterCutoff);
        }
    }

    @Override
    public void setRolloff(float rolloff) {
        this.attribs.rolloff = rolloff;
    }

    @Override
    public void setReflectionCoefficient(float coefficient) {
        this.attribs.reflectionCoefficient = coefficient;
    }

    @Override
    public void setReverbDelay(float reverbDelay) {
        this.attribs.reverbDelay = reverbDelay;
    }

    @Override
    public void setReverbOrder(int reverbOrder) {
        this.attribs.reverbOrder = reverbOrder;
    }

    @Override
    public void setDistanceFilter(int filterType, double[] dist, float[] filterCutoff) {
        this.attribs.setDistanceFilter(filterType, dist, filterCutoff);
    }

    @Override
    public void setFrequencyScaleFactor(float scaleFactor) {
        this.attribs.frequencyScaleFactor = scaleFactor;
    }

    @Override
    public void setVelocityScaleFactor(float scaleFactor) {
        this.attribs.velocityScaleFactor = scaleFactor;
    }

    @Override
    public int getNumberOfChannelsUsed(int index) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    @Override
    public int getNumberOfChannelsUsed(int index, boolean muteFlag) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    @Override
    public long getSampleDuration(int index) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getDuration();
        }
        return 0L;
    }

    @Override
    public long getStartTime(int index) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getStartTime();
        }
        return 0L;
    }

    protected ArrayList getSampleList() {
        return this.samples;
    }

    public int getSampleListSize() {
        return this.samples.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int index) {
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            if (index >= 0 && index < this.samples.size()) {
                Sample sample = (Sample)this.samples.get(index);
                return sample;
            }
            return null;
        }
    }

    public AuralParameters getAuralParameters() {
        return this.attribs;
    }
}

