/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterHelpers;
import ucar.nc2.filter.FilterProvider;

public class ScaleOffset
extends Filter
implements Enhancement {
    private static final String name = "fixedscaleoffset";
    private static final int id = 6;
    private static Map<String, DataType> dTypeMap = new HashMap<String, DataType>();
    private final double offset;
    private final double scale;
    private static final double DEFAULT_OFFSET = 0.0;
    private static final double DEFAULT_SCALE = 1.0;
    private final ByteOrder dtypeOrder;
    private final DataType dtype;
    private final DataType astype;
    private final ByteOrder astypeOrder;

    public static ScaleOffset createFromVariable(VariableDS var) {
        Attribute offsetAtt;
        DataType scaleType = null;
        DataType offsetType = null;
        double scale = 1.0;
        double offset = 0.0;
        DataType origDataType = var.getDataType();
        DataType.Signedness signedness = var.getSignedness();
        Attribute scaleAtt = var.findAttribute("scale_factor");
        if (scaleAtt != null && !scaleAtt.isString()) {
            scaleType = FilterHelpers.getAttributeDataType(scaleAtt, signedness);
            scale = 1.0 / var.convertUnsigned(scaleAtt.getNumericValue(), scaleType).doubleValue();
            var.remove(scaleAtt);
        }
        if ((offsetAtt = var.findAttribute("add_offset")) != null && !offsetAtt.isString()) {
            offsetType = FilterHelpers.getAttributeDataType(offsetAtt, signedness);
            offset = var.convertUnsigned(offsetAtt.getNumericValue(), offsetType).doubleValue();
            var.remove(offsetAtt);
        }
        if (scale != 1.0 || offset != 0.0) {
            DataType scaledOffsetType = FilterHelpers.largestOf(var.getUnsignedConversionType(), scaleType, offsetType).withSignedness(signedness);
            HashMap<String, Object> scaleOffsetProps = new HashMap<String, Object>();
            scaleOffsetProps.put("offset", offset);
            scaleOffsetProps.put("scale", scale);
            scaleOffsetProps.put("dtype", (Object)scaledOffsetType);
            scaleOffsetProps.put("astype", (Object)origDataType);
            return new ScaleOffset(scaleOffsetProps);
        }
        return null;
    }

    public ScaleOffset(Map<String, Object> properties) {
        this.offset = ((Number)properties.getOrDefault("offset", 0.0)).doubleValue();
        this.scale = ((Number)properties.getOrDefault("scale", 1.0)).doubleValue();
        Object typeProp = properties.get("dtype");
        if (typeProp instanceof String) {
            String type = (String)typeProp;
            this.dtype = ScaleOffset.parseDataType(type);
            if (this.dtype == null) {
                throw new RuntimeException("ScaleOffset error: could not parse dtype");
            }
            this.dtypeOrder = ScaleOffset.parseByteOrder(type, ByteOrder.LITTLE_ENDIAN);
        } else if (typeProp instanceof DataType) {
            this.dtype = (DataType)((Object)typeProp);
            this.dtypeOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            throw new RuntimeException("ScaleOffset error: could not parse dtype");
        }
        Object aTypeProp = properties.getOrDefault("astype", null);
        if (aTypeProp instanceof String) {
            String aType = aTypeProp;
            this.astype = ScaleOffset.parseDataType(aType);
            this.astypeOrder = ScaleOffset.parseByteOrder(aType, this.dtypeOrder);
        } else if (aTypeProp instanceof DataType) {
            this.astype = aTypeProp;
            this.astypeOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            this.astype = this.dtype;
            this.astypeOrder = this.dtypeOrder;
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getId() {
        return 6;
    }

    public double getScaleFactor() {
        return this.scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public DataType getScaledOffsetType() {
        return this.dtype;
    }

    @Override
    public byte[] encode(byte[] dataIn) {
        if (this.scale == 1.0 && this.offset == 0.0) {
            return dataIn;
        }
        Array out = this.applyScaleOffset(FilterHelpers.bytesToArray(dataIn, this.dtype, this.dtypeOrder));
        return FilterHelpers.arrayToBytes(out, this.astype, this.astypeOrder);
    }

    @Override
    public byte[] decode(byte[] dataIn) {
        if (this.scale == 1.0 && this.offset == 0.0) {
            return dataIn;
        }
        Array out = this.convert(FilterHelpers.bytesToArray(dataIn, this.astype, this.astypeOrder));
        return FilterHelpers.arrayToBytes(out, this.dtype, this.dtypeOrder);
    }

    public Array applyScaleOffset(Array in) {
        if (this.scale == 1.0 && this.offset == 0.0) {
            return in;
        }
        DataType outType = this.astype;
        if (this.astype.getSignedness() == DataType.Signedness.UNSIGNED) {
            outType = FilterHelpers.nextLarger(this.astype).withSignedness(DataType.Signedness.UNSIGNED);
        }
        Array out = Array.factory(outType, in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        while (iterIn.hasNext()) {
            Number value = this.convertUnsigned((Number)iterIn.getObjectNext(), this.dtype.getSignedness());
            double newVal = this.applyScaleOffset(value.doubleValue());
            iterOut.setObjectNext(newVal);
        }
        return out;
    }

    public Array convert(Array in) {
        if (this.scale == 1.0 && this.offset == 0.0) {
            return in;
        }
        DataType outType = this.dtype;
        if (this.dtype.getSignedness() == DataType.Signedness.UNSIGNED) {
            outType = FilterHelpers.nextLarger(this.dtype).withSignedness(DataType.Signedness.UNSIGNED);
        }
        Array out = Array.factory(outType, in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        while (iterIn.hasNext()) {
            Number value = (Number)iterIn.getObjectNext();
            value = this.convertUnsigned(value, this.astype.getSignedness());
            value = this.convert(value.doubleValue());
            iterOut.setObjectNext(value);
        }
        return out;
    }

    private static DataType parseDataType(String dtype) {
        dtype = dtype.replace(">", "");
        dtype = dtype.replace("<", "");
        dtype = dtype.replace("|", "");
        return dTypeMap.getOrDefault(dtype, null);
    }

    private static ByteOrder parseByteOrder(String dtype, ByteOrder defaultOrder) {
        if (dtype.startsWith(">")) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (dtype.startsWith("<")) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        if (dtype.startsWith("|")) {
            return ByteOrder.nativeOrder();
        }
        return defaultOrder;
    }

    public double applyScaleOffset(double value) {
        if (this.astype.isIntegral()) {
            return Math.round((value - this.offset) * this.scale);
        }
        return (value - this.offset) * this.scale;
    }

    @Override
    public double convert(double value) {
        if (this.dtype.isIntegral()) {
            return Math.round(value / this.scale + this.offset);
        }
        return value / this.scale + this.offset;
    }

    private Number convertUnsigned(Number value, DataType.Signedness signedness) {
        if (signedness == DataType.Signedness.UNSIGNED) {
            return DataType.widenNumberIfNegative(value);
        }
        return value;
    }

    static {
        dTypeMap.put("i1", DataType.BYTE);
        dTypeMap.put("u1", DataType.UBYTE);
        dTypeMap.put("i2", DataType.SHORT);
        dTypeMap.put("u2", DataType.USHORT);
        dTypeMap.put("i4", DataType.INT);
        dTypeMap.put("f4", DataType.FLOAT);
        dTypeMap.put("u4", DataType.UINT);
        dTypeMap.put("i8", DataType.LONG);
        dTypeMap.put("f8", DataType.DOUBLE);
        dTypeMap.put("u8", DataType.ULONG);
    }

    public static class Provider
    implements FilterProvider {
        @Override
        public String getName() {
            return ScaleOffset.name;
        }

        @Override
        public int getId() {
            return 6;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new ScaleOffset(properties);
        }
    }

    public static class Keys {
        public static final String OFFSET_KEY = "offset";
        public static final String SCALE_KEY = "scale";
        public static final String DTYPE_KEY = "dtype";
        public static final String ASTYPE_KEY = "astype";
    }
}

