/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imglib2.roi.RectangleRegionOfInterest;
import org.scijava.Context;

public class RectangleOverlay
extends AbstractROIOverlay<RectangleRegionOfInterest> {
    private static final long serialVersionUID = 1L;

    public RectangleOverlay() {
        super(new RectangleRegionOfInterest(new double[]{0.0, 0.0}, new double[]{0.0, 0.0}));
    }

    public RectangleOverlay(Context context) {
        super(context, new RectangleRegionOfInterest(new double[]{0.0, 0.0}, new double[]{0.0, 0.0}));
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        RectangleRegionOfInterest roi = (RectangleRegionOfInterest)this.getRegionOfInterest();
        out.writeDouble(roi.getOrigin(0));
        out.writeDouble(roi.getOrigin(1));
        out.writeDouble(roi.getExtent(0));
        out.writeDouble(roi.getExtent(1));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        RectangleRegionOfInterest roi = (RectangleRegionOfInterest)this.getRegionOfInterest();
        roi.setOrigin(in.readDouble(), 0);
        roi.setOrigin(in.readDouble(), 1);
        roi.setExtent(in.readDouble(), 0);
        roi.setExtent(in.readDouble(), 1);
    }

    @Override
    public void move(double[] deltas) {
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).move(deltas);
    }

    public void setOrigin(double val, int dim) {
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).setOrigin(val, dim);
    }

    public void setExtent(double val, int dim) {
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).setExtent(val, dim);
    }

    public double getOrigin(int dim) {
        return ((RectangleRegionOfInterest)this.getRegionOfInterest()).getOrigin(dim);
    }

    public double getExtent(int dim) {
        return ((RectangleRegionOfInterest)this.getRegionOfInterest()).getExtent(dim);
    }
}

