/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import amira.AmiraMeshEncoder;
import fiji.geom.AreaCalculations;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.AreaWrapper;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.display.paint.USHORTPaint;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.AreaUtils;
import ini.trakem2.utils.CircularSequence;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import mpicbg.models.CoordinateTransform;
import org.jogamp.vecmath.Point3f;

public class AreaList
extends ZDisplayable
implements AreaContainer,
VectorData {
    private HashMap<Long, Area> ht_areas = new HashMap();
    private static final Area UNLOADED = new Area();
    private boolean fill_paint = true;
    private AreaWrapper aw = null;
    private Long lid = null;

    public AreaList(Project project, String title, double x, double y) {
        super(project, title, x, y);
        this.alpha = AreaWrapper.PP.default_alpha;
        this.addToDatabase();
    }

    public AreaList(Project project, long id, HashMap<String, String> ht_attributes, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attributes, ht_links);
        String ob_data = ht_attributes.get("fill_paint");
        try {
            if (null != ob_data) {
                this.fill_paint = "true".equals(ob_data.trim().toLowerCase());
            }
        }
        catch (Exception e) {
            Utils.log("AreaList: could not read fill_paint value from XML:" + e);
        }
    }

    public AreaList(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, ArrayList<Long> al_ul, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.alpha = alpha;
        this.visible = visible;
        this.color = color;
        for (Long lid : al_ul) {
            this.ht_areas.put(lid, UNLOADED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        Composite original_composite = null;
        try {
            if (this.layer_set.area_color_cues) {
                original_composite = g.getComposite();
                Color c = this.layer_set.use_color_cue_colors ? Color.red : this.color;
                g.setComposite(AlphaComposite.getInstance(3, Math.min(this.alpha, 0.25f)));
                for (Layer la : layers) {
                    if (active_layer == la) {
                        c = this.layer_set.use_color_cue_colors ? Color.blue : this.color;
                        continue;
                    }
                    Area area = this.ht_areas.get(la.getId());
                    if (null == area || UNLOADED == area && null == (area = this.loadLayer(la.getId()))) continue;
                    g.setColor(c);
                    if (this.fill_paint) {
                        g.fill(area.createTransformedArea(this.at));
                        continue;
                    }
                    g.draw(area.createTransformedArea(this.at));
                }
                if (1.0f == this.alpha) {
                    g.setComposite(original_composite);
                }
            }
            if (this.alpha != 1.0f) {
                if (null == original_composite) {
                    original_composite = g.getComposite();
                }
                g.setComposite(AlphaComposite.getInstance(3, this.alpha));
            }
            if (null != this.aw) {
                this.aw.paint(g, this.at, this.fill_paint, this.color);
            } else {
                Area area = this.ht_areas.get(active_layer.getId());
                if (null == area) {
                    return;
                }
                if (UNLOADED == area && null == (area = this.loadLayer(active_layer.getId()))) {
                    return;
                }
                g.setColor(this.color);
                if (this.fill_paint) {
                    g.fill(area.createTransformedArea(this.at));
                } else {
                    g.draw(area.createTransformedArea(this.at));
                }
            }
        }
        finally {
            if (null != original_composite) {
                g.setComposite(original_composite);
            }
        }
    }

    @Override
    public void transformPoints(Layer layer, double dx, double dy, double rot, double xo, double yo) {
        Utils.log("AreaList.transformPoints: not implemented yet.");
    }

    @Override
    public Layer getFirstLayer() {
        double min_z = Double.MAX_VALUE;
        Layer first_layer = null;
        for (Long lid : this.ht_areas.keySet()) {
            Layer la = this.layer_set.getLayer((long)lid);
            double z = la.getZ();
            if (!(z < min_z)) continue;
            min_z = z;
            first_layer = la;
        }
        return first_layer;
    }

    public Layer getLastLayer() {
        double max_z = -1.7976931348623157E308;
        Layer last_layer = null;
        for (Long lid : this.ht_areas.keySet()) {
            Layer la = this.layer_set.getLayer((long)lid);
            double z = la.getZ();
            if (!(z > max_z)) continue;
            max_z = z;
            last_layer = la;
        }
        return last_layer;
    }

    public List<Layer> getLayerRange() {
        return this.layer_set.getLayers(this.getFirstLayer(), this.getLastLayer());
    }

    @Override
    public boolean linkPatches() {
        this.unlinkAll(Patch.class);
        Rectangle r = new Rectangle();
        boolean must_lock = false;
        for (Map.Entry<Long, Area> e : this.ht_areas.entrySet()) {
            Layer la = this.layer_set.getLayer(e.getKey());
            if (null == la) {
                Utils.log2("AreaList.linkPatches: ignoring null layer for id " + e.getKey());
                continue;
            }
            Area area = e.getValue().createTransformedArea(this.at);
            for (Patch d : la.getAll(Patch.class)) {
                r = d.getBoundingBox(r);
                if (!area.intersects(r)) continue;
                this.link(d, true);
                if (!d.locked) continue;
                must_lock = true;
            }
        }
        if (must_lock && !this.locked) {
            this.setLocked(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Layer layer, double x, double y) {
        Area ob = this.ht_areas.get(new Long(layer.getId()));
        if (null == ob) {
            return false;
        }
        if (UNLOADED == ob && null == (ob = this.loadLayer(layer.getId()))) {
            return false;
        }
        Area area = ob;
        if (!this.at.isIdentity()) {
            area = area.createTransformedArea(this.at);
        }
        return area.contains(x, y);
    }

    @Override
    public boolean intersects(Layer layer, Rectangle r) {
        Area ob = this.ht_areas.get(layer.getId());
        if (null == ob) {
            return false;
        }
        if (UNLOADED == ob && null == (ob = this.loadLayer(layer.getId()))) {
            return false;
        }
        Area a = ob.createTransformedArea(this.at);
        return a.intersects(r.x, r.y, r.width, r.height);
    }

    @Override
    public boolean intersects(Layer layer, Area area) {
        Area ob = this.ht_areas.get(layer.getId());
        if (null == ob) {
            return false;
        }
        if (UNLOADED == ob && null == (ob = this.loadLayer(layer.getId()))) {
            return false;
        }
        Area a = ob.createTransformedArea(this.at);
        a.intersect(area);
        Rectangle b = a.getBounds();
        return 0 != b.width && 0 != b.height;
    }

    @Override
    public Rectangle getBounds(Rectangle r, Layer layer) {
        if (null == layer) {
            return super.getBounds(r, null);
        }
        Area area = this.ht_areas.get(layer.getId());
        if (null == area) {
            if (null == r) {
                return new Rectangle();
            }
            r.x = 0;
            r.y = 0;
            r.width = 0;
            r.height = 0;
            return r;
        }
        Rectangle b = area.createTransformedArea(this.at).getBounds();
        if (null == r) {
            return b;
        }
        r.setBounds(b.x, b.y, b.width, b.height);
        return r;
    }

    @Override
    public boolean isDeletable() {
        return 0 == this.ht_areas.size();
    }

    @Override
    public void mousePressed(MouseEvent me, final Layer la, int x_p_w, int y_p_w, double mag) {
        this.lid = la.getId();
        Area ob = this.ht_areas.get(new Long(this.lid));
        Area area = null;
        if (null == ob) {
            area = new Area();
            this.ht_areas.put(new Long(this.lid), area);
            this.width = this.layer_set.getLayerWidth();
            this.height = this.layer_set.getLayerHeight();
        } else {
            if (UNLOADED == ob && null == (ob = this.loadLayer(this.lid))) {
                return;
            }
            area = ob;
        }
        if (ProjectToolbar.getToolId() == 16) {
            ProjectToolbar.setTool(17);
        }
        this.aw = new AreaWrapper(area);
        this.aw.setSource(this);
        final Area a = this.aw.getArea();
        final Long lid = this.lid;
        this.aw.mousePressed(me, la, x_p_w, y_p_w, mag, Arrays.asList(new Runnable(){

            @Override
            public void run() {
                Rectangle bounds = a.getBounds();
                if (0 == bounds.width && 0 == bounds.height) {
                    AreaList.this.ht_areas.remove(lid);
                }
                AreaList.this.calculateBoundingBox(la);
            }
        }));
        this.aw.setSource(null);
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        if (null == this.aw) {
            return;
        }
        this.aw.setSource(this);
        this.aw.mouseDragged(me, la, x_p, y_p, x_d, y_d, x_d_old, y_d_old);
        this.aw.setSource(null);
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        if (null == this.aw) {
            return;
        }
        this.aw.setSource(this);
        this.aw.mouseReleased(me, la, x_p, y_p, x_d, y_d, x_r, y_r);
        this.aw.setSource(null);
        this.lid = null;
        this.aw = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean calculateBoundingBox(Layer la) {
        try {
            if (0 == this.ht_areas.size()) {
                boolean bl = false;
                return bl;
            }
            Rectangle box = null;
            for (Area a : this.ht_areas.values()) {
                if (null == a || a.isEmpty()) continue;
                if (null == box) {
                    box = a.getBounds();
                    continue;
                }
                box.add(a.getBounds());
            }
            if (null == box || 0 == box.width || 0 == box.height) {
                boolean bl = false;
                return bl;
            }
            if (0 == box.x && 0 == box.y) {
                this.width = box.width;
                this.height = box.height;
                this.updateInDatabase("dimensions");
                boolean bl = true;
                return bl;
            }
            final AffineTransform atb = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -box.x, -box.y);
            if (this.ht_areas.size() > 1 && (box.width > 2048 || box.height > 2048 || this.ht_areas.size() > 10)) {
                ThreadPoolExecutor exec = Utils.newFixedThreadPool("AreaList-CBB");
                ArrayList fus = new ArrayList();
                for (final Area a : this.ht_areas.values()) {
                    fus.add(exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            a.transform(atb);
                        }
                    }));
                }
                Utils.wait(fus);
                exec.shutdown();
            } else {
                for (Area a : this.ht_areas.values()) {
                    a.transform(atb);
                }
            }
            this.at.translate(box.x, box.y);
            this.width = box.width;
            this.height = box.height;
            this.updateInDatabase("transform+dimensions");
            boolean bl = true;
            return bl;
        }
        finally {
            this.updateBucket(la);
        }
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_area_list";
        if (hs.contains("t2_area_list")) {
            return;
        }
        hs.add("t2_area_list");
        sb_header.append(indent).append("<!ELEMENT t2_area_list (").append(Displayable.commonDTDChildren()).append(",t2_area)>\n");
        Displayable.exportDTD("t2_area_list", sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST t2_area_list fill_paint NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ELEMENT t2_area (t2_path)>\n").append(indent).append("<!ATTLIST t2_area layer_id NMTOKEN #REQUIRED>\n").append(indent).append("<!ELEMENT t2_path EMPTY>\n").append(indent).append("<!ATTLIST t2_path d NMTOKEN #REQUIRED>\n");
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        sb_body.append(indent).append("<t2_area_list\n");
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        sb_body.append(in).append("fill_paint=\"").append(this.fill_paint).append("\"\n");
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("style=\"stroke:none;fill-opacity:").append(this.alpha).append(";fill:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";\"\n");
        sb_body.append(indent).append(">\n");
        for (Map.Entry<Long, Area> entry : this.ht_areas.entrySet()) {
            Area area = entry.getValue();
            if (null == area || area.isEmpty()) continue;
            sb_body.append(in).append("<t2_area layer_id=\"").append(entry.getKey()).append("\">\n");
            AreaList.exportArea(sb_body, in + "\t", area);
            sb_body.append(in).append("</t2_area>\n");
        }
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_area_list>\n");
    }

    static final void exportArea(StringBuilder sb, String indent, Area area) {
        float[] coords = new float[6];
        float precision = 1.0E-4f;
        PathIterator pit = area.getPathIterator(null);
        while (!pit.isDone()) {
            switch (pit.currentSegment(coords)) {
                case 0: {
                    sb.append(indent).append("<t2_path d=\"M ");
                    M.appendShortest(coords[0], 1.0E-4f, sb);
                    sb.append(' ');
                    M.appendShortest(coords[1], 1.0E-4f, sb);
                    break;
                }
                case 1: {
                    sb.append(" L ");
                    M.appendShortest(coords[0], 1.0E-4f, sb);
                    sb.append(' ');
                    M.appendShortest(coords[1], 1.0E-4f, sb);
                    break;
                }
                case 4: {
                    sb.append(" z\" />\n");
                    break;
                }
                default: {
                    Utils.log2("WARNING: AreaList.exportArea unhandled seg type.");
                }
            }
            pit.next();
            if (!pit.isDone()) continue;
            return;
        }
    }

    public ArrayList<ArrayList<Point>> getPaths(long layer_id) {
        Area ob = this.ht_areas.get(layer_id);
        if (null == ob) {
            return null;
        }
        if (UNLOADED == ob && null == (ob = this.loadLayer(layer_id))) {
            return null;
        }
        Area area = ob;
        ArrayList<ArrayList<Point>> al_paths = new ArrayList<ArrayList<Point>>();
        ArrayList<Point> al_points = null;
        PathIterator pit = area.getPathIterator(null);
        while (!pit.isDone()) {
            float[] coords = new float[6];
            int seg_type = pit.currentSegment(coords);
            switch (seg_type) {
                case 0: {
                    al_points = new ArrayList<Point>();
                    al_points.add(new Point((int)coords[0], (int)coords[1]));
                    break;
                }
                case 1: {
                    al_points.add(new Point((int)coords[0], (int)coords[1]));
                    break;
                }
                case 4: {
                    al_paths.add(al_points);
                    al_points = null;
                    break;
                }
                default: {
                    Utils.log2("WARNING: AreaList.getPaths() unhandled seg type.");
                }
            }
            pit.next();
            if (!pit.isDone()) continue;
            break;
        }
        return al_paths;
    }

    public HashMap<Long, ArrayList<ArrayList<Point>>> getAllPaths() {
        HashMap<Long, ArrayList<ArrayList<Point>>> ht = new HashMap<Long, ArrayList<ArrayList<Point>>>();
        for (Map.Entry<Long, Area> entry : this.ht_areas.entrySet()) {
            ht.put(entry.getKey(), this.getPaths(entry.getKey()));
        }
        return ht;
    }

    public void fillHoles(Layer la) {
        Area o = this.ht_areas.get(la.getId());
        if (UNLOADED == o) {
            o = this.loadLayer(la.getId());
        }
        if (null == o) {
            return;
        }
        Area area = o;
        new AreaWrapper(this, area).fillHoles();
    }

    @Override
    public boolean paintsAt(Layer layer) {
        if (!super.paintsAt(layer)) {
            return false;
        }
        return null != this.ht_areas.get(new Long(layer.getId()));
    }

    private Area loadLayer(long layer_id) {
        Area area = this.project.getLoader().fetchArea(this.id, layer_id);
        if (null == area) {
            return null;
        }
        this.ht_areas.put(new Long(layer_id), area);
        return area;
    }

    @Override
    public void adjustProperties() {
        GenericDialog gd = this.makeAdjustPropertiesDialog();
        gd.addCheckbox("Paint as outlines", !this.fill_paint);
        gd.addCheckbox("Apply paint mode to all AreaLists", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        Displayable.DoEdit prev = this.processAdjustPropertiesDialog(gd);
        boolean fp = !gd.getNextBoolean();
        boolean to_all = gd.getNextBoolean();
        if (to_all) {
            for (ZDisplayable zd : this.layer_set.getZDisplayables()) {
                if (zd.getClass() != AreaList.class) continue;
                AreaList ali = (AreaList)zd;
                ali.fill_paint = fp;
                ali.updateInDatabase("fill_paint");
                Display.repaint(this.layer_set, (Displayable)ali, 2);
            }
        } else if (this.fill_paint != fp) {
            prev.add("fill_paint", fp);
            this.fill_paint = fp;
            this.updateInDatabase("fill_paint");
        }
        Displayable.DoEdit current = new Displayable.DoEdit(this).init(prev);
        if (this.isLinked()) {
            current.add(new Displayable.DoTransforms().addAll(this.getLinkedGroup(null)));
        }
        this.getLayerSet().addEditStep(current);
    }

    public boolean isFillPaint() {
        return this.fill_paint;
    }

    public static AreaList merge(ArrayList<Displayable> al) {
        AreaList base = null;
        ArrayList<Displayable> list = new ArrayList<Displayable>(al);
        Iterator<Displayable> it = list.iterator();
        while (it.hasNext()) {
            Displayable displayable = it.next();
            if (displayable.getClass() != AreaList.class) {
                it.remove();
            }
            if (null == base) {
                base = (AreaList)displayable;
                if (null == base.layer_set) {
                    Utils.log2("AreaList.merge: null LayerSet for base AreaList.");
                    return null;
                }
                it.remove();
            }
            AreaList ali = (AreaList)displayable;
            if (base.layer_set == ali.layer_set) continue;
            it.remove();
        }
        if (list.size() < 1) {
            return null;
        }
        for (AreaList areaList : list) {
            base.add(areaList);
            areaList.project.removeProjectThing(areaList, false, true, 1);
            Utils.log2("Merged AreaList " + areaList + " to base " + base);
        }
        base.calculateBoundingBox(null);
        base.linkPatches();
        return base;
    }

    public static ArrayList<AreaList> split(List<Displayable> al) throws Exception {
        ArrayList<AreaList> r = new ArrayList<AreaList>();
        for (Displayable d : al) {
            if (d.getClass() != AreaList.class) continue;
            AreaList ali = (AreaList)d;
            HashSet<AreaList> open = new HashSet<AreaList>();
            HashSet<AreaList> closed = new HashSet<AreaList>();
            Layer prev_layer = null;
            for (Layer layer : ali.getLayerRange()) {
                HashSet<AreaList> touched = new HashSet<AreaList>();
                Area full = ali.getArea(layer);
                if (null != full) {
                    for (Polygon pol : M.getPolygons(full)) {
                        Area area = new Area(pol);
                        if (null != prev_layer) {
                            ArrayList<AreaList> overlap = new ArrayList<AreaList>();
                            for (AreaList areaList : open) {
                                if (!M.intersects(areaList.getArea(prev_layer.getId()), area)) continue;
                                touched.add(areaList);
                                overlap.add(areaList);
                            }
                            switch (overlap.size()) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    ((AreaList)overlap.get(0)).addArea(layer.getId(), area);
                                    area = null;
                                    break;
                                }
                                default: {
                                    AreaList base = (AreaList)overlap.get(0);
                                    for (AreaList o2 : overlap) {
                                        if (o2 == base) continue;
                                        for (long layer_id : o2.getLayerIds()) {
                                            base.addArea(layer_id, o2.getArea(layer_id));
                                        }
                                        open.remove(o2);
                                    }
                                    area = null;
                                }
                            }
                        }
                        if (null == area) continue;
                        AreaList new_ali = new AreaList(ali.project, ali.title, 0.0, 0.0);
                        new_ali.color = ali.color;
                        new_ali.alpha = ali.alpha;
                        new_ali.title = ali.title;
                        new_ali.at.setTransform(ali.at);
                        if (null != ali.props) {
                            for (Map.Entry entry : ali.getProperties().entrySet()) {
                                new_ali.setProperty((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        new_ali.setArea(layer.getId(), area);
                        open.add(new_ali);
                        touched.add(new_ali);
                    }
                }
                Iterator it = open.iterator();
                while (it.hasNext()) {
                    AreaList o = (AreaList)it.next();
                    if (touched.contains(o)) continue;
                    it.remove();
                    closed.add(o);
                }
                prev_layer = layer;
            }
            closed.addAll(open);
            if (closed.size() > 1) {
                r.addAll(closed);
                Utils.log("Splitted AreaList '" + ali.getTitle() + "' into " + closed.size() + " parts.");
                for (AreaList o : closed) {
                    o.calculateBoundingBox(null);
                }
                ali.getLayerSet().addAll(closed);
                for (AreaList o : closed) {
                    ali.project.getProjectTree().addSibling(ali, o);
                }
                ali.remove2(false);
                continue;
            }
            r.add(ali);
            Utils.log("Left AreaList '" + ali.getTitle() + "' unsplitted.");
        }
        return r;
    }

    private void add(AreaList ali) {
        for (Map.Entry<Long, Area> entry : ali.ht_areas.entrySet()) {
            Area ob_area = entry.getValue();
            long lid = entry.getKey();
            if (UNLOADED == ob_area) {
                ob_area = ali.loadLayer(lid);
            }
            Area area = ob_area;
            area = area.createTransformedArea(ali.at);
            try {
                area = area.createTransformedArea(this.at.createInverse());
            }
            catch (NoninvertibleTransformException nte) {
                IJError.print(nte);
            }
            Area this_area = this.ht_areas.get(entry.getKey());
            if (UNLOADED == this_area) {
                this_area = this.loadLayer(lid);
            }
            if (null == this_area) {
                this.ht_areas.put(entry.getKey(), (Area)area.clone());
            } else {
                this_area.add(area);
            }
            this.updateInDatabase("points=" + entry.getKey().intValue());
        }
    }

    public int getNAreas() {
        return this.ht_areas.size();
    }

    public Area getArea(Layer la) {
        if (null == la) {
            return null;
        }
        return this.getArea(la.getId());
    }

    public Area getArea(long layer_id) {
        Area ob = this.ht_areas.get(new Long(layer_id));
        if (null != ob) {
            if (UNLOADED == ob) {
                ob = this.loadLayer(layer_id);
            }
            return ob;
        }
        return null;
    }

    @Override
    public Displayable clone(Project pr, boolean copy_id) {
        ArrayList<Long> al_ul = new ArrayList<Long>();
        for (Long lid : this.ht_areas.keySet()) {
            al_ul.add(new Long(lid));
        }
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        AreaList copy = new AreaList(pr, nid, null != this.title ? this.title.toString() : null, this.width, this.height, this.alpha, this.visible, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()), this.visible, al_ul, (AffineTransform)this.at.clone());
        for (Map.Entry<Long, Area> entry : copy.ht_areas.entrySet()) {
            entry.setValue(new Area(this.ht_areas.get(entry.getKey())));
        }
        return copy;
    }

    public List<Point3f> generateTriangles(double scale, int resample) {
        HashMap<Layer, Area> areas = new HashMap<Layer, Area>();
        for (Map.Entry<Long, Area> e : this.ht_areas.entrySet()) {
            areas.put(this.layer_set.getLayer(e.getKey()), e.getValue());
        }
        return AreaUtils.generateTriangles(this, scale, resample, areas);
    }

    public void setArea(long layer_id, Area area) {
        if (null == area) {
            return;
        }
        this.ht_areas.put(layer_id, area);
        this.updateInDatabase("points=" + layer_id);
    }

    public void addArea(long layer_id, Area area) {
        if (null == area) {
            return;
        }
        Area a = this.getArea(layer_id);
        if (null == a) {
            this.ht_areas.put(layer_id, new Area(area));
        } else {
            a.add(area);
        }
        this.updateInDatabase("points=" + layer_id);
    }

    public void add(long layer_id, ShapeRoi roi) throws NoninvertibleTransformException {
        if (null == roi) {
            return;
        }
        Area a = this.getArea(layer_id);
        Area asr = M.getArea(roi).createTransformedArea(this.at.createInverse());
        if (null == a) {
            this.ht_areas.put(layer_id, asr);
        } else {
            a.add(asr);
            this.ht_areas.put(layer_id, a);
        }
        this.calculateBoundingBox(null != this.layer_set ? this.layer_set.getLayer(layer_id) : null);
        this.updateInDatabase("points=" + layer_id);
    }

    public void subtract(long layer_id, ShapeRoi roi) throws NoninvertibleTransformException {
        if (null == roi) {
            return;
        }
        Area a = this.getArea(layer_id);
        if (null == a) {
            return;
        }
        a.subtract(M.getArea(roi).createTransformedArea(this.at.createInverse()));
        this.calculateBoundingBox(null != this.layer_set ? this.layer_set.getLayer(layer_id) : null);
        this.updateInDatabase("points=" + layer_id);
    }

    public AreaList part(long layer_id, ShapeRoi sroi) throws NoninvertibleTransformException {
        Area sub = M.getArea(sroi);
        Area a = this.getArea(layer_id);
        if (null == a || M.isEmpty(a)) {
            return null;
        }
        Area inter = a.createTransformedArea(this.at);
        inter.intersect(sub);
        if (M.isEmpty(inter)) {
            return null;
        }
        this.subtract(layer_id, sroi);
        AreaList ali = new AreaList(this.project, this.title, 0.0, 0.0);
        ali.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        ali.visible = this.visible;
        ali.alpha = this.alpha;
        ali.addArea(layer_id, inter);
        this.layer_set.add(ali);
        ali.calculateBoundingBox(null != this.layer_set ? this.layer_set.getLayer(layer_id) : null);
        return ali;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        Object source = ke.getSource();
        if (!(source instanceof DisplayCanvas)) {
            return;
        }
        DisplayCanvas dc = (DisplayCanvas)source;
        Layer layer = dc.getDisplay().getLayer();
        int keyCode = ke.getKeyCode();
        long layer_id = layer.getId();
        if (75 == keyCode) {
            Roi roi = dc.getFakeImagePlus().getRoi();
            if (null == roi) {
                return;
            }
            if (!M.isAreaROI(roi)) {
                Utils.log("AreaList only accepts region ROIs, not lines.");
                return;
            }
            ShapeRoi sroi = new ShapeRoi(roi);
            try {
                AreaList p = this.part(layer_id, sroi);
                if (null != p) {
                    this.project.getProjectTree().addSibling(this, p);
                }
                Display.repaint(layer, this.getBoundingBox(), 5);
                this.linkPatches();
            }
            catch (NoninvertibleTransformException nite) {
                IJError.print(nite);
            }
            ke.consume();
        } else {
            Area a = this.getArea(layer_id);
            if (null == a) {
                a = new Area();
                this.ht_areas.put(layer_id, a);
            }
            new AreaWrapper(this, a).keyPressed(ke, dc, layer);
        }
    }

    @Override
    public String getInfo() {
        if (0 == this.ht_areas.size()) {
            return "Empty AreaList " + this.toString();
        }
        double[] m = this.measure();
        return "Volume: " + IJ.d2s((double)m[0], (int)2) + " Lower Bound Surface: " + IJ.d2s((double)m[1], (int)2) + " Upper Bound Surface Smoothed: " + IJ.d2s((double)m[2], (int)2) + " Upper Bound Surface: " + IJ.d2s((double)m[3], (int)2) + " Maximum diameter: " + IJ.d2s((double)m[4], (int)2);
    }

    @Override
    public boolean intersects(Area area, double z_first, double z_last) {
        for (Map.Entry<Long, Area> entry : this.ht_areas.entrySet()) {
            Layer layer = this.layer_set.getLayer((long)entry.getKey());
            if (!(layer.getZ() >= z_first) || !(layer.getZ() <= z_last)) continue;
            Area a = entry.getValue().createTransformedArea(this.at);
            a.intersect(area);
            Rectangle r = a.getBounds();
            if (0 == r.width || 0 == r.height) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void exportAsLabels(List<Displayable> listToPaint, Roi roi, final float scale, int first_layer, int last_layer, boolean visible_only, boolean to_file, boolean as_amira_labels) {
        void var16_28;
        int n;
        int height;
        int width;
        Rectangle broi;
        if (null == listToPaint || 0 == listToPaint.size()) {
            Utils.log("Null or empty list.");
            return;
        }
        if (scale < 0.0f || scale > 1.0f) {
            Utils.log("Improper scale value. Must be 0 < scale <= 1");
            return;
        }
        final ArrayList<AreaList> list = new ArrayList<AreaList>();
        for (Displayable displayable : listToPaint) {
            if (visible_only && !displayable.isVisible() || !(displayable instanceof AreaList)) continue;
            list.add((AreaList)displayable);
        }
        Utils.log2("exportAsLabels: list.size() is " + list.size());
        if (as_amira_labels && list.size() > 255) {
            Utils.log("Saving ONLY first 255 AreaLists!\nDiscarded:");
            StringBuilder sb = new StringBuilder();
            for (Displayable d : list.subList(255, list.size())) {
                sb.append("    ").append(d.getProject().getShortMeaningfulTitle(d)).append('\n');
            }
            Utils.log(sb.toString());
            ArrayList arrayList = new ArrayList(list);
            list.clear();
            list.addAll(arrayList.subList(0, 255));
        }
        String path = null;
        if (to_file) {
            String string = as_amira_labels ? ".am" : ".tif";
            File f = Utils.chooseFile("labels", string);
            if (null == f) {
                return;
            }
            path = f.getAbsolutePath().replace('\\', '/');
        }
        LayerSet layerSet = ((AreaList)list.get(0)).getLayerSet();
        if (first_layer > last_layer) {
            int tmp = first_layer;
            first_layer = last_layer;
            last_layer = tmp;
            if (first_layer < 0) {
                first_layer = 0;
            }
            if (last_layer >= layerSet.size()) {
                last_layer = layerSet.size() - 1;
            }
        }
        if (null == roi) {
            broi = null;
            width = (int)(layerSet.getLayerWidth() * scale);
            height = (int)(layerSet.getLayerHeight() * scale);
        } else {
            broi = roi.getBounds();
            width = (int)((float)broi.width * scale);
            height = (int)((float)broi.height * scale);
        }
        TreeSet<Integer> label_values = new TreeSet<Integer>();
        for (Displayable displayable : list) {
            String label = displayable.getProperty("label");
            if (null == label) continue;
            label_values.add(Integer.parseInt(label));
        }
        int lowest = 0;
        boolean bl = false;
        if (label_values.size() > 0) {
            lowest = (Integer)label_values.first();
            n = (Integer)label_values.last();
        }
        int n_non_labeled = list.size() - label_values.size();
        void max_label_value = n + n_non_labeled;
        int type_ = 0;
        if (max_label_value > 255) {
            type_ = 1;
            if (max_label_value > 65535) {
                type_ = 2;
            }
        }
        final int type = type_;
        ImageStack stack = new ImageStack(width, height);
        Calibration cal = layerSet.getCalibration();
        String amira_params = null;
        if (as_amira_labels) {
            StringBuilder sb = new StringBuilder("CoordType \"uniform\"\nMaterials {\nExterior {\n Id 0,\nColor 0 0 0\n}\n");
            float[] c = new float[3];
            int value = 0;
            for (Displayable displayable : list) {
                displayable.getColor().getRGBColorComponents(c);
                String s = displayable.getProject().getShortMeaningfulTitle(displayable);
                s = s.replace('-', '_').replaceAll(" #", " id");
                sb.append(Utils.makeValidIdentifier(s)).append(" {\n").append("Id ").append(++value).append(",\n").append("Color ").append(c[0]).append(' ').append(c[1]).append(' ').append(c[2]).append("\n}\n");
            }
            sb.append("}\n");
            amira_params = sb.toString();
        }
        final float len = last_layer - first_layer + 1;
        final HashMap<AreaList, Integer> labels = new HashMap<AreaList, Integer>();
        for (AreaList d : list) {
            String string = d.getProperty("label");
            int label = null != string ? Integer.parseInt(string) : ++var16_28;
            labels.put(d, label);
        }
        ThreadPoolExecutor exec = Utils.newFixedThreadPool("labels");
        final Map slices = Collections.synchronizedMap(new TreeMap());
        ArrayList arrayList = new ArrayList();
        List<Layer> layers = layerSet.getLayers().subList(first_layer, last_layer + 1);
        int k = 0;
        while (k < layers.size()) {
            final Layer la = layers.get(k);
            final int slice = k++;
            arrayList.add(exec.submit(new Runnable(){

                @Override
                public void run() {
                    FloatProcessor ip;
                    Utils.showProgress((float)slice / len);
                    if (0 == type) {
                        BufferedImage bi = new BufferedImage(width, height, 10);
                        Graphics2D g = bi.createGraphics();
                        for (AreaList ali : list) {
                            Area area = ali.getArea(la);
                            if (null == area || area.isEmpty()) continue;
                            AffineTransform aff = new AffineTransform();
                            if (1.0f != scale) {
                                aff.scale(scale, scale);
                            }
                            if (null != broi) {
                                aff.translate(-broi.x, -broi.y);
                            }
                            aff.concatenate(ali.at);
                            g.setTransform(aff);
                            int label = (Integer)labels.get(ali);
                            g.setColor(new Color(label, label, label));
                            g.fill(area);
                        }
                        g.dispose();
                        ip = new ByteProcessor(bi);
                        bi.flush();
                    } else if (1 == type) {
                        USHORTPaint paint = new USHORTPaint(0);
                        BufferedImage bi = new BufferedImage(paint.getComponentColorModel(), paint.getComponentColorModel().createCompatibleWritableRaster(width, height), false, null);
                        Graphics2D g = bi.createGraphics();
                        int painted = 0;
                        for (AreaList ali : list) {
                            Area area = ali.getArea(la);
                            if (null == area || area.isEmpty()) continue;
                            AffineTransform aff = new AffineTransform();
                            if (1.0f != scale) {
                                aff.scale(scale, scale);
                            }
                            if (null != broi) {
                                aff.translate(-broi.x, -broi.y);
                            }
                            aff.concatenate(ali.at);
                            g.setTransform(aff);
                            Utils.log2("value: " + ((Integer)labels.get(ali)).shortValue());
                            paint.setValue(((Integer)labels.get(ali)).shortValue());
                            g.setPaint(paint);
                            g.fill(area);
                            ++painted;
                        }
                        g.dispose();
                        ip = new ShortProcessor(bi);
                        bi.flush();
                        Utils.log2("painted: " + painted);
                    } else {
                        FloatProcessor fp = new FloatProcessor(width, height);
                        float[] fpix = (float[])fp.getPixels();
                        ip = fp;
                        BufferedImage bi = new BufferedImage(width, height, 10);
                        Graphics2D gbi = bi.createGraphics();
                        for (AreaList ali : list) {
                            Area area = ali.getArea(la);
                            if (null == area || area.isEmpty()) continue;
                            AffineTransform aff = new AffineTransform();
                            if (1.0f != scale) {
                                aff.scale(scale, scale);
                            }
                            if (null != broi) {
                                aff.translate(-broi.x, -broi.y);
                            }
                            aff.concatenate(ali.at);
                            Area s = area.createTransformedArea(aff);
                            Rectangle sBounds = s.getBounds();
                            if (0 == sBounds.width || 0 == sBounds.height || !sBounds.intersects(0.0, 0.0, width, height)) continue;
                            gbi.setColor(Color.white);
                            gbi.fill(s);
                            int x0 = Math.max(0, sBounds.x);
                            int y0 = Math.max(0, sBounds.y);
                            int xN = Math.min(width, sBounds.x + sBounds.width);
                            int yN = Math.min(height, sBounds.y + sBounds.height);
                            byte[] bpix = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                            float value = ((Integer)labels.get(ali)).intValue();
                            for (int y = y0; y < yN; ++y) {
                                for (int x = x0; x < xN; ++x) {
                                    int pos = y * width + x;
                                    if (0 == bpix[pos]) continue;
                                    fpix[pos] = value;
                                }
                            }
                            gbi.setColor(Color.black);
                            gbi.fill(s);
                        }
                        gbi.dispose();
                        bi.flush();
                    }
                    slices.put(slice, ip);
                }
            }));
        }
        Utils.wait(arrayList);
        exec.shutdownNow();
        for (Map.Entry e : slices.entrySet()) {
            Layer la = layers.get((Integer)e.getKey());
            stack.addSlice(la.getZ() * cal.pixelWidth + "", (ImageProcessor)e.getValue());
            if (0 == type) continue;
            ((ImageProcessor)e.getValue()).setMinAndMax((double)lowest, (double)var16_28);
        }
        Utils.showProgress(1.0);
        ImagePlus imp = new ImagePlus("Labels", stack);
        if (as_amira_labels) {
            imp.setProperty("Info", (Object)amira_params);
        }
        imp.setCalibration(layerSet.getCalibrationCopy());
        if (to_file) {
            if (as_amira_labels) {
                AmiraMeshEncoder ame = new AmiraMeshEncoder(path);
                if (!ame.open()) {
                    Utils.log("Could not write to file " + path);
                    return;
                }
                if (!ame.write(imp)) {
                    Utils.log("Error in writing Amira file!");
                    return;
                }
            } else {
                new FileSaver(imp).saveAsTiff(path);
            }
        } else {
            imp.show();
        }
    }

    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (0 == this.ht_areas.size()) {
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("AreaList results", new String[]{"id", "volume", "LB-surface", "UBs-surface", "UB-surface", "AVGs-surface", "AVG-surface", "max diameter", "Sum of tops", "name-id", "Xcm", "Ycm", "Zcm"});
        }
        rt.incrementCounter();
        rt.addLabel("units", this.layer_set.getCalibration().getUnit());
        rt.addValue(0, (double)this.id);
        double[] m = this.measure();
        rt.addValue(1, m[0]);
        rt.addValue(2, m[1]);
        rt.addValue(3, m[2]);
        rt.addValue(4, m[3]);
        rt.addValue(5, (m[1] + m[2]) / 2.0);
        rt.addValue(6, (m[1] + m[3]) / 2.0);
        rt.addValue(7, m[4]);
        rt.addValue(8, m[5]);
        rt.addValue(9, this.getNameId());
        rt.addValue(10, m[6]);
        rt.addValue(11, m[7]);
        rt.addValue(12, m[8]);
        return rt;
    }

    public double[] measure() {
        Point3f c;
        if (0 == this.ht_areas.size()) {
            return new double[6];
        }
        AffineTransform aff = new AffineTransform(this.at);
        AffineTransform aff2 = new AffineTransform();
        Rectangle box = this.getBoundingBox(null);
        aff2.translate(-box.x, -box.y);
        aff.preConcatenate(aff2);
        aff2 = null;
        double volume = 0.0;
        double lower_bound_surface_h = 0.0;
        double upper_bound_surface = 0.0;
        double upper_bound_surface_smoothed = 0.0;
        double prev_surface = 0.0;
        double prev_perimeter = 0.0;
        double prev_smooth_perimeter = 0.0;
        double prev_thickness = 0.0;
        double all_tops_and_bottoms = 0.0;
        Calibration cal = this.layer_set.getCalibration();
        double pixelWidth = cal.pixelWidth;
        double pixelHeight = cal.pixelHeight;
        TreeMap<Integer, Area> ias = new TreeMap<Integer, Area>();
        for (Map.Entry<Long, Area> e : this.ht_areas.entrySet()) {
            int ilayer = this.layer_set.indexOf(this.layer_set.getLayer(e.getKey()));
            if (-1 == ilayer) {
                Utils.log("Could not find a layer with id " + e.getKey());
                continue;
            }
            ias.put(ilayer, e.getValue());
        }
        ArrayList<Layer> layers = this.layer_set.getLayers();
        int last_layer_index = -1;
        ArrayList<Point3f> points = new ArrayList<Point3f>();
        float[] coords = new float[6];
        float fpixelWidth = (float)pixelWidth;
        float fpixelHeight = (float)pixelHeight;
        float resampling_delta = this.project.getProperty("measurement_resampling_delta", 1.0f);
        for (Map.Entry e : ias.entrySet()) {
            int layer_index = (Integer)e.getKey();
            if (layer_index > layers.size()) {
                Utils.log("Could not find a layer at index " + layer_index);
                continue;
            }
            Layer la = layers.get(layer_index);
            Area area = (Area)e.getValue();
            if (UNLOADED == area) {
                area = this.loadLayer(la.getId());
            }
            area = area.createTransformedArea(aff);
            double pixel_area = Math.abs(AreaCalculations.area((PathIterator)area.getPathIterator(null)));
            double surface = pixel_area * pixelWidth * pixelHeight;
            double thickness = la.getThickness() * pixelWidth;
            volume += surface * thickness;
            double pix_perimeter = AreaCalculations.circumference((PathIterator)area.getPathIterator(null));
            double perimeter = pix_perimeter * pixelWidth;
            double smooth_perimeter = 0.0;
            double smooth_pix_perimeter = 0.0;
            for (Polygon pol : M.getPolygons(area)) {
                try {
                    FloatPolygon fp;
                    if (pol.npoints < 5) {
                        smooth_perimeter += new PolygonRoi(pol, 2).getLength();
                        continue;
                    }
                    FloatPolygon fpol = new FloatPolygon(new float[pol.npoints], new float[pol.npoints], pol.npoints);
                    for (int i = 0; i < pol.npoints; ++i) {
                        fpol.xpoints[i] = pol.xpoints[i];
                        fpol.ypoints[i] = pol.ypoints[i];
                    }
                    fpol = M.createInterpolatedPolygon(fpol, 1.0, false);
                    if (fpol.npoints < 5) {
                        smooth_pix_perimeter += fpol.getLength(false);
                        fp = fpol;
                        continue;
                    }
                    FloatPolygon gpol = new FloatPolygon(new float[fpol.npoints], new float[fpol.npoints], fpol.npoints);
                    CircularSequence seq = new CircularSequence(fpol.npoints);
                    M.convolveGaussianSigma1(fpol.xpoints, gpol.xpoints, seq);
                    M.convolveGaussianSigma1(fpol.ypoints, gpol.ypoints, seq);
                    fp = (float)gpol.npoints > resampling_delta ? M.createInterpolatedPolygon(gpol, resampling_delta, false) : gpol;
                    smooth_pix_perimeter += (double)((float)(fp.npoints - 1) * resampling_delta) + Math.sqrt(Math.pow(fp.xpoints[0] - fp.xpoints[fp.npoints - 1], 2.0) + Math.pow(fp.ypoints[0] - fp.ypoints[fp.npoints - 1], 2.0));
                }
                catch (Exception le) {
                    le.printStackTrace();
                }
            }
            smooth_perimeter = smooth_pix_perimeter * pixelWidth;
            if (-1 == last_layer_index) {
                lower_bound_surface_h += surface;
                upper_bound_surface += surface;
                upper_bound_surface_smoothed += surface;
                all_tops_and_bottoms += surface;
            } else if (layer_index - last_layer_index > 1) {
                lower_bound_surface_h += prev_surface + prev_thickness * 2.0 * Math.sqrt(prev_surface * Math.PI);
                upper_bound_surface += prev_surface + prev_perimeter * prev_thickness;
                upper_bound_surface_smoothed += prev_surface + prev_smooth_perimeter * prev_thickness;
                all_tops_and_bottoms += prev_surface;
                lower_bound_surface_h += surface;
                upper_bound_surface += surface;
                upper_bound_surface_smoothed += surface;
                all_tops_and_bottoms += surface;
            } else {
                double diff_surface = Math.abs(prev_surface - surface);
                upper_bound_surface += prev_perimeter * (prev_thickness / 2.0) + perimeter * (prev_thickness / 2.0) + diff_surface;
                upper_bound_surface_smoothed += prev_smooth_perimeter * (prev_thickness / 2.0) + smooth_perimeter * (prev_thickness / 2.0) + diff_surface;
                double r1 = Math.sqrt(prev_surface / Math.PI);
                double r2 = Math.sqrt(surface / Math.PI);
                double hypothenusa = Math.sqrt(Math.pow(Math.abs(r1 - r2), 2.0) + Math.pow(thickness, 2.0));
                lower_bound_surface_h += Math.PI * hypothenusa * (r1 + r2);
                volume += diff_surface * prev_thickness / 2.0;
            }
            prev_surface = surface;
            prev_perimeter = perimeter;
            prev_smooth_perimeter = smooth_perimeter;
            last_layer_index = layer_index;
            prev_thickness = thickness;
            float z = (float)la.getZ();
            PathIterator pit = area.getPathIterator(null);
            while (!pit.isDone()) {
                switch (pit.currentSegment(coords)) {
                    case 0: 
                    case 1: 
                    case 4: {
                        points.add(new Point3f(coords[0] * fpixelWidth, coords[1] * fpixelHeight, z * fpixelWidth));
                        break;
                    }
                    default: {
                        Utils.log2("WARNING: unhandled seg type.");
                    }
                }
                pit.next();
            }
        }
        lower_bound_surface_h += prev_surface + prev_perimeter * prev_thickness;
        upper_bound_surface += prev_surface + prev_perimeter * prev_thickness;
        upper_bound_surface_smoothed += prev_surface + prev_smooth_perimeter * prev_thickness;
        all_tops_and_bottoms += prev_surface;
        boolean measure_largest_diameter = this.project.getBooleanProperty("measure_largest_diameter");
        double max_diameter_sq = measure_largest_diameter ? 0.0 : Double.NaN;
        int lp = points.size();
        if (lp > 0) {
            c = new Point3f((Point3f)points.get(0));
            for (int i = 0; i < lp; ++i) {
                Point3f p = (Point3f)points.get(i);
                if (measure_largest_diameter) {
                    for (int j = i; j < lp; ++j) {
                        double len = p.distanceSquared((Point3f)points.get(j));
                        if (!(len > max_diameter_sq)) continue;
                        max_diameter_sq = len;
                    }
                }
                if (0 == i) continue;
                c.x += p.x;
                c.y += p.y;
                c.z += p.z;
            }
        } else {
            c = new Point3f(Float.NaN, Float.NaN, Float.NaN);
        }
        c.x = (float)box.x + c.x / (float)lp;
        c.y = (float)box.y + c.y / (float)lp;
        c.z /= (float)lp;
        return new double[]{volume, lower_bound_surface_h, upper_bound_surface_smoothed, upper_bound_surface, Math.sqrt(max_diameter_sq), all_tops_and_bottoms, c.x, c.y, c.z};
    }

    @Override
    Class<?> getInternalDataPackageClass() {
        return DPAreaList.class;
    }

    @Override
    Object getDataPackage() {
        return new DPAreaList(this);
    }

    @Override
    public synchronized boolean crop(List<Layer> range) {
        HashSet<Long> lids = new HashSet<Long>();
        for (Layer l : range) {
            lids.add(l.getId());
        }
        Iterator<Long> it = this.ht_areas.keySet().iterator();
        while (it.hasNext()) {
            if (lids.contains(it.next())) continue;
            it.remove();
        }
        this.calculateBoundingBox(null);
        return true;
    }

    public ImagePlus getStack(int type, double scale) {
        ImageProcessor ref_ip = Utils.createProcessor(type, 2, 2);
        if (null == ref_ip) {
            Utils.log("AreaList.getStack: Unknown type " + type);
            return null;
        }
        Rectangle b = this.getBoundingBox();
        int w = (int)(0.5 + (double)b.width * scale);
        int h = (int)(0.5 + (double)b.height * scale);
        ImageStack stack = new ImageStack(w, h);
        for (Layer la : this.getLayerRange()) {
            Area area = this.getArea(la);
            double z = this.layer.getZ();
            this.project.getLoader().releaseToFit(w * h * 10);
            ImageProcessor ip = ref_ip.createProcessor(w, h);
            if (null == area) {
                stack.addSlice(Double.toString(z), ip);
                continue;
            }
            AffineTransform aff = this.getAffineTransformCopy();
            aff.translate(-b.x, -b.y);
            aff.scale(scale, scale);
            ShapeRoi roi = new ShapeRoi((Shape)area.createTransformedArea(aff));
            ImageProcessor flat = Patch.makeFlatImage(type, la, b, scale, la.getAll(Patch.class), Color.black);
            flat.setRoi((Roi)roi);
            Rectangle rb = roi.getBounds();
            ip.insert(flat.crop(), rb.x, rb.y);
            ImagePlus bimp = new ImagePlus("", ip);
            bimp.setRoi((Roi)roi);
            ip.setValue(0.0);
            ip.setBackgroundValue(0.0);
            IJ.run((ImagePlus)bimp, (String)"Clear Outside", (String)"");
            stack.addSlice(Double.toString(z), ip);
        }
        ImagePlus imp = new ImagePlus("AreaList stack for " + this, stack);
        imp.setCalibration(this.layer_set.getCalibrationCopy());
        return imp;
    }

    @Override
    public List<Area> getAreas(Layer layer, Rectangle box) {
        Area a = this.ht_areas.get(layer.getId());
        if (null == a) {
            return null;
        }
        ArrayList<Area> l = new ArrayList<Area>();
        l.add(a);
        return l;
    }

    @Override
    protected boolean layerRemoved(Layer la) {
        super.layerRemoved(la);
        this.ht_areas.remove(la.getId());
        return true;
    }

    @Override
    public boolean apply(Layer la, Area roi, CoordinateTransform ct) throws Exception {
        Area a = this.getArea(la);
        if (null == a) {
            return true;
        }
        AffineTransform inverse = this.at.createInverse();
        if (M.intersects(a, roi.createTransformedArea(inverse))) {
            M.apply(M.wrap(this.at, ct, inverse), roi, a);
            this.calculateBoundingBox(la);
        }
        return true;
    }

    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        Area a = this.getArea(vdt.layer);
        if (null == a) {
            return true;
        }
        M.apply(vdt.makeLocalTo(this), a);
        this.calculateBoundingBox(vdt.layer);
        return true;
    }

    @Override
    public synchronized Collection<Long> getLayerIds() {
        return new ArrayList<Long>(this.ht_areas.keySet());
    }

    @Override
    public Area getAreaAt(Layer layer) {
        Area a = this.getArea(layer);
        if (null == a) {
            return null;
        }
        return a.createTransformedArea(this.at);
    }

    @Override
    public boolean isRoughlyInside(Layer layer, Rectangle box) {
        Area a = this.getArea(layer);
        if (null == a) {
            return false;
        }
        try {
            return this.at.createInverse().createTransformedShape(box).intersects(a.getBounds());
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
            return false;
        }
    }

    @Override
    public ResultsTable measureAreas(ResultsTable rt) {
        if (0 == this.ht_areas.size()) {
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Area results", new String[]{"id", "name-id", "layer index", "area"});
        }
        double nameId = this.getNameId();
        Calibration cal = this.layer_set.getCalibration();
        String units = cal.getUnit();
        TreeMap<Layer, Area> sm = new TreeMap<Layer, Area>(Layer.COMPARATOR);
        for (Map.Entry<Long, Area> entry : this.ht_areas.entrySet()) {
            sm.put(this.layer_set.getLayer(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Comparable<Long>, Area> entry : sm.entrySet()) {
            Area area = entry.getValue();
            if (area.isEmpty()) continue;
            rt.incrementCounter();
            rt.addLabel("units", units);
            rt.addValue(0, (double)this.id);
            rt.addValue(1, nameId);
            rt.addValue(2, (double)(this.layer_set.indexOf((Layer)entry.getKey()) + 1));
            double pixel_area = Math.abs(AreaCalculations.area((PathIterator)area.createTransformedArea(this.at).getPathIterator(null)));
            double surface = pixel_area * cal.pixelWidth * cal.pixelHeight;
            rt.addValue(3, surface);
        }
        return rt;
    }

    public boolean interpolate(Layer first, Layer last, boolean always_use_distance_map) throws Exception {
        int i2;
        int i1 = this.layer_set.indexOf(first);
        if (i1 > (i2 = this.layer_set.indexOf(last))) {
            int tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        List<Layer> range = this.layer_set.getLayers().subList(i1, i2 + 1);
        Area start = null;
        int istart = 0;
        int inext = -1;
        HashSet<Layer> touched = new HashSet<Layer>();
        for (Layer la : range) {
            Area[] as;
            ++inext;
            Area next = this.getArea(la);
            if (null == next || next.isEmpty()) continue;
            if (null == start || 0 == inext - istart - 1) {
                start = next;
                istart = inext;
                continue;
            }
            Area[] areaArray = as = always_use_distance_map ? null : AreaUtils.singularInterpolation(start, next, inext - istart - 1);
            if (null == as) {
                as = AreaUtils.manyToManyInterpolation(start, next, inext - istart - 1);
            }
            if (null != as) {
                for (int k = 0; k < as.length; ++k) {
                    Layer la2 = range.get(k + istart + 1);
                    this.addArea(la2.getId(), as[k]);
                    touched.add(la2);
                }
            }
            start = next;
            istart = inext;
        }
        for (Layer la : touched) {
            this.calculateBoundingBox(la);
        }
        return true;
    }

    private static final class DPAreaList
    extends Displayable.DataPackage {
        protected final HashMap<Long, Area> ht = new HashMap();

        DPAreaList(AreaList ali) {
            super(ali);
            for (Map.Entry e : ali.ht_areas.entrySet()) {
                this.ht.put((Long)e.getKey(), new Area((Shape)e.getValue()));
            }
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            AreaList ali = (AreaList)d;
            ali.ht_areas.clear();
            for (Map.Entry<Long, Area> e : this.ht.entrySet()) {
                ali.ht_areas.put(e.getKey(), new Area(e.getValue()));
            }
            return true;
        }
    }
}

