/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ini.trakem2.Project;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public final class TemplateThing
extends DBObject
implements Thing,
Comparable<TemplateThing> {
    private String type;
    private TemplateThing parent = null;
    private ArrayList<TemplateThing> al_children = null;
    private String value = null;

    @Override
    public Thing shallowCopy() {
        return new TemplateThing(this);
    }

    private TemplateThing(TemplateThing tt) {
        super(tt.project, tt.id);
        this.type = tt.type;
    }

    public TemplateThing(String type) {
        super(null, -1L);
        this.type = type;
    }

    public TemplateThing(String type, Project project) {
        super(project);
        this.type = type;
    }

    public TemplateThing(String type, Project project, long id) {
        super(project, id);
        this.type = type;
    }

    public void setup(ArrayList<TemplateThing> al_children) {
        if (null == al_children || 0 == al_children.size()) {
            this.al_children = null;
        } else {
            this.al_children = al_children;
            for (TemplateThing child : al_children) {
                child.parent = this;
            }
        }
    }

    public void addToDatabase(Project project) {
        this.project = project;
        this.id = project.getLoader().getNextId();
        super.addToDatabase();
        if (null == this.al_children || this.al_children.isEmpty()) {
            return;
        }
        for (TemplateThing child : this.al_children) {
            child.addToDatabase(project);
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void setParent(Thing parent) {
        this.parent = (TemplateThing)parent;
    }

    @Override
    public Thing getParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        return this.type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public TemplateThing getChildTemplate(String type) {
        if (null == this.al_children) {
            return null;
        }
        for (TemplateThing child : this.al_children) {
            if (!child.type.equals(type)) continue;
            return child;
        }
        return null;
    }

    @Override
    public boolean addChild(Thing child) {
        if (null == child) {
            return false;
        }
        if (null == this.al_children) {
            this.al_children = new ArrayList();
        } else {
            for (TemplateThing tc : this.al_children) {
                if (!tc.type.equals(((TemplateThing)child).type)) continue;
                Utils.log2("TemplateThing.addChild: already have a child of type " + tc.type);
                return false;
            }
        }
        this.al_children.add((TemplateThing)child);
        child.setParent(this);
        return true;
    }

    public ArrayList<TemplateThing> getChildren() {
        return this.al_children;
    }

    @Override
    public boolean hasChildren() {
        return null != this.al_children && 0 != this.al_children.size();
    }

    @Override
    public boolean canHaveAsChild(Thing thing) {
        if (null == thing || null == this.al_children) {
            return false;
        }
        for (TemplateThing tt : this.al_children) {
            if (!tt.type.equals(thing.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean uniquePathExists(String type) {
        if (null == this.al_children) {
            return false;
        }
        return 1 == this.scanChildTrees(type, new ArrayList<TemplateThing>(), new HashSet<TemplateThing>()).size();
    }

    private ArrayList<TemplateThing> scanChildTrees(String type, ArrayList<TemplateThing> al, HashSet<TemplateThing> hs_done) {
        if (null == al) {
            al = new ArrayList();
        }
        if (null == this.al_children) {
            return al;
        }
        for (TemplateThing tt : this.al_children) {
            if (tt.type.equals(type)) {
                al.add(tt);
                continue;
            }
            if (hs_done.contains(tt)) continue;
            hs_done.add(tt);
            al = tt.scanChildTrees(type, al, hs_done);
        }
        return al;
    }

    protected ArrayList<TemplateThing> getTemplatePathTo(String type, ArrayList<TemplateThing> al) {
        al.add(this);
        if (null == this.al_children) {
            return al;
        }
        for (TemplateThing tt : this.al_children) {
            if (tt.type.equals(type)) {
                al.add(tt);
                return al;
            }
            ArrayList<TemplateThing> al2 = tt.getTemplatePathTo(type, new ArrayList<TemplateThing>(al));
            if (al2.size() <= 0 || !al2.get((int)(al2.size() - 1)).type.equals(type)) continue;
            return al2;
        }
        return al;
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public Thing findChild(Object ob) {
        return null;
    }

    public HashMap<String, TemplateThing> getUniqueTypes(HashMap<String, TemplateThing> ht) {
        if (ht.containsKey(this.type)) {
            return ht;
        }
        ht.put(this.type, this);
        if (null == this.al_children || this.al_children.isEmpty()) {
            return ht;
        }
        for (TemplateThing tt : this.al_children) {
            tt.getUniqueTypes(ht);
        }
        return ht;
    }

    public ArrayList<TemplateThing> collectAllChildren(ArrayList<TemplateThing> al) {
        if (null == this.al_children) {
            return al;
        }
        al.addAll(this.al_children);
        for (TemplateThing tt : this.al_children) {
            tt.collectAllChildren(al);
        }
        return al;
    }

    protected void rename(String new_name) {
        if (null == new_name || 0 == new_name.length() || this.type.equals(new_name)) {
            return;
        }
        this.type = new_name;
        this.updateInDatabase("type");
    }

    @Override
    public boolean remove(boolean check) {
        if (check && !Utils.check("Really delete " + this.toString() + (null == this.al_children || 0 == this.al_children.size() ? "" : " and all its children?"))) {
            return false;
        }
        if (null != this.al_children) {
            Object[] children = new Object[this.al_children.size()];
            this.al_children.toArray(children);
            for (int i = 0; i < children.length; ++i) {
                Object ob = children[i];
                if (!(ob instanceof DBObject) || ((DBObject)ob).remove(false)) continue;
                Utils.showMessage("Deletion incomplete, check database, for child: " + ob.toString());
                return false;
            }
        }
        if (null != this.parent && !this.parent.removeChild(this)) {
            Utils.showMessage("Deletion incomplete, check database, for parent of TemplateThing id=" + this.id);
            return false;
        }
        return this.removeFromDatabase();
    }

    public boolean removeChild(TemplateThing child) {
        if (-1 == this.al_children.indexOf(child)) {
            Utils.log("TemplateThing.removeChild: child " + child + " not contained in parent " + this);
            return false;
        }
        this.al_children.remove(child);
        return true;
    }

    public HashSet<TemplateThing> collectSimilarThings(TemplateThing tt, HashSet<TemplateThing> hs) {
        if (this.type.equals(tt.type) && this.parent.type.equals(tt.parent.type)) {
            hs.add(this);
        }
        if (null == this.al_children || this.al_children.isEmpty()) {
            return hs;
        }
        for (TemplateThing child : this.al_children) {
            child.collectSimilarThings(tt, hs);
        }
        return hs;
    }

    public HashSet<TemplateThing> collectSimilarThings2(TemplateThing tt, HashSet<TemplateThing> hs) {
        if (this.type.equals(tt.type) && (this.al_children == tt.al_children || null != this.al_children && null != tt.al_children && this.al_children.size() == tt.al_children.size())) {
            hs.add(this);
        }
        if (null == this.al_children || this.al_children.isEmpty()) {
            return hs;
        }
        for (TemplateThing child : this.al_children) {
            child.collectSimilarThings2(tt, hs);
        }
        return hs;
    }

    public HashSet<TemplateThing> collectThingsOfEqualType(TemplateThing tt, HashSet<TemplateThing> hs) {
        if (this.type.equals(tt.type)) {
            hs.add(this);
        }
        if (null == this.al_children || this.al_children.isEmpty()) {
            return hs;
        }
        for (TemplateThing child : this.al_children) {
            child.collectThingsOfEqualType(tt, hs);
        }
        return hs;
    }

    public boolean isNested() {
        for (Thing p = this.parent; null != p; p = p.getParent()) {
            if (!this.type.equals(p.getType())) continue;
            return true;
        }
        return false;
    }

    public void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String tag = this.type.replace(' ', '_');
        if (hs.contains(tag)) {
            return;
        }
        hs.add(tag);
        sb_header.append(indent).append("<!ELEMENT ").append(tag);
        if (null != this.al_children && 0 != this.al_children.size()) {
            sb_header.append(" (");
            int c = 0;
            for (TemplateThing child : this.al_children) {
                if (0 != c) {
                    sb_header.append(", ");
                }
                ++c;
                sb_header.append(child.type);
            }
            sb_header.append(")");
        } else {
            sb_header.append(" EMPTY");
        }
        sb_header.append(">\n");
        sb_header.append(indent).append("<!ATTLIST ").append(tag).append(" id NMTOKEN #REQUIRED>\n");
        if (Project.isBasicType(this.type)) {
            sb_header.append(indent).append("<!ATTLIST ").append(tag).append(" oid NMTOKEN #REQUIRED>\n");
        }
        sb_header.append(indent).append("<!ATTLIST ").append(tag).append(" expanded NMTOKEN #REQUIRED>\n");
        if (null != this.al_children && 0 != this.al_children.size()) {
            for (TemplateThing child : this.al_children) {
                child.exportDTD(sb_header, hs, indent);
            }
        }
    }

    public void exportXMLTemplate(StringBuffer sb_header, StringBuffer sb_body, HashSet<String> hs, String indent) {
        if (!hs.contains(this.type)) {
            hs.add(this.type);
            sb_header.append("\t<!ELEMENT ").append(this.type);
            if (null != this.al_children && 0 != this.al_children.size()) {
                sb_header.append(" (");
                int c = 0;
                for (TemplateThing child : this.al_children) {
                    if (0 != c) {
                        sb_header.append(", ");
                    }
                    ++c;
                    sb_header.append(child.type);
                }
                sb_header.append(")");
            } else {
                sb_header.append(" EMPTY");
            }
            sb_header.append(">\n");
            sb_header.append("\t<!ATTLIST ").append(this.type).append(" id NMTOKEN #REQUIRED>\n");
        }
        sb_body.append(indent).append("<").append(this.type).append(" id=\"").append(this.id).append("\"");
        sb_body.append(">\n");
        if (null != this.al_children && 0 != this.al_children.size()) {
            for (TemplateThing child : this.al_children) {
                child.exportXMLTemplate(sb_header, sb_body, hs, indent + "\t");
            }
        }
        sb_body.append(indent).append("</").append(this.type).append(">\n");
    }

    @Override
    public void debug(String indent) {
        System.out.println(indent + this.type + " (id)");
        if (null != this.al_children) {
            if (this.isNested()) {
                System.out.println(indent + "-- Nested type.");
                return;
            }
            if (indent.length() > 20) {
                System.out.println("INDENT OVER 20 !");
                return;
            }
            for (TemplateThing tt : this.al_children) {
                tt.debug(indent + "\t");
            }
        }
    }

    @Override
    public boolean isExpanded() {
        return this.project.getLayerTree().isExpanded(this);
    }

    @Override
    public String getInfo() {
        return "Template Node: " + this.type;
    }

    public TemplateThing clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        TemplateThing copy = new TemplateThing(this.type, pr, nid);
        copy.project = pr;
        copy.addToDatabase();
        if (null == this.al_children) {
            return copy;
        }
        for (TemplateThing child : this.al_children) {
            copy.addChild(child.clone(pr, copy_id));
        }
        return copy;
    }

    @Override
    public int compareTo(TemplateThing o) {
        return this.type.compareTo(o.getType());
    }
}

