/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kymographBuilder;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;
import sc.fiji.kymographBuilder.NoLineException;

public class Utils {
    public static String getInfo(Dataset dataset, String prefix) {
        String s = new String();
        s = s + prefix + "Dataset : " + dataset.toString() + "\n";
        s = s + prefix + "Width = ";
        s = s + dataset.dimension(dataset.dimensionIndex(Axes.X)) + "\n";
        s = s + prefix + "Height = ";
        s = s + dataset.dimension(dataset.dimensionIndex(Axes.Y)) + "\n";
        s = s + prefix + "Depth = ";
        s = s + dataset.dimension(dataset.dimensionIndex(Axes.Z)) + "\n";
        s = s + prefix + "Timepoints = ";
        s = s + dataset.dimension(dataset.dimensionIndex(Axes.TIME)) + "\n";
        s = s + prefix + "Number of channels = ";
        s = s + dataset.dimension(dataset.dimensionIndex(Axes.CHANNEL)) + "\n";
        return s;
    }

    public static String getInfo(Dataset dataset) {
        return Utils.getInfo(dataset, "");
    }

    public static void askToSwapTimeAndZDimensions(Dataset dataset) {
        long zDim;
        int zIdx = dataset.dimensionIndex(Axes.Z);
        int timeIdx = dataset.dimensionIndex(Axes.TIME);
        long timeDim = dataset.dimension(timeIdx);
        if (timeDim < (zDim = dataset.dimension(zIdx))) {
            String mess = new String();
            mess = mess + "It appears this image has " + timeDim + " timepoints";
            mess = mess + " and " + zDim + " Z slices.\n";
            mess = mess + "Do you want to swap Z and T axes ?";
            UIService ui = (UIService)dataset.context().service(UIService.class);
            DialogPrompt.Result result = ui.showDialog(mess, DialogPrompt.MessageType.QUESTION_MESSAGE, DialogPrompt.OptionType.YES_NO_OPTION);
            result.equals((Object)DialogPrompt.Result.YES_OPTION);
            if (result.equals((Object)DialogPrompt.Result.YES_OPTION)) {
                if (zIdx != -1) {
                    ((CalibratedAxis)dataset.axis(zIdx)).setType(Axes.TIME);
                }
                if (timeIdx != -1) {
                    ((CalibratedAxis)dataset.axis(timeIdx)).setType(Axes.Z);
                }
            }
        }
    }

    public static void swapTimeAndZDimensions(Dataset dataset) {
        long zDim;
        int zIdx = dataset.dimensionIndex(Axes.Z);
        int timeIdx = dataset.dimensionIndex(Axes.TIME);
        long timeDim = dataset.dimension(timeIdx);
        if (timeDim < (zDim = dataset.dimension(zIdx))) {
            if (zIdx != -1) {
                ((CalibratedAxis)dataset.axis(zIdx)).setType(Axes.TIME);
            }
            if (timeIdx != -1) {
                ((CalibratedAxis)dataset.axis(timeIdx)).setType(Axes.Z);
            }
        }
    }

    static Roi checkForROIs(Dataset dataset) throws NoLineException {
        RoiManager rm;
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi = null;
        if (imp != null) {
            roi = imp.getRoi();
        }
        if (roi == null && (rm = RoiManager.getInstance()) != null) {
            roi = rm.getRoi(0);
        }
        if (roi == null) {
            throw new NoLineException("Please define a line in order to build the kymograph.");
        }
        if (!"Straight Line".equals(roi.getTypeAsString()) && !"Polyline".equals(roi.getTypeAsString())) {
            throw new NoLineException("Please use the Straight Line or Segmented Line selection tool.");
        }
        return roi;
    }
}

