/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.MiscTools;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Vector;

public class Mask {
    private boolean[] mask;
    private int width;
    private int height;
    private Polygon polygon = null;
    private boolean mask_from_the_stack;

    public Mask(ImageProcessor ip, boolean take_mask) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.mask = new boolean[this.width * this.height];
        if (!take_mask) {
            this.mask_from_the_stack = false;
            this.clearMask();
        } else {
            this.mask_from_the_stack = true;
            int k = 0;
            if (ip instanceof ByteProcessor) {
                byte[] pixels = (byte[])ip.getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.mask[k] = pixels[k] != 0;
                        ++x;
                        ++k;
                    }
                }
            } else if (ip instanceof ShortProcessor) {
                short[] pixels = (short[])ip.getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.mask[k] = pixels[k] != 0;
                        ++x;
                        ++k;
                    }
                }
            } else if (ip instanceof FloatProcessor) {
                float[] pixels = (float[])ip.getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.mask[k] = pixels[k] != 0.0f;
                        ++x;
                        ++k;
                    }
                }
            } else if (ip instanceof ColorProcessor) {
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.mask[k] = (ip.get(x, y) & 0xFFFFFF) != 0;
                        ++x;
                        ++k;
                    }
                }
            } else {
                IJ.error((String)"Mask slice is an image processor bUnwarpJ cannot process");
            }
        }
    }

    public Mask(int width, int height) {
        this.width = width;
        this.height = height;
        this.mask = new boolean[width * height];
        Arrays.fill(this.mask, true);
    }

    public void BoundingBox(int[] corners) {
        if (this.polygon.npoints != 0) {
            Rectangle boundingbox = this.polygon.getBounds();
            corners[0] = boundingbox.x;
            corners[1] = boundingbox.y;
            corners[2] = corners[0] + boundingbox.width;
            corners[3] = corners[1] + boundingbox.height;
        } else {
            corners[0] = 0;
            corners[1] = 0;
            corners[2] = this.width;
            corners[3] = this.height;
        }
    }

    public void clearMask() {
        int k = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.mask[k++] = true;
            }
        }
        this.polygon = new Polygon();
    }

    public void fillMask(int tool) {
        int k = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.mask[k] = this.polygon.contains(x, y);
                if (tool == 4) {
                    this.mask[k] = !this.mask[k];
                }
                ++k;
            }
        }
    }

    public boolean getValue(double x, double y) {
        int u = (int)Math.round(x);
        int v = (int)Math.round(y);
        if (u < 0 || u >= this.width || v < 0 || v >= this.height) {
            return false;
        }
        return this.mask[v * this.width + u];
    }

    public Point getPoint(int i) {
        return new Point(this.polygon.xpoints[i], this.polygon.ypoints[i]);
    }

    public boolean isFromStack() {
        return this.mask_from_the_stack;
    }

    public int numberOfMaskPoints() {
        return this.polygon.npoints;
    }

    public void readFile(String filename) {
        ImagePlus aux = new ImagePlus(filename);
        if (aux.getWidth() != this.width || aux.getHeight() != this.height) {
            IJ.error((String)"Mask in file is not of the expected size");
        }
        ImageProcessor ip = aux.getProcessor();
        int k = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                this.mask[k] = ip.getPixelValue(x, y) != 0.0f;
                ++x;
                ++k;
            }
        }
    }

    public void showMask() {
        double[][] img = new double[this.height][this.width];
        int k = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                img[y][x] = this.mask[k++] ? 1.0 : 0.0;
            }
        }
        MiscTools.showImage("Mask", img);
    }

    public void setMaskPoints(Vector<Point> listMaskPoints) {
        int imax = listMaskPoints.size();
        for (int i = 0; i < imax; ++i) {
            Point p = listMaskPoints.elementAt(i);
            this.polygon.addPoint(p.x, p.y);
        }
    }

    public void setValue(int u, int v, boolean value) {
        if (u >= 0 && u < this.width && v >= 0 && v < this.height) {
            this.mask[v * this.width + u] = value;
        }
    }
}

