/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.util;

import ij.IJ;
import ij.gui.GenericDialog;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.RenderingHints;

public class MyMultiLineLabel
extends Canvas {
    private static final long serialVersionUID = 1L;
    protected String[] lines;
    protected int num_lines;
    protected int margin_width = 6;
    protected int margin_height = 6;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int min_width;
    protected int max_width;
    final GenericDialog gd;
    final Panel panel;

    public MyMultiLineLabel(GenericDialog gd, Panel panel, String[] label) {
        this(gd, panel, label, 0);
    }

    public MyMultiLineLabel(GenericDialog gd, Panel panel, String[] label, int minimumWidth) {
        this.num_lines = label.length;
        this.lines = label;
        this.line_widths = new int[this.num_lines];
        this.min_width = minimumWidth;
        this.gd = gd;
        this.panel = panel;
    }

    public String[] getLines() {
        return this.lines;
    }

    public void setText(String[] lines) {
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = i >= lines.length ? " " : lines[i];
        }
        this.updateLabel();
    }

    public void updateLabel() {
        this.update(this.getGraphics());
    }

    public static MyMultiLineLabel addMessage(GenericDialog gd, String[] text, Font font, Color color) {
        Panel panel = new Panel();
        MyMultiLineLabel l = new MyMultiLineLabel(gd, panel, text);
        l.setFont(font);
        l.setForeground(color);
        panel.add(l);
        gd.addPanel(panel);
        return l;
    }

    protected void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return;
        }
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.max_width = 0;
        for (int i = 0; i < this.num_lines; ++i) {
            this.line_widths[i] = fm.stringWidth(this.lines[i]);
            if (this.line_widths[i] <= this.max_width) continue;
            this.max_width = this.line_widths[i];
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.measure();
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Math.max(this.min_width, this.max_width + 2 * this.margin_width), this.num_lines * this.line_height + 2 * this.margin_height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(Math.max(this.min_width, this.max_width), this.num_lines * this.line_height);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (!IJ.isLinux()) {
            this.setAntialiasedText(g);
        }
        int y = this.line_ascent + (d.height - this.num_lines * this.line_height) / 2;
        int i = 0;
        while (i < this.num_lines) {
            int x = this.margin_width;
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.line_height;
        }
    }

    void setAntialiasedText(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

