/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.legacy.LegacyImgLoader;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;

public abstract class AbstractImgLoader
implements LegacyImgLoader<UnsignedShortType> {
    private final HashMap<ViewId, Pair<Dimensions, VoxelDimensions>> imageMetaDataCache = new HashMap();
    private final HashMap<Integer, ViewId> viewIdLookUp = new HashMap();

    protected AbstractImgLoader() {
    }

    protected void updateMetaDataCache(ViewId viewId, int w, int h, int d, double calX, double calY, double calZ) {
        this.imageMetaDataCache.put(viewId, (Pair<Dimensions, VoxelDimensions>)new ValuePair((Object)new FinalDimensions(new long[]{w, h, d}), (Object)new FinalVoxelDimensions("", new double[]{calX, calY, calZ})));
        this.viewIdLookUp.put(viewId.getViewSetupId(), viewId);
    }

    protected abstract void loadMetaData(ViewId var1);

    public Dimensions getImageSize(ViewId view) {
        if (!this.imageMetaDataCache.containsKey(view)) {
            if (!this.viewIdLookUp.containsKey(view.getViewSetupId())) {
                this.loadMetaData(view);
            } else {
                return (Dimensions)this.imageMetaDataCache.get(this.viewIdLookUp.get(view.getViewSetupId())).getA();
            }
        }
        return (Dimensions)this.imageMetaDataCache.get(view).getA();
    }

    public VoxelDimensions getVoxelSize(ViewId view) {
        if (!this.imageMetaDataCache.containsKey(view)) {
            if (!this.viewIdLookUp.containsKey(view.getViewSetupId())) {
                this.loadMetaData(view);
            } else {
                return (VoxelDimensions)this.imageMetaDataCache.get(this.viewIdLookUp.get(view.getViewSetupId())).getB();
            }
        }
        return (VoxelDimensions)this.imageMetaDataCache.get(view).getB();
    }

    public UnsignedShortType getImageType() {
        return new UnsignedShortType();
    }

    public void updateXMLMetaData(SpimData data, boolean forceUpdate) {
        this.updateXMLMetaData(((SequenceDescription)data.getSequenceDescription()).getViewSetupsOrdered(), forceUpdate);
    }

    public void updateXMLMetaData(List<? extends ViewSetup> setups, boolean forceUpdate) {
        for (ViewSetup viewSetup : setups) {
            this.updateXMLMetaData(viewSetup, forceUpdate);
        }
    }

    public boolean updateXMLMetaData(ViewSetup setup, boolean forceUpdate) {
        boolean updated = false;
        if (this.viewIdLookUp.containsKey(setup.getId())) {
            Pair<Dimensions, VoxelDimensions> metaData = this.imageMetaDataCache.get(this.viewIdLookUp.get(setup.getId()));
            if (!setup.hasSize() || forceUpdate) {
                setup.setSize((Dimensions)metaData.getA());
                updated = true;
            }
            if (!setup.hasVoxelSize() || forceUpdate) {
                setup.setVoxelSize((VoxelDimensions)metaData.getB());
                updated = true;
            }
        }
        return updated;
    }

    protected static final void normalize(Img<FloatType> img) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (FloatType t : img) {
            float v = t.get();
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        for (FloatType t : img) {
            t.set((t.get() - min) / (max - min));
        }
    }
}

