/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.boundingbox;

import ij.gui.GenericDialog;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.boundingbox.automatic.MinFilterThreshold;
import spim.process.fusion.export.ImgExport;

public class AutomaticBoundingBox
extends BoundingBoxGUI {
    public static int defaultTimepointIndex = 0;
    public static int defaultChannelIndex = 0;
    public static int defaultDownsamplingAutomatic = 4;
    public static double defaultBackgroundIntensity = 5.0;
    public static int defaultDiscardedObjectSize = 25;
    public static boolean defaultLoadSequentially = true;
    public static boolean defaultDisplaySegmentationImage = false;

    public AutomaticBoundingBox(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
    }

    @Override
    public boolean queryParameters(Fusion fusion, ImgExport imgExport) {
        boolean displaySegmentationImage;
        double[] minBB = new double[3];
        double[] maxBB = new double[3];
        BoundingBoxGUI.computeMaxBoundingBoxDimensions(this.spimData, this.viewIdsToProcess, minBB, maxBB);
        long[] dim = new long[maxBB.length];
        if (this.min == null || this.max == null) {
            this.min = new int[minBB.length];
            this.max = new int[minBB.length];
        }
        for (int d = 0; d < dim.length; ++d) {
            this.min[d] = (int)Math.round(minBB[d]);
            this.max[d] = (int)Math.round(maxBB[d]);
            dim[d] = this.max[d] - this.min[d] + 1;
        }
        GenericDialog gd = new GenericDialog("Automatically define Bounding Box");
        ArrayList<TimePoint> timepointsToProcess = SpimData2.getAllTimePointsSorted(this.spimData, this.viewIdsToProcess);
        ArrayList<Channel> channelsToProcess = SpimData2.getAllChannelsSorted(this.spimData, this.viewIdsToProcess);
        String[] timepoints = this.assembleTimepoints(timepointsToProcess);
        String[] channels = this.assembleChannels(channelsToProcess);
        if (defaultTimepointIndex >= timepoints.length) {
            defaultTimepointIndex = 0;
        }
        if (defaultChannelIndex >= channels.length) {
            defaultChannelIndex = 0;
        }
        gd.addMessage("Parameters for automatic segmentation", GUIHelper.largestatusfont);
        gd.addChoice("Timepoint", timepoints, timepoints[defaultTimepointIndex]);
        gd.addChoice("Channel", channels, channels[defaultChannelIndex]);
        gd.addSlider("Background intensity [%]", 1.0, 99.0, defaultBackgroundIntensity);
        gd.addSlider("Size_of_objects to be discarded", 1.0, 100.0, (double)defaultDiscardedObjectSize);
        gd.addMessage("");
        gd.addSlider("Downsampling", 1.0, 10.0, (double)defaultDownsamplingAutomatic);
        gd.addCheckbox("Load_input_images sequentially", defaultLoadSequentially);
        gd.addCheckbox("Display_image_used for segmentation", defaultDisplaySegmentationImage);
        gd.addMessage("Image size: ???x???x??? pixels", GUIHelper.mediumstatusfont, GUIHelper.good);
        Label l = (Label)gd.getMessage();
        this.addListeners(gd, gd.getNumericFields(), l, dim);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        defaultTimepointIndex = gd.getNextChoiceIndex();
        TimePoint timepoint = (TimePoint)timepointsToProcess.get(defaultTimepointIndex);
        defaultChannelIndex = gd.getNextChoiceIndex();
        Channel channel = (Channel)channelsToProcess.get(defaultChannelIndex);
        double background = defaultBackgroundIntensity = gd.getNextNumber();
        int discardedObjectSize = defaultDiscardedObjectSize = (int)Math.round(gd.getNextNumber());
        this.downsampling = defaultDownsamplingAutomatic = (int)Math.round(gd.getNextNumber());
        defaultLoadSequentially = gd.getNextBoolean();
        boolean loadSequentially = defaultLoadSequentially;
        MinFilterThreshold automatic = new MinFilterThreshold(this.spimData, this.viewIdsToProcess, channel, timepoint, this, background, discardedObjectSize, loadSequentially, displaySegmentationImage = (defaultDisplaySegmentationImage = gd.getNextBoolean()));
        if (!automatic.run()) {
            return false;
        }
        this.min = (int[])automatic.getMin().clone();
        this.max = (int[])automatic.getMax().clone();
        BoundingBoxGUI.defaultMin = (int[])automatic.getMin().clone();
        BoundingBoxGUI.defaultMax = (int[])automatic.getMax().clone();
        return super.queryParameters(fusion, imgExport);
    }

    protected String[] assembleTimepoints(List<TimePoint> timepoints) {
        String[] t = new String[timepoints.size()];
        for (int i = 0; i < timepoints.size(); ++i) {
            t[i] = timepoints.get(i).getName();
        }
        return t;
    }

    protected String[] assembleChannels(List<Channel> channels) {
        String[] c = new String[channels.size()];
        for (int i = 0; i < channels.size(); ++i) {
            c[i] = channels.get(i).getName();
        }
        return c;
    }

    protected void addListeners(GenericDialog gd, Vector<?> tf, final Label label, final long[] dim) {
        final TextField downsample = (TextField)tf.get(2);
        downsample.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent arg0) {
                int downsampling = Integer.parseInt(downsample.getText());
                long numPixels = AutomaticBoundingBox.numPixels(dim, downsampling);
                long megabytes = numPixels * 4L / 0x100000L;
                label.setText("Image size for segmentation: " + dim[0] / (long)downsampling + " x " + dim[1] / (long)downsampling + " x " + dim[2] / (long)downsampling + " pixels, " + megabytes + " MB");
                label.setForeground(GUIHelper.good);
            }
        });
    }

    protected static long numPixels(long[] dim, int downsampling) {
        long numpixels = 1L;
        for (int d = 0; d < dim.length; ++d) {
            numpixels *= dim[d] / (long)downsampling;
        }
        return numpixels;
    }

    @Override
    public AutomaticBoundingBox newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new AutomaticBoundingBox(spimData, viewIdsToProcess);
    }

    @Override
    public String getDescription() {
        return "Estimate automatically (experimental)";
    }
}

