/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.iterator;

import net.imglib2.Interval;
import net.imglib2.iterator.LocalizingIntervalIterator;
import net.imglib2.util.IntervalIndexer;

public class LocalizingZeroMinIntervalIterator
extends LocalizingIntervalIterator {
    public LocalizingZeroMinIntervalIterator(long[] dimensions) {
        super(dimensions);
    }

    public LocalizingZeroMinIntervalIterator(int[] dimensions) {
        super(dimensions);
    }

    public LocalizingZeroMinIntervalIterator(Interval interval) {
        super(interval);
    }

    @Override
    public void fwd() {
        ++this.index;
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1L;
            if (this.position[n] <= this.max[d]) break;
            this.position[d] = 0L;
        }
    }

    @Override
    public void jumpFwd(long i) {
        this.index += i;
        IntervalIndexer.indexToPosition(this.index, this.dimensions, this.position);
    }

    @Override
    public void reset() {
        this.index = -1L;
        this.position[0] = -1L;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = 0L;
        }
    }
}

