/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear.buffer;

import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.buffer.JoinFactory;
import math.geom2d.polygon.Polyline2D;

public class MiterJoinFactory
implements JoinFactory {
    private double minDenom = 1.0E-100;

    public CirculinearContinuousCurve2D createJoin(CirculinearElement2D curve1, CirculinearElement2D curve2, double dist) {
        Point2D pc1 = curve1.lastPoint();
        Point2D pc2 = curve2.firstPoint();
        Vector2D vect1 = curve1.tangent(curve1.t1());
        Vector2D vect2 = curve2.tangent(curve2.t0());
        double theta1 = vect1.angle();
        double theta2 = vect2.angle();
        Point2D center = Point2D.midPoint(pc1, pc2);
        Point2D p1 = Point2D.createPolar(center, dist, theta1 - 1.5707963267948966);
        Point2D p2 = Point2D.createPolar(center, dist, theta2 - 1.5707963267948966);
        double dtheta = Angle2D.formatAngle(theta2 - theta1);
        if (dtheta > Math.PI) {
            dtheta -= Math.PI * 2;
        }
        double denom = Math.cos(dtheta / 2.0);
        denom = Math.max(denom, this.minDenom);
        double hypot = dist / denom;
        if (dtheta > 0.0 ^ dist < 0.0) {
            double angle = theta1 - 1.5707963267948966 + dtheta / 2.0;
            Point2D pt = Point2D.createPolar(center, hypot, angle);
            return new Polyline2D(p1, pt, p2);
        }
        return new Polyline2D(pc1, pc2);
    }
}

