/*
 * Decompiled with CFR 0.152.
 */
package fsalign;

import fsalign.FileListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FolderWatcher
extends TimerTask {
    private final Vector<File> folders = new Vector();
    private final Timer timer = new Timer();
    private final long interval;
    private boolean running = false;
    private final Vector<File> allFileList;
    private final Vector<File> freshFileList;
    private final Vector<FileListener> listenerList;
    private final FileFilter fileFilter;
    private final FileFilter dirFilter;

    public FolderWatcher(String folderName, long inInterval) {
        this(folderName, inInterval, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        });
    }

    public FolderWatcher(String folderName, long inInterval, String ... extension) {
        this(folderName, inInterval, new FileNameExtensionFilter("File extension", extension));
    }

    public FolderWatcher(String folderName, long inInterval, javax.swing.filechooser.FileFilter filter) {
        this(folderName, inInterval, new FileFilterAdapter(filter));
    }

    public FolderWatcher(String folderName, long inInterval, FileFilter filter) {
        this.interval = inInterval;
        this.allFileList = new Vector();
        this.listenerList = new Vector();
        this.freshFileList = new Vector();
        this.fileFilter = filter;
        this.dirFilter = new FolderFilter();
        System.out.println("Folder: " + folderName);
        this.folders.add(new File(folderName));
    }

    public void addListener(FileListener fl) {
        this.listenerList.add(fl);
    }

    public void start() throws IOException {
        if (!this.running) {
            if (!this.folders.get(0).exists()) {
                throw new IOException(this.folders.get(0).getName() + " does not exist");
            }
            if (!this.folders.get(0).isDirectory()) {
                throw new IOException(this.folders.get(0).getName() + " is not a directory");
            }
            this.timer.schedule((TimerTask)this, 0L, this.interval);
            this.running = true;
        }
    }

    public Vector<File> getFileList() {
        return new Vector<File>(this.allFileList);
    }

    public Vector<File> getFreshFileList() {
        return new Vector<File>(this.freshFileList);
    }

    @Override
    public boolean cancel() {
        for (FileListener fl : this.listenerList) {
            fl.stop();
        }
        return super.cancel();
    }

    @Override
    public void run() {
        this.freshFileList.clear();
        for (int i = 0; i < this.folders.size(); ++i) {
            File[] subdirArray;
            for (File subdir : subdirArray = this.folders.get(i).listFiles(this.dirFilter)) {
                if (this.folders.contains(subdir)) continue;
                this.folders.add(subdir);
            }
        }
        for (File folder : this.folders) {
            File[] fileArray;
            for (File f : fileArray = folder.listFiles(this.fileFilter)) {
                if (this.allFileList.contains(f)) continue;
                this.allFileList.add(f);
                this.freshFileList.add(f);
            }
        }
        for (FileListener fl : this.listenerList) {
            fl.handle(this);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Need a directory name");
        } else {
            FolderWatcher fw = new FolderWatcher(args[0], 1100L);
            fw.addListener(new FileListener(){

                @Override
                public void handle(FolderWatcher fw) {
                    Vector<File> fresh = fw.getFreshFileList();
                    if (fresh.size() > 0) {
                        for (File f : fresh) {
                            System.out.println(f);
                        }
                    } else {
                        System.out.println("No new files");
                    }
                    System.out.println();
                }

                @Override
                public void stop() {
                }
            });
            fw.start();
        }
    }

    private static class FileFilterAdapter
    implements FileFilter {
        final javax.swing.filechooser.FileFilter javaxFileFilter;

        public FileFilterAdapter(javax.swing.filechooser.FileFilter filter) {
            this.javaxFileFilter = filter;
        }

        @Override
        public boolean accept(File file) {
            return this.javaxFileFilter.accept(file);
        }
    }

    public static class FolderFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith("trakem2.");
        }
    }
}

