/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.janelia.thickness.inference.InferFromMatrix;

public class Options
implements Serializable {
    private static final long serialVersionUID = 3591334824905556420L;
    public Double scalingFactorRegularizerWeight;
    public Double coordinateUpdateRegularizerWeight;
    public Double shiftProportion;
    public Integer nIterations;
    public Integer comparisonRange;
    public Double minimumSectionThickness;
    public InferFromMatrix.RegularizationType regularizationType;
    public Integer scalingFactorEstimationIterations;
    public Boolean withReorder;
    public Boolean forceMonotonicity;
    public Integer estimateWindowRadius;
    public Double minimumCorrelationValue;

    public static Options generateDefaultOptions() {
        Options result = new Options();
        result.scalingFactorRegularizerWeight = 0.1;
        result.coordinateUpdateRegularizerWeight = 0.0;
        result.shiftProportion = 0.6;
        result.nIterations = 100;
        result.comparisonRange = 10;
        result.minimumSectionThickness = 0.01;
        result.regularizationType = InferFromMatrix.RegularizationType.BORDER;
        result.scalingFactorEstimationIterations = 10;
        result.withReorder = true;
        result.forceMonotonicity = false;
        result.estimateWindowRadius = -1;
        result.minimumCorrelationValue = 0.0;
        return result;
    }

    public static Options read(String filename) throws JsonSyntaxException, JsonIOException, FileNotFoundException {
        Gson gson = new Gson();
        Options opt = (Options)gson.fromJson((Reader)new FileReader(filename), Options.class);
        return opt;
    }

    public Options clone() {
        Options result = new Options();
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.getName().equals("serialVersionUID")) continue;
            try {
                f.set(result, f.get(this));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.getClass().getName());
        sb.append("]\n");
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.getName().equals("serialVersionUID")) continue;
            sb.append(f.getName());
            sb.append("\t");
            try {
                sb.append(f.get(this));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void toFile(String filename) throws IOException {
        Gson gson = new Gson();
        String json = gson.toJson((Object)this);
        Files.write(Paths.get(filename, new String[0]), json.getBytes(), new OpenOption[0]);
    }

    public boolean equals(Object other) {
        if (other instanceof Options) {
            for (Field f : this.getClass().getDeclaredFields()) {
                if (f.getName().equals("serialVersionUID")) continue;
                try {
                    if (f.get(this).equals(f.get(other))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

