/*
 * Decompiled with CFR 0.152.
 */
package view4d;

import ij.ImagePlus;
import ij.ImageStack;
import ij3d.Image3DUniverse;

public class Timeline {
    private final Image3DUniverse univ;
    private Thread playing = null;
    private boolean bounceback = true;
    private boolean shouldPause = false;
    private int delay = 200;

    public Timeline(Image3DUniverse univ) {
        this.univ = univ;
    }

    public Image3DUniverse getUniverse() {
        return this.univ;
    }

    public void setBounceBack(boolean bounce) {
        this.bounceback = bounce;
    }

    public boolean getBounceBack() {
        return this.bounceback;
    }

    public int size() {
        if (this.univ.getContents().size() == 0) {
            return 0;
        }
        return this.univ.getEndTime() - this.univ.getStartTime();
    }

    public void faster() {
        if (this.delay >= 50) {
            this.delay -= 50;
        }
    }

    public void slower() {
        this.delay += 50;
    }

    public ImagePlus record() {
        this.pause();
        int s = this.univ.getStartTime();
        int e = this.univ.getEndTime();
        this.univ.showTimepoint(s);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ImagePlus imp = this.univ.takeSnapshot();
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        stack.addSlice("", imp.getProcessor());
        for (int i = s + 1; i <= e; ++i) {
            this.univ.showTimepoint(i);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            stack.addSlice("", this.univ.takeSnapshot().getProcessor());
        }
        return new ImagePlus("Movie", stack);
    }

    public synchronized void play() {
        if (this.size() == 0) {
            return;
        }
        if (this.playing != null) {
            return;
        }
        this.playing = new Thread(new Runnable(){

            @Override
            public void run() {
                int inc = 1;
                Timeline.this.shouldPause = false;
                while (!Timeline.this.shouldPause) {
                    int next = Timeline.this.univ.getCurrentTimepoint() + inc;
                    if (next > Timeline.this.univ.getEndTime()) {
                        if (Timeline.this.bounceback) {
                            inc = -inc;
                            continue;
                        }
                        next = Timeline.this.univ.getStartTime();
                    } else if (next < Timeline.this.univ.getStartTime()) {
                        inc = -inc;
                        continue;
                    }
                    Timeline.this.univ.showTimepoint(next);
                    try {
                        Thread.sleep(Timeline.this.delay);
                    }
                    catch (Exception e) {
                        Timeline.this.shouldPause = true;
                    }
                }
                Timeline.this.shouldPause = false;
                Timeline.this.playing = null;
            }
        });
        this.playing.start();
    }

    public synchronized void pause() {
        this.shouldPause = true;
    }

    public void next() {
        if (this.univ.getContents().size() == 0) {
            return;
        }
        int curr = this.univ.getCurrentTimepoint();
        if (curr == this.univ.getEndTime()) {
            return;
        }
        this.univ.showTimepoint(curr + 1);
    }

    public void previous() {
        if (this.univ.getContents().size() == 0) {
            return;
        }
        int curr = this.univ.getCurrentTimepoint();
        if (curr == this.univ.getStartTime()) {
            return;
        }
        this.univ.showTimepoint(curr - 1);
    }

    public void first() {
        if (this.univ.getContents().size() == 0) {
            return;
        }
        int first = this.univ.getStartTime();
        if (this.univ.getCurrentTimepoint() == first) {
            return;
        }
        this.univ.showTimepoint(first);
    }

    public void last() {
        if (this.univ.getContents().size() == 0) {
            return;
        }
        int last = this.univ.getEndTime();
        if (this.univ.getCurrentTimepoint() == last) {
            return;
        }
        this.univ.showTimepoint(last);
    }
}

