/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.model;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.AxisOrder;
import bdv.util.BdvFunctions;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerState;
import fiji.plugin.trackmate.util.TMUtils;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.process.LUT;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.inputimage.ImgPlusViewsOld;

public class ImpBdvShowable
implements BdvShowable {
    private final ImagePlus imp;
    private final ImgPlus<? extends NumericType<?>> image;

    public static <T extends NumericType<T>> ImpBdvShowable fromImp(ImagePlus imp) {
        ImgPlus src = TMUtils.rawWraps(imp);
        if (src.dimensionIndex(Axes.CHANNEL) < 0) {
            Views.addDimension((RandomAccessible)src);
        }
        return ImpBdvShowable.fromImp(src, imp);
    }

    public static <T extends NumericType<T>> ImpBdvShowable fromImp(ImgPlus<T> frame, ImagePlus imp) {
        return new ImpBdvShowable(ImpBdvShowable.prepareImage(frame), imp);
    }

    ImpBdvShowable(ImgPlus<? extends NumericType<?>> image, ImagePlus imp) {
        this.image = image;
        this.imp = imp;
    }

    public Interval interval() {
        return this.image;
    }

    public AffineTransform3D transformation() {
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(this.getCalibration(Axes.X), 0.0, 0.0, 0.0, 0.0, this.getCalibration(Axes.Y), 0.0, 0.0, 0.0, 0.0, this.getCalibration(Axes.Z), 0.0);
        return transform;
    }

    public BdvStackSource<?> show(String title, BdvOptions options) {
        String name = this.image.getName();
        BdvOptions options1 = options.axisOrder(this.getAxisOrder()).sourceTransform(this.transformation());
        BdvStackSource stackSource = BdvFunctions.show(this.image, (String)(name == null ? title : name), (BdvOptions)options1);
        List converterSetups = stackSource.getConverterSetups();
        SynchronizedViewerState state = stackSource.getBdvHandle().getViewerPanel().state();
        this.transferChannelSettings(converterSetups);
        this.transferChannelVisibility((ViewerState)state);
        return stackSource;
    }

    private void transferChannelVisibility(ViewerState state) {
        int nChannels = this.imp.getNChannels();
        CompositeImage ci = this.imp.isComposite() ? (CompositeImage)this.imp : null;
        List sources = state.getSources();
        if (ci != null) {
            boolean[] activeChannels = ci.getActiveChannels();
            for (int i = 0; i < Math.min(activeChannels.length, nChannels); ++i) {
                SourceAndConverter source = (SourceAndConverter)sources.get(i);
                state.setSourceActive(source, activeChannels[i]);
                if (!activeChannels[i]) continue;
                state.setCurrentSource(source);
            }
        }
    }

    private void transferChannelSettings(List<ConverterSetup> converterSetups) {
        CompositeImage ci;
        int nChannels = this.imp.getNChannels();
        CompositeImage compositeImage = ci = this.imp.isComposite() ? (CompositeImage)this.imp : null;
        if (ci != null) {
            int mode = ci.getCompositeMode();
            boolean transferColor = mode == 1 || mode == 2;
            for (int c = 0; c < nChannels; ++c) {
                LUT lut = ci.getChannelLut(c + 1);
                ConverterSetup setup = converterSetups.get(c);
                if (transferColor) {
                    setup.setColor(new ARGBType(lut.getRGB(255)));
                } else {
                    setup.setColor(new ARGBType(Color.WHITE.getRGB()));
                }
                setup.setDisplayRange(lut.min, lut.max);
            }
        } else {
            double displayRangeMin = this.imp.getDisplayRangeMin();
            double displayRangeMax = this.imp.getDisplayRangeMax();
            for (int c = 0; c < nChannels; ++c) {
                ConverterSetup setup = converterSetups.get(c);
                LUT[] luts = this.imp.getLuts();
                if (luts.length != 0) {
                    setup.setColor(new ARGBType(luts[0].getRGB(255)));
                }
                setup.setDisplayRange(displayRangeMin, displayRangeMax);
            }
        }
    }

    private static ImgPlus<? extends NumericType<?>> prepareImage(ImgPlus<? extends NumericType<?>> image) {
        List<AxisType> order = Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.CHANNEL, Axes.TIME);
        return ImgPlusViewsOld.sortAxes(ImpBdvShowable.labelAxes(image), order);
    }

    private static ImgPlus<? extends NumericType<?>> labelAxes(ImgPlus<? extends NumericType<?>> image) {
        if (image.firstElement() instanceof ARGBType) {
            return ImgPlusViewsOld.fixAxes(image, Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.TIME));
        }
        if (image.numDimensions() == 4) {
            return ImgPlusViewsOld.fixAxes(image, Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.TIME, Axes.CHANNEL));
        }
        return ImgPlusViewsOld.fixAxes(image, Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.CHANNEL, Axes.TIME));
    }

    private double getCalibration(AxisType axisType) {
        int d = this.image.dimensionIndex(axisType);
        if (d == -1) {
            return 1.0;
        }
        return ((CalibratedAxis)this.image.axis(d)).averageScale((double)this.image.min(d), (double)this.image.max(d));
    }

    private AxisOrder getAxisOrder() {
        String code = IntStream.range(0, this.image.numDimensions()).mapToObj(i -> ((CalibratedAxis)this.image.axis(i)).type().getLabel().substring(0, 1)).collect(Collectors.joining());
        try {
            return AxisOrder.valueOf((String)code);
        }
        catch (IllegalArgumentException e) {
            return AxisOrder.DEFAULT;
        }
    }
}

