/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.CostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.LAPJV;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.SparseCostMatrix;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.imglib2.algorithm.BenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.util.Util;

public class JaqamanLinker<K extends Comparable<K>, J extends Comparable<J>>
extends BenchmarkAlgorithm
implements OutputAlgorithm<Map<K, J>> {
    private Map<K, J> assignments;
    private Map<K, Double> costs;
    private final CostMatrixCreator<K, J> costMatrixCreator;
    private final Logger logger;

    public JaqamanLinker(CostMatrixCreator<K, J> costMatrixCreator, Logger logger) {
        this.costMatrixCreator = costMatrixCreator;
        this.logger = logger;
    }

    public JaqamanLinker(CostMatrixCreator<K, J> costMatrixCreator) {
        this(costMatrixCreator, Logger.VOID_LOGGER);
    }

    public Map<K, J> getResult() {
        return this.assignments;
    }

    public Map<K, Double> getAssignmentCosts() {
        return this.costs;
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        this.logger.setStatus("Creating the main cost matrix...");
        if (!this.costMatrixCreator.checkInput() || !this.costMatrixCreator.process()) {
            this.errorMessage = this.costMatrixCreator.getErrorMessage();
            return false;
        }
        this.logger.setProgress(0.5);
        SparseCostMatrix tl = (SparseCostMatrix)this.costMatrixCreator.getResult();
        List<K> matrixRows = this.costMatrixCreator.getSourceList();
        List<J> matrixCols = this.costMatrixCreator.getTargetList();
        if (matrixCols.isEmpty() || matrixRows.isEmpty()) {
            this.assignments = Collections.emptyMap();
            this.costs = Collections.emptyMap();
            long end = System.currentTimeMillis();
            this.processingTime = end - start;
            return true;
        }
        this.logger.setStatus("Completing the cost matrix...");
        int nCols = tl.getNCols();
        int nRows = tl.getNRows();
        double[] cctr = new double[nRows];
        int[] kktr = new int[nRows];
        for (int i = 0; i < nRows; ++i) {
            kktr[i] = i;
            cctr[i] = this.costMatrixCreator.getAlternativeCostForSource((Comparable)matrixRows.get(i));
        }
        int[] numbertr = new int[nRows];
        Arrays.fill(numbertr, 1);
        SparseCostMatrix tr = new SparseCostMatrix(cctr, kktr, numbertr, nRows);
        double[] ccbl = new double[nCols];
        int[] kkbl = new int[nCols];
        for (int i = 0; i < kkbl.length; ++i) {
            kkbl[i] = i;
            ccbl[i] = this.costMatrixCreator.getAlternativeCostForTarget((Comparable)matrixCols.get(i));
        }
        int[] numberbl = new int[nCols];
        Arrays.fill(numberbl, 1);
        SparseCostMatrix bl = new SparseCostMatrix(ccbl, kkbl, numberbl, nCols);
        double minCost = Math.min(Util.min((double[])ccbl), Util.min((double[])cctr));
        SparseCostMatrix br = tl.transpose();
        br.fillWith(minCost);
        SparseCostMatrix full = tl.hcat(tr).vcat(bl.hcat(br));
        this.logger.setProgress(0.6);
        this.logger.setStatus("Solving the cost matrix...");
        LAPJV solver = new LAPJV(full);
        if (!solver.checkInput() || !solver.process()) {
            this.errorMessage = solver.getErrorMessage();
            return false;
        }
        int[] assgn = solver.getResult();
        this.assignments = new HashMap<K, J>();
        this.costs = new HashMap<K, Double>();
        for (int i = 0; i < assgn.length; ++i) {
            int j = assgn[i];
            if (i >= matrixRows.size() || j >= matrixCols.size()) continue;
            Comparable source = (Comparable)matrixRows.get(i);
            Comparable target = (Comparable)matrixCols.get(j);
            this.assignments.put(source, target);
            double cost = full.get(i, j, Double.POSITIVE_INFINITY);
            this.costs.put(source, cost);
        }
        this.logger.setProgress(1.0);
        this.logger.setStatus("");
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public String resultToString() {
        if (null == this.assignments) {
            return "Not solved yet. Process the algorithm prior to calling this method.";
        }
        HashSet<K> unassignedSources = new HashSet<K>(this.costMatrixCreator.getSourceList());
        HashSet<J> unassignedTargets = new HashSet<J>(this.costMatrixCreator.getTargetList());
        int sw = -1;
        for (Object source : unassignedSources) {
            if (source.toString().length() <= sw) continue;
            sw = source.toString().length();
        }
        ++sw;
        int tw = -1;
        for (Object target : unassignedTargets) {
            if (target.toString().length() <= tw) continue;
            tw = target.toString().length();
        }
        ++tw;
        int cw = 0;
        for (Comparable source : this.assignments.keySet()) {
            double cost = this.costs.get(source);
            if (!(Math.log10(cost) > (double)cw)) continue;
            cw = (int)Math.log10(cost);
        }
        ++cw;
        StringBuilder str = new StringBuilder();
        str.append("Found " + this.assignments.size() + " assignments:\n");
        for (Comparable source : this.assignments.keySet()) {
            Comparable target = (Comparable)this.assignments.get(source);
            unassignedSources.remove(source);
            unassignedTargets.remove(target);
            double cost = this.costs.get(source);
            str.append(String.format("%1$-" + sw + "s \u2192 %2$" + tw + "s, cost = %3$" + cw + ".1f\n", source.toString(), target.toString(), cost));
        }
        if (!unassignedSources.isEmpty()) {
            str.append("Found " + unassignedSources.size() + " unassigned sources:\n");
            for (Comparable us : unassignedSources) {
                str.append(String.format("%1$-" + sw + "s \u2192 %2$" + tw + "s\n", us.toString(), Character.valueOf('\u00f8')));
            }
        }
        if (!unassignedTargets.isEmpty()) {
            str.append("Found " + unassignedTargets.size() + " unassigned targets:\n");
            for (Comparable ut : unassignedTargets) {
                str.append(String.format("%1$-" + sw + "s \u2192 %2$" + tw + "s\n", Character.valueOf('\u00f8'), ut.toString()));
            }
        }
        return str.toString();
    }
}

