/*
 * Decompiled with CFR 0.152.
 */
package org.renjin;

import org.renjin.invoke.annotations.Operand;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class DistanceMatrix
extends DoubleVector
implements DeferredComputation {
    @Operand
    private Vector vector;
    private int size;
    private int length;

    public DistanceMatrix(Vector vector2, AttributeMap attributes2) {
        super(attributes2);
        this.vector = vector2;
        this.size = vector2.length();
        this.length = this.size * this.size;
    }

    public DistanceMatrix(Vector vector2) {
        this(vector2, AttributeMap.dim(vector2.length(), vector2.length()));
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new DistanceMatrix(this.vector, attributes2);
    }

    @Override
    public double getElementAsDouble(int index) {
        int col2;
        int size = this.vector.length();
        int row2 = index % size;
        if (row2 == (col2 = index / size)) {
            return 0.0;
        }
        double x = this.getOperandElementAsDouble(row2);
        double y = this.getOperandElementAsDouble(col2);
        return Math.abs(x - y);
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    public static double test(int index, int size) {
        return Math.sqrt(index % size);
    }

    private double getOperandElementAsDouble(int row2) {
        return this.vector.getElementAsDouble(row2);
    }

    @Override
    public int length() {
        return this.getOperandLength() * this.getOperandLength();
    }

    private int getOperandLength() {
        return this.vector.length();
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    @Override
    public String getComputationName() {
        return "dist";
    }
}

