/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.CmpGE;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.ElementAccess;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.Increment;
import org.renjin.compiler.ir.tac.expressions.Length;
import org.renjin.compiler.ir.tac.expressions.LocalVariable;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.compiler.ir.tac.expressions.Temp;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.LoopContext;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class ForTranslator
extends FunctionCallTranslator {
    @Override
    public Symbol getName() {
        return Symbol.get("for");
    }

    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        this.addForLoop(builder, context, call2);
        return new Constant(Null.INSTANCE);
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        this.addForLoop(builder, context, call2);
    }

    private void addForLoop(IRBodyBuilder factory, TranslationContext context, FunctionCall call2) {
        Symbol symbol2 = (Symbol)call2.getArgument(0);
        LocalVariable counter = factory.newLocalVariable();
        Temp length2 = factory.newTemp();
        EnvironmentVariable elementVariable = new EnvironmentVariable(symbol2);
        SimpleExpression vector2 = factory.translateSimpleExpression(context, (SEXP)call2.getArgument(1));
        Object body2 = call2.getArgument(2);
        IRLabel counterLabel = factory.newLabel();
        IRLabel bodyLabel = factory.newLabel();
        IRLabel nextLabel = factory.newLabel();
        IRLabel exitLabel = factory.newLabel();
        factory.addStatement(new Assignment(counter, new Constant(0)));
        factory.addStatement(new Assignment(length2, new Length(vector2)));
        factory.addLabel(counterLabel);
        factory.addStatement(new IfStatement(new CmpGE(counter, length2), exitLabel, bodyLabel));
        factory.addLabel(bodyLabel);
        factory.addStatement(new Assignment(elementVariable, new ElementAccess(vector2, counter)));
        LoopContext loopContext = new LoopContext(nextLabel, exitLabel);
        factory.translateStatements(loopContext, (SEXP)body2);
        factory.addLabel(nextLabel);
        factory.addStatement(new Assignment(counter, new Increment(counter)));
        factory.addStatement(new GotoStatement(counterLabel));
        factory.addLabel(exitLabel);
    }
}

