/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.ConversionException;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.LongArrayVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;

public class ObjectConverter
implements Converter<Object> {
    public static final Converter INSTANCE = new ObjectConverter();

    private ObjectConverter() {
    }

    @Override
    public SEXP convertToR(Object value) {
        if (value == null) {
            return Null.INSTANCE;
        }
        Converter converter = Converters.get(value.getClass());
        return converter.convertToR(value);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        try {
            this.convertToJava(exp2);
            return true;
        }
        catch (ConversionException e) {
            return false;
        }
    }

    @Override
    public Object convertToJava(SEXP exp2) {
        AtomicVector vector2;
        if (exp2 == Null.INSTANCE) {
            return null;
        }
        if (exp2 instanceof ExternalPtr) {
            ExternalPtr ptr = (ExternalPtr)exp2;
            return ptr.getInstance();
        }
        if (exp2 instanceof LongArrayVector && exp2.length() == 1) {
            return ((LongArrayVector)exp2).getElementAsLong(0);
        }
        if (exp2 instanceof AtomicVector && exp2.length() == 1 && !(vector2 = (AtomicVector)exp2).isElementNA(0)) {
            return vector2.getElementAsObject(0);
        }
        return exp2;
    }

    @Override
    public int getSpecificity() {
        return 100;
    }

    public static boolean accept(Class clazz) {
        return clazz.equals(Object.class);
    }
}

