/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.parser;

import org.renjin.sexp.StringVector;

public class StringLiterals {
    public static String format(String value, String naString) {
        if (StringVector.isNA(value)) {
            return naString;
        }
        StringBuilder sb = new StringBuilder("\"");
        StringLiterals.appendEscaped(sb, value);
        sb.append('\"');
        return sb.toString();
    }

    public static void appendEscaped(StringBuilder buf, String s) {
        for (int i = 0; i != s.length(); ++i) {
            int codePoint = s.codePointAt(i);
            if (codePoint == 10) {
                buf.append("\\n");
                continue;
            }
            if (codePoint == 13) {
                buf.append("\\r");
                continue;
            }
            if (codePoint == 9) {
                buf.append("\\t");
                continue;
            }
            if (codePoint == 7) {
                buf.append("\\a");
                continue;
            }
            if (codePoint == 8) {
                buf.append("\\b");
                continue;
            }
            if (codePoint == 12) {
                buf.append("\\f");
                continue;
            }
            if (codePoint == 11) {
                buf.append("\\v");
                continue;
            }
            if (codePoint == 34) {
                buf.append("\\\"");
                continue;
            }
            if (codePoint == 92) {
                buf.append("\\\\");
                continue;
            }
            if (codePoint < 32 || codePoint > 126) {
                StringLiterals.appendUnicodeEscape(buf, codePoint);
                continue;
            }
            buf.appendCodePoint(codePoint);
        }
    }

    private static void appendUnicodeEscape(StringBuilder buf, int codePoint) {
        buf.append("\\u");
        if (codePoint < 15) {
            buf.append("000");
        } else if (codePoint < 255) {
            buf.append("00");
        } else if (codePoint < 4095) {
            buf.append("0");
        }
        buf.append(Integer.toHexString(codePoint));
    }
}

