/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.primitives.combine.view.CombinedDoubleVector;
import org.renjin.primitives.combine.view.CombinedIntVector;
import org.renjin.primitives.combine.view.CombinedStringVector;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.primitives.sequence.RepStringVector;
import org.renjin.primitives.vector.PrefixedStringVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class LazyBuilder
implements CombinedBuilder {
    private final Vector.Type vectorType;
    private int elementCount;
    private boolean useNames;
    private List<Vector> vectors;
    private List<Vector> nameVectors;
    private boolean hasNames = false;

    public LazyBuilder(Vector.Type vectorType, int elementCount) {
        this.vectorType = vectorType;
        this.elementCount = elementCount;
        this.vectors = Lists.newArrayListWithCapacity((int)elementCount);
    }

    @Override
    public CombinedBuilder useNames(boolean useNames) {
        if (useNames) {
            this.useNames = true;
            this.nameVectors = Lists.newArrayListWithCapacity((int)this.elementCount);
        }
        return this;
    }

    @Override
    public void add(String prefix, SEXP sexp) {
        throw new UnsupportedOperationException("LazyCombiner can only handle Vector inputs");
    }

    @Override
    public void addElements(String prefix, Vector vectorElement) {
        this.vectors.add(vectorElement);
        if (this.useNames) {
            this.nameVectors.add(this.composeNames(prefix, vectorElement));
        }
    }

    private Vector composeNames(String prefix, Vector vector2) {
        AtomicVector names2 = vector2.getNames();
        int numElements = vector2.length();
        if (!Strings.isNullOrEmpty((String)prefix) || names2 != Null.INSTANCE) {
            this.hasNames = true;
        }
        if (Strings.isNullOrEmpty((String)prefix) && names2 == Null.INSTANCE) {
            return RepStringVector.createConstantVector("", numElements);
        }
        if (Strings.isNullOrEmpty((String)prefix)) {
            return names2;
        }
        if (names2 == Null.INSTANCE) {
            return new PrefixedStringVector(prefix, new IntSequence(1, 1, numElements), AttributeMap.EMPTY);
        }
        return new PrefixedStringVector(prefix + ".", names2, AttributeMap.EMPTY);
    }

    @Override
    public Vector build() {
        Vector[] vectors = this.toArray(this.vectors);
        if (this.vectorType == IntVector.VECTOR_TYPE) {
            return CombinedIntVector.combine(vectors, this.buildAttributes());
        }
        if (this.vectorType == DoubleVector.VECTOR_TYPE) {
            return CombinedDoubleVector.combine(vectors, this.buildAttributes());
        }
        if (this.vectorType == StringVector.VECTOR_TYPE) {
            return CombinedStringVector.combine(vectors, this.buildAttributes());
        }
        throw new UnsupportedOperationException("vector type: " + this.vectorType);
    }

    private AttributeMap buildAttributes() {
        if (this.hasNames) {
            return new AttributeMap.Builder().setNames(CombinedStringVector.combine(this.nameVectors, AttributeMap.EMPTY)).build();
        }
        return AttributeMap.EMPTY;
    }

    private Vector[] toArray(List<Vector> list2) {
        return list2.toArray(new Vector[list2.size()]);
    }
}

