/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DefaultValue;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.invoke.annotations.Unevaluated;
import org.renjin.methods.MethodDispatch;
import org.renjin.primitives.Types;
import org.renjin.primitives.subset.SubscriptOperation;
import org.renjin.primitives.subset.VectorIndexSelection;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListBuilder;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Subsetting {
    private Subsetting() {
    }

    private static Symbol asSymbol(SEXP nameExp) {
        if (nameExp instanceof Symbol) {
            return (Symbol)nameExp;
        }
        if (nameExp instanceof StringVector && nameExp.length() == 1) {
            return Symbol.get(((StringVector)nameExp).getElementAsString(0));
        }
        throw new EvalException("illegal argument: " + nameExp, new Object[0]);
    }

    private static String asString(SEXP nameExp) {
        if (nameExp instanceof Symbol) {
            return ((Symbol)nameExp).getPrintName();
        }
        if (nameExp instanceof StringVector && nameExp.length() == 1) {
            return ((StringVector)nameExp).getElementAsString(0);
        }
        throw new EvalException("illegal argument: " + nameExp, new Object[0]);
    }

    @Builtin(value="$<-")
    public static SEXP setElementByName(ExternalPtr<?> externalPtr, @Unevaluated SEXP nameExp, SEXP value) {
        externalPtr.setMember(Subsetting.asSymbol(nameExp), value);
        return externalPtr;
    }

    @Builtin(value="@")
    public static SEXP getSlotValue(@Current Context context, @Current MethodDispatch methods, SEXP object2, @Unevaluated Symbol slotName) {
        if (slotName.getPrintName().equals(".Data")) {
            return context.evaluate(FunctionCall.newCall(Symbol.get("getDataPart"), object2), methods.getMethodsNamespace());
        }
        if (!Types.isS4(object2)) {
            SEXP className = object2.getAttribute(Symbols.CLASS_NAME);
            if (className.length() == 0) {
                throw new EvalException("trying to get slot \"%s\" from an object of a basic class (\"%s\") with no slots", slotName.getPrintName(), object2.getS3Class().getElementAsString(0));
            }
            throw new EvalException("trying to get slot \"%s\" from an object (class \"%s\") that is not an S4 object ", slotName.getPrintName(), className.getElementAsSEXP(0));
        }
        SEXP value = object2.getAttribute(slotName);
        if (value == Null.INSTANCE) {
            if (slotName == Symbol.get(".S3Class")) {
                throw new EvalException("not implemented: .S3Class", new Object[0]);
            }
            if (slotName == Symbols.NAMES && object2 instanceof ListVector) {
                return value;
            }
            throw new EvalException("cannot get slot %s", slotName);
        }
        if (value == Symbols.S4_NULL) {
            return Null.INSTANCE;
        }
        return value;
    }

    @Builtin(value="$<-")
    public static SEXP setElementByName(ListVector list2, @Unevaluated Symbol name, SEXP value) {
        return Subsetting.setSingleElement((ListBuilder)list2.newCopyNamedBuilder(), name.getPrintName(), value);
    }

    @Builtin(value="$<-")
    public static SEXP setElementByName(AtomicVector vector2, @Unevaluated Symbol nameToReplace, SEXP value) {
        ListVector.NamedBuilder copyBuilder = ListVector.newNamedBuilder();
        StringVector namesVector = vector2.getAttributes().getNames();
        for (int i = 0; i != vector2.length(); ++i) {
            String elementName = null;
            if (namesVector != null) {
                elementName = namesVector.getElementAsString(i);
            }
            copyBuilder.add(elementName, (SEXP)vector2.getElementAsSEXP(i));
        }
        return Subsetting.setSingleElement((ListBuilder)copyBuilder, nameToReplace.getPrintName(), value);
    }

    @Builtin(value="$<-")
    public static SEXP setElementByName(PairList.Node pairList, @Unevaluated Symbol name, SEXP value) {
        return Subsetting.setSingleElement((ListBuilder)pairList.newCopyBuilder(), name.getPrintName(), value);
    }

    @Builtin(value="$<-")
    public static SEXP setElementByName(Environment env2, @Unevaluated Symbol name, SEXP value) {
        env2.setVariable(name, value);
        return env2;
    }

    @Builtin(value=".subset")
    public static SEXP subset(SEXP source, @ArgumentList ListVector arguments, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        Vector vector2;
        if (source instanceof Vector) {
            vector2 = (Vector)source;
        } else if (source instanceof PairList) {
            vector2 = ((PairList)source).toVector();
        } else {
            throw new EvalException(source.getClass().getName(), new Object[0]);
        }
        return Subsetting.getSubset(vector2, arguments, drop2);
    }

    @Builtin(value=".subset2")
    public static SEXP getSingleElementNonGeneric(SEXP source, @ArgumentList ListVector subscripts, @NamedFlag(value="exact") @DefaultValue(value=true) boolean exact, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        return Subsetting.getSingleElement(source, subscripts, exact, drop2);
    }

    @Generic
    @Builtin(value="[[")
    public static SEXP getSingleElement(SEXP source, @ArgumentList ListVector subscripts, @NamedFlag(value="exact") @DefaultValue(value=true) boolean exact, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        if (source == Null.INSTANCE) {
            return source;
        }
        String nameSubscript = Subsetting.isSingleStringSubscript(subscripts);
        if (nameSubscript != null) {
            return Subsetting.getSingleElementByName(source, nameSubscript, exact);
        }
        if (source instanceof PairList) {
            source = ((PairList)source).toVector();
        }
        if (source instanceof ListVector && Subsetting.isRecursiveIndexingArgument(subscripts)) {
            return Subsetting.getSingleElementRecursively((ListVector)source, (AtomicVector)subscripts.getElementAsSEXP(0), exact, drop2);
        }
        return new SubscriptOperation().setSource(source, subscripts).setDrop(true).extractSingle();
    }

    private static boolean isRecursiveIndexingArgument(ListVector subscripts) {
        if (subscripts.length() != 1) {
            return false;
        }
        SEXP subscript = subscripts.getElementAsSEXP(0);
        if (!(subscript instanceof AtomicVector)) {
            return false;
        }
        return subscript.length() > 1;
    }

    private static SEXP getSingleElementRecursively(ListVector source, AtomicVector indexes, boolean exact, boolean drop2) {
        assert (indexes.length() > 0);
        SEXP result = source;
        for (int i = 0; i < indexes.length(); ++i) {
            if (!(result instanceof ListVector)) {
                throw new EvalException("Recursive indexing failed at level %d", i + 1);
            }
            result = Subsetting.getSingleElement(result, new ListVector(new SEXP[]{indexes.getElementAsSEXP(i)}), exact, drop2);
        }
        return result;
    }

    private static String isSingleStringSubscript(ListVector subscripts) {
        if (subscripts.length() != 1) {
            return null;
        }
        SEXP subscript = subscripts.getElementAsSEXP(0);
        if (subscript instanceof StringVector && subscript.length() == 1) {
            return ((StringVector)subscript).getElementAsString(0);
        }
        return null;
    }

    private static SEXP getSingleElementByName(SEXP source, String subscript, boolean exact) {
        if (source instanceof Environment) {
            return Subsetting.getSingleEnvironmentVariable((Environment)source, subscript, exact);
        }
        if (source instanceof PairList) {
            return Subsetting.getSingleVectorElement(((PairList)source).toVector(), subscript, exact);
        }
        if (source instanceof Vector) {
            return Subsetting.getSingleVectorElement((Vector)source, subscript, exact);
        }
        throw new EvalException("object of type '%s' is not subsettable", source.getTypeName());
    }

    private static SEXP getSingleVectorElement(Vector source, String subscript, boolean exact) {
        AtomicVector names2 = source.getNames();
        if (names2 == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        Null partialMatch = Null.INSTANCE;
        int matchCount = 0;
        for (int i = 0; i != names2.length(); ++i) {
            if (names2.isElementNA(i)) continue;
            if (names2.getElementAsString(i).equals(subscript)) {
                return source.getElementAsSEXP(i);
            }
            if (exact || !names2.getElementAsString(i).startsWith(subscript)) continue;
            ++matchCount;
            partialMatch = source.getElementAsSEXP(i);
        }
        if (matchCount == 1) {
            return partialMatch;
        }
        return Null.INSTANCE;
    }

    private static SEXP getSingleEnvironmentVariable(Environment source, String subscript, boolean exact) {
        SEXP value = exact ? source.getVariable(subscript) : source.getVariableByPrefix(subscript);
        if (value == Symbol.UNBOUND_VALUE) {
            return Null.INSTANCE;
        }
        return value;
    }

    @Generic
    @Builtin(value="[")
    public static SEXP getSubset(SEXP source, @ArgumentList ListVector subscripts, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        if (source == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        if (source instanceof FunctionCall) {
            return Subsetting.getCallSubset((FunctionCall)source, subscripts);
        }
        if (source instanceof PairList.Node) {
            return Subsetting.getSubset(((PairList.Node)source).toVector(), subscripts, drop2);
        }
        if (source instanceof Vector) {
            return Subsetting.getSubset((Vector)source, subscripts, drop2);
        }
        throw new EvalException("invalid source", new Object[0]);
    }

    private static SEXP getCallSubset(FunctionCall source, ListVector subscripts) {
        VectorIndexSelection selection = new VectorIndexSelection(source, subscripts.get(0));
        FunctionCall.Builder call2 = FunctionCall.newBuilder();
        call2.withAttributes(source.getAttributes());
        for (Integer sourceIndex : selection) {
            call2.addCopy(source.getNode(sourceIndex));
        }
        return call2.build();
    }

    private static SEXP getSubset(Vector source, ListVector subscripts, boolean drop2) {
        return new SubscriptOperation().setSource(source, subscripts).setDrop(drop2).extract();
    }

    @Generic
    @Builtin(value="[<-")
    public static SEXP setSubset(SEXP source, @ArgumentList ListVector arguments) {
        SEXP replacement = arguments.getElementAsSEXP(arguments.length() - 1);
        return new SubscriptOperation().setSource(source, arguments, 0, 1).replace(replacement);
    }

    @Generic
    @Builtin(value="[[<-")
    public static SEXP setSingleElement(AtomicVector source, Vector index, Vector replacement) {
        if (source.length() == 0) {
            return Subsetting.setSingleElement((ListBuilder)new ListVector.NamedBuilder(), index.getElementAsInt(0), (SEXP)replacement);
        }
        return new SubscriptOperation().setSource(source, new ListVector(index), 0, 0).replace(replacement);
    }

    @Generic
    @Builtin(value="[[<-")
    public static Environment setSingleElement(Environment environment2, String name, SEXP replacement) {
        environment2.setVariable(name, replacement);
        return environment2;
    }

    @Generic
    @Builtin(value="[[<-")
    public static SEXP setSingleElement(PairList.Node pairList, int indexToReplace, SEXP replacement) {
        return Subsetting.setSingleElement((ListBuilder)pairList.newCopyBuilder(), indexToReplace, replacement);
    }

    @Generic
    @Builtin(value="[[<-")
    public static SEXP setSingleElement(PairList.Node pairList, String nameToReplace, SEXP replacement) {
        return Subsetting.setSingleElement((ListBuilder)pairList.newCopyBuilder(), nameToReplace, replacement);
    }

    @Generic
    @Builtin(value="[[<-")
    public static SEXP setSingleElement(ListVector list2, int indexToReplace, SEXP replacement) {
        return Subsetting.setSingleElement((ListBuilder)list2.newCopyNamedBuilder(), indexToReplace, replacement);
    }

    @Generic
    @Builtin(value="[[<-")
    public static SEXP setSingleElement(ListVector list2, String nameToReplace, SEXP replacement) {
        return Subsetting.setSingleElement((ListBuilder)list2.newCopyNamedBuilder(), nameToReplace, replacement);
    }

    private static SEXP setSingleElement(ListBuilder result, int indexToReplace, SEXP replacement) {
        if (replacement == Null.INSTANCE) {
            if (indexToReplace < result.length()) {
                result.remove(indexToReplace - 1);
            }
        } else if (indexToReplace <= result.length()) {
            result.set(indexToReplace - 1, replacement);
        } else {
            int newLength = indexToReplace;
            while (result.length() < newLength - 1) {
                result.add(Null.INSTANCE);
            }
            result.add(replacement);
        }
        return result.build();
    }

    private static SEXP setSingleElement(ListBuilder builder, String nameToReplace, SEXP replacement) {
        int index = builder.getIndexByName(nameToReplace);
        if (replacement == Null.INSTANCE) {
            if (index != -1) {
                builder.remove(index);
            }
        } else if (index == -1) {
            builder.add(nameToReplace, replacement);
        } else {
            builder.set(index, replacement);
        }
        return builder.build();
    }
}

