/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.optimize;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.direct.NelderMead;
import org.apache.commons.math.optimization.univariate.BrentOptimizer;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.Types;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.stats.internals.optimize.MultivariateRealClosure;
import org.renjin.stats.internals.optimize.RUncminFunction;
import org.renjin.stats.internals.optimize.Uncmin;
import org.renjin.stats.internals.optimize.UnivariateRealClosure;

public class Optimizations {
    @Internal
    public static SEXP nlm(@Current Context context, @Current Environment rho, Function fn, DoubleVector p, boolean want_hessian, DoubleVector typesize, double fscale, int msg, int ndigit, double gradtl, double stepmx, double steptol, int itnlim) {
        double[] fpls = new double[]{-1.0, -1.0};
        int itncnt = -1;
        int[] code = new int[]{-1, -1};
        RUncminFunction state = new RUncminFunction(context, rho, fn);
        int n = 0;
        double[] x = Optimizations.fixparam(p, n);
        n = p.length();
        double[] typsiz = Optimizations.fixparam(typesize, n);
        Optimizations.assertNotNA(fscale);
        int omsg = msg;
        Optimizations.assertNotNA(msg);
        Optimizations.assertNotNA(ndigit);
        Optimizations.assertNotNA(gradtl);
        Optimizations.assertNotNA(stepmx);
        Optimizations.assertNotNA(steptol);
        Optimizations.assertNotNA(itnlim);
        boolean iagflg = false;
        boolean iahflg = false;
        state.setHaveGradient(false);
        state.setHaveHessian(false);
        SEXP value = state.doApply(x);
        SEXP v = value.getAttribute(RUncminFunction.GRADIENT);
        if (v != Null.INSTANCE && v.length() == n && (v instanceof DoubleVector || v instanceof IntVector)) {
            iagflg = true;
            state.setHaveGradient(true);
            v = value.getAttribute(RUncminFunction.HESSIAN);
            if (v != Null.INSTANCE && v.length() == n * n && (v instanceof DoubleVector || v instanceof IntVector)) {
                iahflg = true;
                state.setHaveHessian(true);
            }
        }
        if (msg / 4 % 2 != 0 && !iahflg) {
            msg -= 4;
        }
        if (msg / 2 % 2 != 0 && !iagflg) {
            msg -= 2;
        }
        Uncmin.Method method = Uncmin.Method.LINE_SEARCH;
        boolean iexp = !iahflg;
        double dlt = 1.0;
        double[] xpls = Uncmin.f77_array(n);
        double[] gpls = Uncmin.f77_array(n);
        double[][] a = Uncmin.f77_array(n, n);
        double[] wrk = new double[8 * n];
        Uncmin.optif9_f77(n, Uncmin.to_f77(x), state, Uncmin.to_f77(typsiz), fscale, method, iexp, new int[]{0, msg}, new int[]{0, ndigit}, new int[]{0, itnlim}, new int[]{0, iagflg ? 1 : 0}, new int[]{0, iahflg ? 1 : 0}, new double[]{0.0, dlt}, new double[]{0.0, gradtl}, new double[]{0.0, stepmx}, new double[]{0.0, steptol}, xpls, fpls, gpls, code, a, wrk);
        if (msg < 0) {
            Optimizations.opterror(msg);
        }
        if (code[0] != 0 && (omsg & 8) == 0) {
            Optimizations.optcode(code[0]);
        }
        ListVector.NamedBuilder result = new ListVector.NamedBuilder();
        if (want_hessian) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    a[i + j * n] = a[j + i * n];
                }
            }
        }
        result.add("minimum", (SEXP)new DoubleArrayVector(fpls[1]));
        result.add("estimate", (SEXP)new DoubleArrayVector(Uncmin.from_f77(xpls)));
        result.add("gradient", (SEXP)new DoubleArrayVector(Uncmin.from_f77(gpls)));
        if (want_hessian) {
            // empty if block
        }
        result.add("code", (SEXP)new IntArrayVector(code[1]));
        result.add("iterations", (SEXP)new IntArrayVector(itncnt));
        return result.build();
    }

    private static void optcode(int code) {
    }

    private static void opterror(int msg) {
    }

    static double[] fixparam(AtomicVector p, int n) {
        if (!Types.isNumeric(p)) {
            throw new EvalException("numeric parameter expected", new Object[0]);
        }
        if (n > 0) {
            if (p.length() != n) {
                throw new EvalException("conflicting parameter lengths", new Object[0]);
            }
        } else if (p.length() <= 0) {
            throw new EvalException("invalid parameter length", new Object[0]);
        }
        if (p.containsNA()) {
            throw new EvalException("missing value in parameter", new Object[0]);
        }
        return p.toDoubleArray();
    }

    private static void assertNotNA(int x) {
        if (IntVector.isNA(x)) {
            throw new EvalException("invalid NA in parameter", new Object[0]);
        }
    }

    private static void assertNotNA(double x) {
        if (DoubleVector.isNA(x)) {
            throw new EvalException("invalid NA parameter", new Object[0]);
        }
    }

    @Internal
    public static double fmin(@Current Context context, @Current Environment rho, Function fn, double lower, double upper, double tol) {
        BrentOptimizer optimizer = new BrentOptimizer();
        optimizer.setAbsoluteAccuracy(tol);
        try {
            return optimizer.optimize((UnivariateRealFunction)new UnivariateRealClosure(context, rho, fn), GoalType.MINIMIZE, lower, upper);
        }
        catch (MaxIterationsExceededException e) {
            throw new EvalException("maximum iterations reached", e);
        }
        catch (FunctionEvaluationException e) {
            throw new EvalException(e);
        }
    }

    @Internal
    public static ListVector optim(@Current Context context, @Current Environment rho, DoubleVector par2, Function fn, SEXP gradientFunction, String method, ListVector controlParameters, DoubleVector lower, DoubleVector upper) {
        MultivariateRealClosure g = new MultivariateRealClosure(context, rho, fn);
        if (method.equals("Nelder-Mead")) {
            NelderMead optimizer = new NelderMead();
            try {
                RealPointValuePair res = optimizer.optimize((MultivariateRealFunction)g, GoalType.MINIMIZE, par2.toDoubleArray());
                ListVector.Builder result = new ListVector.Builder();
                result.add(new DoubleArrayVector(res.getPoint()));
                result.add(new DoubleArrayVector(res.getValue()));
                result.add(new IntArrayVector(Integer.MIN_VALUE, Integer.MIN_VALUE));
                result.add(new IntArrayVector(0));
                result.add(Null.INSTANCE);
                return result.build();
            }
            catch (FunctionEvaluationException e) {
                throw new EvalException(e);
            }
            catch (OptimizationException e) {
                throw new EvalException(e);
            }
        }
        throw new EvalException("method '" + method + "' not implemented.", new Object[0]);
    }
}

