/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import customnode.CustomTriangleMesh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;

public class MeshEditor {
    public static void smooth(CustomTriangleMesh c, float K) {
        List triangles = c.getMesh();
        if (0 != triangles.size() % 3) {
            System.out.println("MeshEditor.smooth: need a list of points multiple of 3.");
            return;
        }
        Hashtable ht = new Hashtable();
        for (int i = 0; i < triangles.size(); i += 3) {
            Point3f p1 = (Point3f)triangles.get(i);
            Point3f p2 = (Point3f)triangles.get(i + 1);
            Point3f p3 = (Point3f)triangles.get(i + 2);
            MeshEditor.build(p1, p2, p3, ht);
            MeshEditor.build(p2, p3, p1, ht);
            MeshEditor.build(p3, p1, p2, ht);
        }
        for (PointGroup pg : ht.values()) {
            pg.smoothMembers(K);
        }
        c.update();
    }

    private static void build(Point3f p1, Point3f p2, Point3f p3, Hashtable ht) {
        PointGroup pg = (PointGroup)ht.get(p1);
        if (null != pg) {
            pg.addMember(p1);
        } else {
            pg = new PointGroup(p1);
            ht.put(p1, pg);
        }
        pg.addEdge(p2);
        pg.addEdge(p3);
    }

    private static final Vertex uniqueVertex(Point3f p, HashMap<Point3f, Vertex> verts) {
        Vertex v = verts.get(p);
        if (null == v) {
            v = new Vertex(p);
            verts.put(p, v);
        } else {
            v.copies.add(p);
        }
        return v;
    }

    public static void smooth2(CustomTriangleMesh c, int iterations) {
        MeshEditor.smooth2(c.getMesh(), iterations);
        c.update();
    }

    protected static void smooth2(List<Point3f> triangles, int iterations) {
        int i;
        HashMap<Point3f, Vertex> verts = new HashMap<Point3f, Vertex>();
        HashSet<Edge> edges = new HashSet<Edge>();
        for (i = 0; i < triangles.size(); i += 3) {
            Vertex v1 = MeshEditor.uniqueVertex(triangles.get(i), verts);
            Vertex v2 = MeshEditor.uniqueVertex(triangles.get(i + 1), verts);
            Vertex v3 = MeshEditor.uniqueVertex(triangles.get(i + 2), verts);
            edges.add(new Edge(v1, v2));
            edges.add(new Edge(v2, v3));
            edges.add(new Edge(v1, v3));
            if (0 != i % 300 || !Thread.currentThread().isInterrupted()) continue;
            return;
        }
        for (i = 0; i < iterations; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            for (Edge e : edges) {
                e.averageVertices();
            }
            for (Vertex v : verts.values()) {
                v.smooth();
            }
            if (i + 1 >= iterations) continue;
            for (Vertex v : verts.values()) {
                v.reset();
            }
        }
    }

    private static final class Edge {
        private final Vertex v1;
        private final Vertex v2;

        Edge(Vertex v1, Vertex v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public final boolean equals(Object ob) {
            Edge e = (Edge)ob;
            return e == this || e.v1 == this.v1 && e.v2 == this.v2 || e.v1 == this.v2 && e.v2 == this.v1;
        }

        private final void averageVertices() {
            this.v1.average(this.v2);
        }
    }

    private static final class Vertex {
        private final Point3f p;
        private final ArrayList<Point3f> copies = new ArrayList();
        private final Point3f tmp;
        private int n;

        Vertex(Point3f p) {
            this.p = p;
            this.tmp = new Point3f(0.0f, 0.0f, 0.0f);
            this.copies.add(p);
        }

        private final void reset() {
            this.tmp.set(0.0f, 0.0f, 0.0f);
            this.n = 0;
        }

        public final boolean equals(Object ob) {
            Vertex v = (Vertex)ob;
            return v.p == this.p || v.p.x == this.p.x && v.p.y == this.p.y && v.p.z == this.p.z;
        }

        private final void average(Vertex v) {
            ++this.n;
            ++v.n;
            Point3f a = new Point3f((this.p.x + v.p.x) / 2.0f, (this.p.y + v.p.y) / 2.0f, (this.p.z + v.p.z) / 2.0f);
            this.tmp.add((Tuple3f)a);
            v.tmp.add((Tuple3f)a);
        }

        private final void smooth() {
            float f = 0.5f / (float)this.n;
            this.tmp.set(0.5f * this.p.x + f * this.tmp.x, 0.5f * this.p.y + f * this.tmp.y, 0.5f * this.p.z + f * this.tmp.z);
            for (Point3f p : this.copies) {
                p.set((Tuple3f)this.tmp);
            }
        }
    }

    private static class PointGroup {
        Point3f first;
        HashSet edges = new HashSet();
        ArrayList members = new ArrayList();
        float vx;
        float vy;
        float vz;

        PointGroup(Point3f first) {
            this.first = first;
            this.members.add(first);
        }

        void addMember(Point3f p) {
            this.members.add(p);
        }

        void addEdge(Point3f p) {
            this.edges.add(p);
        }

        void smoothMembers(float K) {
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.vz = 0.0f;
            for (Point3f po : this.edges) {
                this.vx += po.x;
                this.vy += po.y;
                this.vz += po.z;
            }
            int size = this.edges.size();
            this.vx = (this.vx / (float)size - this.first.x) * K;
            this.vy = (this.vy / (float)size - this.first.y) * K;
            this.vz = (this.vz / (float)size - this.first.z) * K;
            for (Point3f m : this.members) {
                m.x += this.vx;
                m.y += this.vy;
                m.z += this.vz;
            }
        }

        void computeVector(float K) {
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.vz = 0.0f;
            for (Point3f po : this.edges) {
                this.vx += po.x;
                this.vy += po.y;
                this.vz += po.z;
            }
            int size = this.edges.size();
            this.vx = (this.vx / (float)size - this.first.x) * K;
            this.vy = (this.vy / (float)size - this.first.y) * K;
            this.vz = (this.vz / (float)size - this.first.z) * K;
        }

        void applyVector(Hashtable ht) {
            float ax = 0.0f;
            float ay = 0.0f;
            float az = 0.0f;
            int count = 0;
            Iterator it = this.edges.iterator();
            while (it.hasNext()) {
                PointGroup pg = (PointGroup)ht.get(it.next());
                if (null == pg) continue;
                ++count;
                ax += pg.vx;
                ay += pg.vy;
                az += pg.vz;
            }
            ax += this.vx;
            ay += this.vy;
            az += this.vz;
            ax /= (float)(++count);
            ay /= (float)count;
            az /= (float)count;
            for (Point3f m : this.members) {
                m.x += this.vx;
                m.y += this.vy;
                m.z += this.vz;
            }
        }
    }
}

