/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.AutoThresholdRegression;
import sc.fiji.coloc.algorithms.CostesSignificanceTest;
import sc.fiji.coloc.algorithms.Histogram2D;
import sc.fiji.coloc.algorithms.InputCheck;
import sc.fiji.coloc.algorithms.KendallTauRankCorrelation;
import sc.fiji.coloc.algorithms.LiHistogram2D;
import sc.fiji.coloc.algorithms.LiICQ;
import sc.fiji.coloc.algorithms.MandersColocalization;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.algorithms.PearsonsCorrelation;
import sc.fiji.coloc.algorithms.SpearmanRankCorrelation;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.AnalysisResults;
import sc.fiji.coloc.results.PDFWriter;
import sc.fiji.coloc.results.ResultHandler;
import sc.fiji.coloc.results.SingleWindowDisplay;
import sc.fiji.coloc.results.Warning;

public class Coloc_2<T extends RealType<T> & NativeType<T>>
implements PlugIn {
    protected static final String PREF_KEY = "Coloc_2.";
    protected RoiConfiguration roiConfig = RoiConfiguration.Img1;
    protected ArrayList<MaskInfo> masks = new ArrayList();
    protected String[] regressions = new String[AutoThresholdRegression.Implementation.values().length];
    protected static int index1 = 0;
    protected static int index2 = 1;
    protected static int indexMask = 0;
    protected static int indexRoi = 0;
    protected static int indexRegr = 0;
    protected Img<T> img1;
    protected Img<T> img2;
    protected String Ch1Name = "";
    protected String Ch2Name = "";
    protected int img1Channel = 1;
    protected int img2Channel = 1;
    protected PearsonsCorrelation<T> pearsonsCorrelation;
    protected LiHistogram2D<T> liHistogramCh1;
    protected LiHistogram2D<T> liHistogramCh2;
    protected LiICQ<T> liICQ;
    protected SpearmanRankCorrelation<T> SpearmanRankCorrelation;
    protected MandersColocalization<T> mandersCorrelation;
    protected KendallTauRankCorrelation<T> kendallTau;
    protected Histogram2D<T> histogram2D;
    protected CostesSignificanceTest<T> costesSignificance;
    protected boolean displayImages;
    protected boolean autoSavePdf;

    public void run(String arg0) {
        if (this.showDialog()) {
            try {
                for (MaskInfo mi : this.masks) {
                    this.colocalise(this.img1, this.img2, mi.roi, mi.mask);
                }
            }
            catch (MissingPreconditionException e) {
                IJ.handleException((Throwable)e);
                IJ.showMessage((String)"An error occured, could not colocalize!");
                return;
            }
        }
    }

    public boolean showDialog() {
        int[] windowList = WindowManager.getIDList();
        if (windowList == null || windowList.length < 2) {
            IJ.showMessage((String)"At least 2 images must be open!");
            return false;
        }
        GenericDialog gd = new GenericDialog("Coloc 2");
        String[] titles = new String[windowList.length];
        String[] roisAndMasks = new String[windowList.length + 4];
        roisAndMasks[0] = "<None>";
        roisAndMasks[1] = "ROI(s) in channel 1";
        roisAndMasks[2] = "ROI(s) in channel 2";
        roisAndMasks[3] = "ROI Manager";
        for (int i = 0; i < windowList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)windowList[i]);
            if (imp != null) {
                titles[i] = imp.getTitle();
                roisAndMasks[i + 4] = imp.getTitle();
                continue;
            }
            titles[i] = "";
        }
        AutoThresholdRegression.Implementation[] regressionImplementations = AutoThresholdRegression.Implementation.values();
        for (int i = 0; i < regressionImplementations.length; ++i) {
            this.regressions[i] = regressionImplementations[i].toString();
        }
        this.displayImages = Prefs.get((String)"Coloc_2.displayImages", (boolean)false);
        this.autoSavePdf = Prefs.get((String)"Coloc_2.autoSavePdf", (boolean)true);
        boolean displayShuffledCostes = Prefs.get((String)"Coloc_2.displayShuffledCostes", (boolean)false);
        boolean useLiCh1 = Prefs.get((String)"Coloc_2.useLiCh1", (boolean)true);
        boolean useLiCh2 = Prefs.get((String)"Coloc_2.useLiCh2", (boolean)true);
        boolean useLiICQ = Prefs.get((String)"Coloc_2.useLiICQ", (boolean)true);
        boolean useSpearmanRank = Prefs.get((String)"Coloc_2.useSpearmanRank", (boolean)true);
        boolean useManders = Prefs.get((String)"Coloc_2.useManders", (boolean)true);
        boolean useKendallTau = Prefs.get((String)"Coloc_2.useKendallTau", (boolean)true);
        boolean useScatterplot = Prefs.get((String)"Coloc_2.useScatterplot", (boolean)true);
        boolean useCostes = Prefs.get((String)"Coloc_2.useCostes", (boolean)true);
        int psf = (int)Prefs.get((String)"Coloc_2.psf", (double)3.0);
        int nrCostesRandomisations = (int)Prefs.get((String)"Coloc_2.nrCostesRandomisations", (double)10.0);
        indexRegr = (int)Prefs.get((String)"Coloc_2.regressionImplementation", (double)0.0);
        index1 = Coloc_2.clip(index1, 0, titles.length);
        index2 = Coloc_2.clip(index2, 0, titles.length);
        indexMask = Coloc_2.clip(indexMask, 0, roisAndMasks.length - 1);
        gd.addChoice("Channel_1", titles, titles[index1]);
        gd.addChoice("Channel_2", titles, titles[index2]);
        gd.addChoice("ROI_or_mask", roisAndMasks, roisAndMasks[indexMask]);
        gd.addChoice("Threshold_regression", this.regressions, this.regressions[indexRegr]);
        gd.addCheckbox("Show_Save_PDF_Dialog", this.autoSavePdf);
        gd.addCheckbox("Display_Images_in_Result", this.displayImages);
        gd.addCheckbox("Display_Shuffled_Images", displayShuffledCostes);
        final Checkbox shuffleCb = (Checkbox)gd.getCheckboxes().lastElement();
        gd.addMessage("Algorithms:");
        gd.addCheckbox("Li_Histogram_Channel_1", useLiCh1);
        gd.addCheckbox("Li_Histogram_Channel_2", useLiCh2);
        gd.addCheckbox("Li_ICQ", useLiICQ);
        gd.addCheckbox("Spearman's_Rank_Correlation", useSpearmanRank);
        gd.addCheckbox("Manders'_Correlation", useManders);
        gd.addCheckbox("Kendall's_Tau_Rank_Correlation", useKendallTau);
        gd.addCheckbox("2D_Intensity_Histogram", useScatterplot);
        gd.addCheckbox("Costes'_Significance_Test", useCostes);
        final Checkbox costesCb = (Checkbox)gd.getCheckboxes().lastElement();
        gd.addNumericField("PSF", (double)psf, 1);
        gd.addNumericField("Costes_randomisations", (double)nrCostesRandomisations, 0);
        shuffleCb.setEnabled(useCostes);
        costesCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                shuffleCb.setEnabled(costesCb.getState());
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        ImagePlus gdImp1 = WindowManager.getImage((int)(gd.getNextChoiceIndex() + 1));
        ImagePlus gdImp2 = WindowManager.getImage((int)(gd.getNextChoiceIndex() + 1));
        int gdIndexMask = gd.getNextChoiceIndex();
        int gdIndexRegr = gd.getNextChoiceIndex();
        boolean gdAutoSavePdf = gd.getNextBoolean();
        boolean gdDisplayImages = gd.getNextBoolean();
        boolean gdDisplayShuffledCostes = gd.getNextBoolean();
        boolean gdUseLiCh1 = gd.getNextBoolean();
        boolean gdUseLiCh2 = gd.getNextBoolean();
        boolean gdUseLiICQ = gd.getNextBoolean();
        boolean gdUseSpearmanRank = gd.getNextBoolean();
        boolean gdUseManders = gd.getNextBoolean();
        boolean gdUseKendallTau = gd.getNextBoolean();
        boolean gdUseScatterplot = gd.getNextBoolean();
        boolean gdUseCostes = gd.getNextBoolean();
        int gdPsf = (int)gd.getNextNumber();
        int gdNrCostesRandomisations = (int)gd.getNextNumber();
        Prefs.set((String)"Coloc_2.regressionImplementation", (int)gdIndexRegr);
        Prefs.set((String)"Coloc_2.autoSavePdf", (boolean)gdAutoSavePdf);
        Prefs.set((String)"Coloc_2.displayImages", (boolean)gdDisplayImages);
        Prefs.set((String)"Coloc_2.displayShuffledCostes", (boolean)gdDisplayShuffledCostes);
        Prefs.set((String)"Coloc_2.useLiCh1", (boolean)gdUseLiCh1);
        Prefs.set((String)"Coloc_2.useLiCh2", (boolean)gdUseLiCh2);
        Prefs.set((String)"Coloc_2.useLiICQ", (boolean)gdUseLiICQ);
        Prefs.set((String)"Coloc_2.useSpearmanRank", (boolean)gdUseSpearmanRank);
        Prefs.set((String)"Coloc_2.useManders", (boolean)gdUseManders);
        Prefs.set((String)"Coloc_2.useKendallTau", (boolean)gdUseKendallTau);
        Prefs.set((String)"Coloc_2.useScatterplot", (boolean)gdUseScatterplot);
        Prefs.set((String)"Coloc_2.useCostes", (boolean)gdUseCostes);
        Prefs.set((String)"Coloc_2.psf", (int)gdPsf);
        Prefs.set((String)"Coloc_2.nrCostesRandomisations", (int)gdNrCostesRandomisations);
        return this.initializeSettings(gdImp1, gdImp2, gdIndexMask, gdIndexRegr, gdAutoSavePdf, gdDisplayImages, gdDisplayShuffledCostes, gdUseLiCh1, gdUseLiCh2, gdUseLiICQ, gdUseSpearmanRank, gdUseManders, gdUseKendallTau, gdUseScatterplot, gdUseCostes, gdPsf, gdNrCostesRandomisations);
    }

    public boolean initializeSettings(ImagePlus imp1, ImagePlus imp2, int gdIndexMask, int gdIndexRegr, boolean gdAutoSavePdf, boolean gdDisplayImages, boolean gdDisplayShuffledCostes, boolean gdUseLiCh1, boolean gdUseLiCh2, boolean gdUseLiICQ, boolean gdUseSpearmanRank, boolean gdUseManders, boolean gdUseKendallTau, boolean gdUseScatterplot, boolean gdUseCostes, int gdPsf, int gdNrCostesRandomisations) {
        this.Ch1Name = imp1.getTitle();
        this.Ch2Name = imp2.getTitle();
        if (imp1.getBitDepth() == 24 || imp2.getBitDepth() == 24) {
            IJ.showMessage((String)"You should not use RGB color images to measure colocalization. Provide each channel as a 8-bit or 16-bit image.");
            return false;
        }
        if (imp1.getBitDepth() != imp2.getBitDepth()) {
            IJ.showMessage((String)"Both images must have the same bit-depth.");
            return false;
        }
        indexMask = gdIndexMask;
        if (indexMask == 0) {
            this.roiConfig = RoiConfiguration.None;
        } else if (indexMask == 1) {
            this.roiConfig = RoiConfiguration.Img1;
        } else if (indexMask == 2) {
            this.roiConfig = RoiConfiguration.Img2;
        } else if (indexMask == 3) {
            this.roiConfig = RoiConfiguration.RoiManager;
        } else {
            this.roiConfig = RoiConfiguration.Mask;
            indexMask -= 4;
        }
        this.img1 = ImagePlusAdapter.wrap((ImagePlus)imp1);
        this.img2 = ImagePlusAdapter.wrap((ImagePlus)imp2);
        if (this.roiConfig == RoiConfiguration.Img1 && this.hasValidRoi(imp1)) {
            this.createMasksFromImage(imp1);
        } else if (this.roiConfig == RoiConfiguration.Img2 && this.hasValidRoi(imp2)) {
            this.createMasksFromImage(imp2);
        } else if (this.roiConfig == RoiConfiguration.RoiManager) {
            if (!this.createMasksFromRoiManager(imp1.getWidth(), imp1.getHeight())) {
                return false;
            }
        } else if (this.roiConfig == RoiConfiguration.Mask) {
            int[] windowList = WindowManager.getIDList();
            ImagePlus maskImp = WindowManager.getImage((int)windowList[indexMask]);
            ImagePlusImg maskImg = ImagePlusAdapter.wrap((ImagePlus)maskImp);
            MaskInfo mi = this.getBoundingBoxOfMask((Img<T>)maskImg);
            this.masks.add(mi);
        } else {
            this.masks.add(new MaskInfo(null, null));
        }
        indexRegr = gdIndexRegr;
        this.autoSavePdf = gdAutoSavePdf;
        this.displayImages = gdDisplayImages;
        this.pearsonsCorrelation = new PearsonsCorrelation(PearsonsCorrelation.Implementation.Fast);
        if (gdUseLiCh1) {
            this.liHistogramCh1 = new LiHistogram2D("Li - Ch1", true);
        }
        if (gdUseLiCh2) {
            this.liHistogramCh2 = new LiHistogram2D("Li - Ch2", false);
        }
        if (gdUseLiICQ) {
            this.liICQ = new LiICQ();
        }
        if (gdUseSpearmanRank) {
            this.SpearmanRankCorrelation = new SpearmanRankCorrelation();
        }
        if (gdUseManders) {
            this.mandersCorrelation = new MandersColocalization();
        }
        if (gdUseKendallTau) {
            this.kendallTau = new KendallTauRankCorrelation();
        }
        if (gdUseScatterplot) {
            this.histogram2D = new Histogram2D("2D intensity histogram");
        }
        if (gdUseCostes) {
            this.costesSignificance = new CostesSignificanceTest<T>(this.pearsonsCorrelation, gdPsf, gdNrCostesRandomisations, gdDisplayShuffledCostes);
        }
        return true;
    }

    public void colocalise(Img<T> image1, Img<T> image2, BoundingBox roi, Img<T> mask) throws MissingPreconditionException {
        this.colocalise(image1, image2, roi, mask, null);
    }

    /*
     * WARNING - void declaration
     */
    public AnalysisResults<T> colocalise(Img<T> image1, Img<T> image2, BoundingBox roi, Img<T> mask, List<ResultHandler<T>> extraHandlers) throws MissingPreconditionException {
        SingleWindowDisplay<T> swDisplay;
        DataContainer<T> container = mask != null ? new DataContainer<T>(image1, image2, this.img1Channel, this.img2Channel, this.Ch1Name, this.Ch2Name, mask, roi.offset, roi.size) : (roi != null ? new DataContainer<T>(image1, image2, this.img1Channel, this.img2Channel, this.Ch1Name, this.Ch2Name, roi.offset, roi.size) : new DataContainer<T>(image1, image2, this.img1Channel, this.img2Channel, this.Ch1Name, this.Ch2Name));
        ArrayList<ResultHandler<T>> listOfResultHandlers = new ArrayList<ResultHandler<T>>();
        AnalysisResults analysisResults = new AnalysisResults();
        listOfResultHandlers.add(analysisResults);
        PDFWriter<T> pdfWriter = new PDFWriter<T>(container);
        boolean headless = Boolean.getBoolean("java.awt.headless");
        if (headless) {
            swDisplay = null;
        } else {
            swDisplay = new SingleWindowDisplay<T>(container, pdfWriter);
            listOfResultHandlers.add(swDisplay);
        }
        listOfResultHandlers.add(pdfWriter);
        if (extraHandlers != null) {
            listOfResultHandlers.addAll(extraHandlers);
        }
        ArrayList<Algorithm<T>> userSelectedJobs = new ArrayList<Algorithm<T>>();
        userSelectedJobs.add(container.setInputCheck(new InputCheck()));
        userSelectedJobs.add(container.setAutoThreshold(new AutoThresholdRegression<T>(this.pearsonsCorrelation, AutoThresholdRegression.Implementation.values()[indexRegr])));
        this.addIfValid(this.pearsonsCorrelation, userSelectedJobs);
        this.addIfValid(this.liHistogramCh1, userSelectedJobs);
        this.addIfValid(this.liHistogramCh2, userSelectedJobs);
        this.addIfValid(this.liICQ, userSelectedJobs);
        this.addIfValid(this.SpearmanRankCorrelation, userSelectedJobs);
        this.addIfValid(this.mandersCorrelation, userSelectedJobs);
        this.addIfValid(this.kendallTau, userSelectedJobs);
        this.addIfValid(this.histogram2D, userSelectedJobs);
        this.addIfValid(this.costesSignificance, userSelectedJobs);
        int count = 0;
        int jobs = userSelectedJobs.size();
        for (Algorithm algorithm : userSelectedJobs) {
            try {
                IJ.showStatus((String)(++count + "/" + jobs + ": Running " + algorithm.getName()));
                algorithm.execute(container);
            }
            catch (MissingPreconditionException e) {
                for (ResultHandler resultHandler : listOfResultHandlers) {
                    resultHandler.handleWarning(new Warning("Probem with input data", algorithm.getName() + ": " + e.getMessage()));
                }
            }
        }
        IJ.showStatus((String)"");
        for (Algorithm algorithm : userSelectedJobs) {
            for (ResultHandler resultHandler : listOfResultHandlers) {
                algorithm.processResults(resultHandler);
            }
        }
        if (this.displayImages) {
            void var16_21;
            RandomAccessibleInterval<T> channel1;
            swDisplay.displayOriginalImages = true;
            if (mask != null || roi != null) {
                long[] offset = container.getMaskBBOffset();
                long[] lArray = container.getMaskBBSize();
                channel1 = this.createMaskImage(container.getSourceImage1(), container.getMask(), offset, lArray);
                RandomAccessibleInterval<T> randomAccessibleInterval = this.createMaskImage(container.getSourceImage2(), container.getMask(), offset, lArray);
            } else {
                channel1 = container.getSourceImage1();
                RandomAccessibleInterval<T> randomAccessibleInterval = container.getSourceImage2();
            }
            channel1 = this.project(channel1);
            RandomAccessibleInterval<T> randomAccessibleInterval = this.project((RandomAccessibleInterval<T>)var16_21);
            for (ResultHandler resultHandler : listOfResultHandlers) {
                resultHandler.handleImage(channel1, "Channel 1 (Max Projection)");
                resultHandler.handleImage(randomAccessibleInterval, "Channel 2 (Max Projection)");
            }
        }
        if (swDisplay != null) {
            swDisplay.process();
            swDisplay.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    WindowManager.removeWindow((Frame)swDisplay);
                    swDisplay.dispose();
                    swDisplay.removeWindowListener(this);
                }
            });
            WindowManager.addWindow(swDisplay);
        }
        if (this.autoSavePdf) {
            pdfWriter.process();
        }
        return analysisResults;
    }

    private RandomAccessibleInterval<T> project(RandomAccessibleInterval<T> image) {
        if (image.numDimensions() < 2) {
            throw new IllegalArgumentException("Dimensionality too small: " + image.numDimensions());
        }
        IterableInterval input = Views.iterable(image);
        RealType type = (RealType)input.firstElement();
        long xLen = image.dimension(0);
        long yLen = image.dimension(1);
        long[] outputDims = new long[]{xLen, yLen};
        ArrayImg output = new ArrayImgFactory().create(outputDims, (NativeType)type);
        for (RealType sample : output) {
            sample.setReal(type.getMinValue());
        }
        Cursor inPos = input.localizingCursor();
        RandomAccess outPos = output.randomAccess();
        while (inPos.hasNext()) {
            RealType inPix = (RealType)inPos.next();
            long xPos = inPos.getLongPosition(0);
            long yPos = inPos.getLongPosition(1);
            outPos.setPosition(xPos, 0);
            outPos.setPosition(yPos, 1);
            RealType outPix = (RealType)outPos.get();
            if (outPix.compareTo((Object)inPix) >= 0) continue;
            outPix.set((Type)inPix);
        }
        return output;
    }

    protected MaskInfo getBoundingBoxOfMask(Img<T> mask) {
        int d;
        Cursor cursor = mask.localizingCursor();
        int numMaskDims = mask.numDimensions();
        RealType offType = (RealType)((RealType)mask.firstElement()).createVariable();
        offType.setZero();
        long[][] minMax = new long[2][];
        boolean maskFound = false;
        long[] pos = new long[numMaskDims];
        while (cursor.hasNext()) {
            cursor.fwd();
            RealType data = (RealType)cursor.get();
            if (data.compareTo((Object)offType) <= 0) continue;
            cursor.localize(pos);
            if (!maskFound) {
                maskFound = true;
                minMax[0] = Arrays.copyOf(pos, numMaskDims);
                minMax[1] = Arrays.copyOf(pos, numMaskDims);
                continue;
            }
            for (d = 0; d < numMaskDims; ++d) {
                if (pos[d] < minMax[0][d]) {
                    minMax[0][d] = pos[d];
                    continue;
                }
                if (pos[d] <= minMax[1][d]) continue;
                minMax[1][d] = pos[d];
            }
        }
        if (!maskFound) {
            return null;
        }
        long[] size = new long[numMaskDims];
        for (d = 0; d < numMaskDims; ++d) {
            size[d] = minMax[1][d] - minMax[0][d] + 1L;
        }
        BoundingBox bb = new BoundingBox(minMax[0], size);
        return new MaskInfo(bb, mask);
    }

    protected void addIfValid(Algorithm<T> a, List<Algorithm<T>> list) {
        if (a != null) {
            list.add(a);
        }
    }

    protected boolean hasValidRoi(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null) {
            return false;
        }
        Rectangle theROI = roi.getBounds();
        return theROI.height != imp.getHeight() || theROI.width != imp.getWidth();
    }

    protected static int clip(int val, int min, int max) {
        return Math.max(Math.min(val, max), min);
    }

    protected void createMasksFromImage(ImagePlus imp) {
        Roi[] impRois = Coloc_2.split(imp.getRoi());
        this.createMasksAndRois(impRois, imp.getWidth(), imp.getHeight());
    }

    protected boolean createMasksFromRoiManager(int width, int height) {
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null) {
            IJ.error((String)"Could not get ROI Manager instance.");
            return false;
        }
        Roi[] selectedRois = roiManager.getSelectedRoisAsArray();
        this.createMasksAndRois(selectedRois, width, height);
        return true;
    }

    protected void createMasksAndRois(Roi[] rois, int width, int height) {
        this.masks.clear();
        for (Roi r : rois) {
            MaskInfo mi = new MaskInfo();
            this.masks.add(mi);
            Rectangle rect = r.getBounds();
            mi.roi = new BoundingBox(new long[]{rect.x, rect.y}, new long[]{rect.width, rect.height});
            ImageProcessor ipMask = r.getMask();
            if (ipMask == null) continue;
            ImageProcessor ipSlice = ipMask.createProcessor(width, height);
            ipSlice.setValue(0.0);
            ipSlice.fill();
            ipSlice.copyBits(ipMask, (int)mi.roi.offset[0], (int)mi.roi.offset[1], 0);
            ImagePlus maskImp = new ImagePlus("Mask", ipSlice);
            mi.mask = ImagePlusAdapter.wrap((ImagePlus)maskImp);
        }
    }

    protected RandomAccessibleInterval<T> createMaskImage(RandomAccessibleInterval<T> image, RandomAccessibleInterval<BitType> mask, long[] offset, long[] size) throws MissingPreconditionException {
        long[] pos = new long[image.numDimensions()];
        if (pos.length != offset.length || pos.length != size.length) {
            throw new MissingPreconditionException("Mask offset and size must be of same dimensionality like image.");
        }
        TwinCursor cursor = new TwinCursor(image.randomAccess(), image.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        ArrayImgFactory maskFactory = new ArrayImgFactory();
        Img maskImage = maskFactory.create(size, (Object)((RealType)image.randomAccess().get()).createVariable());
        RandomAccess maskCursor = maskImage.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(pos);
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = pos[i] - offset[i];
            }
            maskCursor.setPosition(pos);
            ((RealType)maskCursor.get()).set(cursor.getFirst());
        }
        return maskImage;
    }

    public static Roi[] split(Roi roi) {
        if (roi instanceof ShapeRoi) {
            return ((ShapeRoi)roi).getRois();
        }
        return new Roi[]{roi};
    }

    protected static enum RoiConfiguration {
        None,
        Img1,
        Img2,
        Mask,
        RoiManager;

    }

    protected class MaskInfo {
        BoundingBox roi;
        public Img<T> mask;

        public MaskInfo(BoundingBox roi, Img<T> mask) {
            this.roi = roi;
            this.mask = mask;
        }

        public MaskInfo() {
        }
    }

    protected class BoundingBox {
        public long[] offset;
        public long[] size;

        public BoundingBox(long[] offset, long[] size) {
            this.offset = (long[])offset.clone();
            this.size = (long[])size.clone();
        }
    }
}

