/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.ShaderAttributeArrayRetained;
import org.jogamp.java3d.ShaderAttributeObject;

public class ShaderAttributeArray
extends ShaderAttributeObject {
    public ShaderAttributeArray(String attrName, Object value) {
        super(attrName, value);
    }

    @Override
    public Object getValue() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeObject0"));
        }
        return ((ShaderAttributeArrayRetained)this.retained).getValue();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeObject1"));
        }
        if (this.isLive()) {
            ((ShaderAttributeArrayRetained)this.retained).setValue(value);
        } else {
            ((ShaderAttributeArrayRetained)this.retained).initValue(value);
        }
    }

    public void setValue(int index, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeObject1"));
        }
        if (this.isLive()) {
            ((ShaderAttributeArrayRetained)this.retained).setValue(index, value);
        } else {
            ((ShaderAttributeArrayRetained)this.retained).initValue(index, value);
        }
    }

    public int length() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeObject0"));
        }
        return ((ShaderAttributeArrayRetained)this.retained).length();
    }

    @Override
    void createRetained() {
        this.retained = new ShaderAttributeArrayRetained();
        this.retained.setSource(this);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof ShaderAttributeArray) {
            Object[] otherValues;
            Object[] values;
            int n;
            ShaderAttributeArray anotherShaderAttributeArray = (ShaderAttributeArray)anObject;
            if (this.getAttributeName().equals(anotherShaderAttributeArray.getAttributeName()) && (n = (values = (Object[])this.getValue()).length) == (otherValues = (Object[])anotherShaderAttributeArray.getValue()).length) {
                int i = 0;
                while (n-- != 0) {
                    if (!values[i].equals(otherValues[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }
}

