/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.scijava.Context;
import org.scijava.util.FileUtils;

public final class AppUtils {
    private AppUtils() {
    }

    @Deprecated
    public static File getBaseDirectory() {
        return org.scijava.util.AppUtils.getBaseDirectory((String)"ij.dir", AppUtils.class, (String)"core/core");
    }

    public static Map<String, URL> findResources(String regex, String pathPrefix) {
        ClassLoader loader = Context.getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            urls.addAll(Collections.list(loader.getResources(pathPrefix + "/")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File baseDirectory = AppUtils.getBaseDirectory();
        if (baseDirectory != null) {
            try {
                urls.add(new File(baseDirectory, pathPrefix).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return AppUtils.findResources(regex, urls);
    }

    public static Map<String, URL> findResources(String regex, Iterable<URL> urls) {
        HashMap<String, URL> result = new HashMap<String, URL>();
        Pattern pattern = regex == null ? null : Pattern.compile(regex);
        for (URL url : urls) {
            AppUtils.getResources(pattern, result, url);
        }
        return result;
    }

    private static void getResources(Pattern pattern, Map<String, URL> result, URL base) {
        String prefix = AppUtils.urlPath(base);
        if (prefix == null) {
            return;
        }
        for (URL url : FileUtils.listContents((URL)base)) {
            String key;
            String s = AppUtils.urlPath(url);
            if (s == null || !s.startsWith(prefix) || pattern != null && !pattern.matcher(s).matches() || (key = AppUtils.urlPath(s.substring(prefix.length()))) == null) continue;
            result.put(key, url);
        }
    }

    private static String urlPath(URL url) {
        try {
            return url.toURI().toString();
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    private static String urlPath(String path) {
        try {
            return new URI(path).getPath();
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }
}

