/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.scijava.Context;
import org.scijava.prefs.PrefService;

public class Preferences {
    private final PrefService prefService;
    private static final String KEY = "default_labels";

    public Preferences(Context context) {
        this.prefService = (PrefService)context.service(PrefService.class);
    }

    public List<String> getDefaultLabels() {
        String s = this.prefService.get(Preferences.class, KEY);
        return s == null || s.isEmpty() ? Arrays.asList("background", "foreground") : Arrays.asList(s.split(","));
    }

    public void setDefaultLabels(List<String> labels) {
        StringJoiner joiner = new StringJoiner(",");
        labels.forEach(joiner::add);
        this.prefService.put(Preferences.class, KEY, joiner.toString());
    }
}

