/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush;

import bdv.util.Affine3DHelpers;
import bdv.util.BdvHandle;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.ViewerPanel;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.util.Intervals;
import net.imglib2.util.LinAlgHelpers;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.ScrollBehaviour;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.ActionsAndBehaviours;
import sc.fiji.labkit.ui.brush.BdvMouseBehaviourUtils;
import sc.fiji.labkit.ui.brush.BrushCursor;
import sc.fiji.labkit.ui.brush.neighborhood.Ellipsoid;
import sc.fiji.labkit.ui.brush.neighborhood.RealPoints;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.models.LabelingModel;
import sc.fiji.labkit.ui.panel.GuiUtils;
import sc.fiji.labkit.ui.utils.Notifier;

public class LabelBrushController {
    private final BdvHandle bdv;
    private final ViewerPanel viewer;
    private final LabelingModel model;
    private final BrushCursor brushCursor;
    private final MoveBrush moveBrushBehaviour = new MoveBrush();
    private final MouseAdapter moveBrushAdapter = GuiUtils.toMouseListener(this.moveBrushBehaviour);
    private final PaintBehavior paintBehaviour = new PaintBehavior(true);
    private final PaintBehavior eraseBehaviour = new PaintBehavior(false);
    private double brushDiameter = 1.0;
    private final Notifier brushDiameterListeners = new Notifier();
    private boolean overlapping = false;
    private boolean keepBrushCursorVisible = false;
    private boolean planarMode = false;

    public LabelBrushController(BdvHandle bdv, LabelingModel model, ActionsAndBehaviours behaviors) {
        this.bdv = bdv;
        this.viewer = bdv.getViewerPanel();
        this.brushCursor = new BrushCursor(model);
        this.model = model;
        this.updateBrushOverlayRadius();
        this.viewer.getDisplay().addOverlayRenderer((OverlayRenderer)this.brushCursor);
        this.viewer.addTransformListener(affineTransform3D -> this.updateBrushOverlayRadius());
        this.installDefaultBehaviors(behaviors);
    }

    private void installDefaultBehaviors(ActionsAndBehaviours behaviors) {
        behaviors.addBehaviour(this.paintBehaviour, "paint", "D button1", "SPACE button1");
        RunnableAction nop = new RunnableAction("nop", () -> {});
        nop.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F"));
        behaviors.addAction(nop);
        behaviors.addBehaviour(this.eraseBehaviour, "erase", "E button1", "SPACE button2", "SPACE button3");
        behaviors.addBehaviour(new ChangeBrushRadius(), "change brush radius", "D scroll", "E scroll", "SPACE scroll");
        behaviors.addBehaviour(this.moveBrushBehaviour, "move brush", "E", "D", "SPACE");
    }

    public void setBrushActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive(this.bdv, this.paintBehaviour, active);
        this.setBrushCursorActive(active);
        this.keepBrushCursorVisible = active;
    }

    public void setEraserActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive(this.bdv, this.eraseBehaviour, active);
        this.setBrushCursorActive(active);
        this.keepBrushCursorVisible = active;
    }

    private void setBrushCursorActive(boolean visible) {
        if (visible) {
            this.viewer.getDisplay().addMouseListener((MouseListener)this.moveBrushAdapter);
            this.viewer.getDisplay().addMouseMotionListener((MouseMotionListener)this.moveBrushAdapter);
        } else {
            this.viewer.getDisplay().removeMouseListener((MouseListener)this.moveBrushAdapter);
            this.viewer.getDisplay().removeMouseMotionListener((MouseMotionListener)this.moveBrushAdapter);
        }
    }

    public void setBrushDiameter(double brushDiameter) {
        this.brushDiameter = brushDiameter;
        this.updateBrushOverlayRadius();
        this.triggerBrushOverlayRepaint();
        this.brushDiameterListeners.notifyListeners();
    }

    private void updateBrushOverlayRadius() {
        this.brushCursor.setRadius(this.getBrushDisplayRadius());
    }

    private void triggerBrushOverlayRepaint() {
        this.viewer.getDisplay().repaint();
    }

    public double getBrushDiameter() {
        return this.brushDiameter;
    }

    public Notifier brushDiameterListeners() {
        return this.brushDiameterListeners;
    }

    public void setOverlapping(boolean overlapping) {
        this.overlapping = overlapping;
    }

    public void setPlanarMode(boolean planarMode) {
        this.planarMode = planarMode;
    }

    private void makeLabelVisible() {
        Label label = this.model.selectedLabel().get();
        if (label == null) {
            return;
        }
        if (label.isVisible() && this.model.labelingVisibility().get().booleanValue()) {
            return;
        }
        label.setVisible(true);
        this.model.labelingVisibility().set(true);
        this.model.labeling().notifier().notifyListeners();
    }

    private double getBrushDisplayRadius() {
        return this.brushDiameter * 0.5 * this.getScale(this.model.labelTransformation()) * this.getScale(this.paintBehaviour.viewerTransformation());
    }

    private double getScale(AffineTransform3D transformation) {
        return Affine3DHelpers.extractScale((AffineTransform3D)transformation, (int)0);
    }

    private RandomAccessibleInterval<LabelingType<Label>> getFrame() {
        RandomAccessibleInterval frame = this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)frame, (int)(frame.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return frame;
    }

    private void fireBitmapChanged(RealPoint a, RealPoint b, double radius) {
        radius = radius * (this.brushDiameter + 2.0) / this.brushDiameter;
        long[] min = new long[2];
        long[] max = new long[2];
        for (int d = 0; d < 2; ++d) {
            min[d] = (long)(Math.min(a.getDoublePosition(d), b.getDoublePosition(d)) - radius);
            max[d] = (long)(Math.ceil(Math.max(a.getDoublePosition(d), b.getDoublePosition(d))) + radius);
        }
        this.model.dataChangedNotifier().notifyListeners((Interval)new FinalInterval(min, max));
    }

    private class MoveBrush
    implements DragBehaviour {
        private MoveBrush() {
        }

        @Override
        public void init(int x, int y) {
            LabelBrushController.this.brushCursor.setPosition(x, y);
            LabelBrushController.this.brushCursor.setVisible(true);
            LabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(1));
            LabelBrushController.this.triggerBrushOverlayRepaint();
        }

        @Override
        public void drag(int x, int y) {
            LabelBrushController.this.brushCursor.setPosition(x, y);
        }

        @Override
        public void end(int x, int y) {
            LabelBrushController.this.brushCursor.setPosition(x, y);
            if (!LabelBrushController.this.keepBrushCursorVisible) {
                LabelBrushController.this.brushCursor.setVisible(false);
                LabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(0));
            }
            LabelBrushController.this.triggerBrushOverlayRepaint();
        }
    }

    private class ChangeBrushRadius
    implements ScrollBehaviour {
        private ChangeBrushRadius() {
        }

        @Override
        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            if (!isHorizontal) {
                int sign = wheelRotation < 0.0 ? 1 : -1;
                double distance = Math.max(1.0, LabelBrushController.this.brushDiameter * 0.1);
                LabelBrushController.this.setBrushDiameter(Math.min(Math.max(1.0, LabelBrushController.this.brushDiameter + (double)sign * distance), 50.0));
            }
        }
    }

    private class PaintBehavior
    implements DragBehaviour {
        private boolean value;
        private RealPoint before;

        public PaintBehavior(boolean value) {
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(RealLocalizable screenCoordinates) {
            ViewerPanel viewerPanel = LabelBrushController.this.viewer;
            synchronized (viewerPanel) {
                MixedTransformView extended = this.extendLabelingType((RandomAccessibleInterval<LabelingType<Label>>)LabelBrushController.this.getFrame());
                double radius = Math.max(0.0, (LabelBrushController.this.brushDiameter - 1.0) * 0.5);
                AffineTransform3D m = this.displayToImageTransformation();
                double[] screen = new double[]{screenCoordinates.getDoublePosition(0), screenCoordinates.getDoublePosition(1), 0.0};
                double[] center = new double[3];
                m.apply(screen, center);
                if (extended.numDimensions() == 3 && LabelBrushController.this.planarMode) {
                    extended = Views.hyperSlice(extended, (int)2, (long)Math.round(center[2]));
                }
                AffineTransform3D labelTransform = LabelBrushController.this.model.labelTransformation();
                double pixelWidth = RealPoints.length(labelTransform.d(0));
                double pixelHeight = RealPoints.length(labelTransform.d(1));
                double pixelDepth = RealPoints.length(labelTransform.d(2));
                double[] axes = new double[]{radius, radius * pixelWidth / pixelHeight, radius * pixelWidth / pixelDepth};
                if (extended.numDimensions() == 2) {
                    center = Arrays.copyOf(center, 2);
                    axes = Arrays.copyOf(axes, 2);
                }
                IterableRegion<BitType> region = Ellipsoid.asIterableRegion(center, axes);
                Regions.sample(region, (RandomAccessible)extended).forEach(this.pixelOperation());
            }
        }

        private Consumer<LabelingType<Label>> pixelOperation() {
            Label label = LabelBrushController.this.model.selectedLabel().get();
            if (this.value) {
                if (label != null) {
                    if (LabelBrushController.this.overlapping) {
                        return pixel -> pixel.add((Object)label);
                    }
                    List<Label> visibleLabels = this.getVisibleLabels();
                    return pixel -> {
                        pixel.removeAll((Collection)visibleLabels);
                        pixel.add((Object)label);
                    };
                }
                return pixel -> {};
            }
            if (LabelBrushController.this.overlapping && label != null) {
                return pixel -> pixel.remove((Object)label);
            }
            List<Label> visibleLabels = this.getVisibleLabels();
            return pixel -> pixel.removeAll((Collection)visibleLabels);
        }

        private List<Label> getVisibleLabels() {
            List<Label> visibleLabels = LabelBrushController.this.model.labeling().get().getLabels().stream().filter(Label::isVisible).collect(Collectors.toList());
            return visibleLabels;
        }

        private RandomAccessible<LabelingType<Label>> extendLabelingType(RandomAccessibleInterval<LabelingType<Label>> slice) {
            LabelingType variable = ((LabelingType)slice.randomAccess().setPositionAndGet(Intervals.minAsLongArray(slice))).createVariable();
            variable.clear();
            return Views.extendValue(slice, (Type)variable);
        }

        private AffineTransform3D displayToImageTransformation() {
            AffineTransform3D m = new AffineTransform3D();
            m.concatenate(LabelBrushController.this.model.labelTransformation().inverse());
            m.concatenate(this.viewerTransformation().inverse());
            return m;
        }

        private AffineTransform3D viewerTransformation() {
            AffineTransform3D t = new AffineTransform3D();
            LabelBrushController.this.viewer.state().getViewerTransform(t);
            return t;
        }

        private void paint(RealLocalizable a, RealLocalizable b) {
            long distance = (long)(4.0 * (this.distance(a, b) + 1.0));
            long step = (long)Math.max(LabelBrushController.this.brushDiameter, 1.0);
            for (long i = 0L; i < distance; i += step) {
                this.paint(this.interpolate((double)i / (double)distance, a, b));
            }
        }

        RealLocalizable interpolate(double ratio, RealLocalizable a, RealLocalizable b) {
            RealPoint result = new RealPoint(a.numDimensions());
            for (int d = 0; d < result.numDimensions(); ++d) {
                result.setPosition(ratio * a.getDoublePosition(d) + (1.0 - ratio) * b.getDoublePosition(d), d);
            }
            return result;
        }

        double distance(RealLocalizable a, RealLocalizable b) {
            return LinAlgHelpers.distance((double[])this.asArray(a), (double[])this.asArray(b));
        }

        private double[] asArray(RealLocalizable a) {
            double[] result = new double[a.numDimensions()];
            a.localize(result);
            return result;
        }

        @Override
        public void init(int x, int y) {
            RealPoint coords;
            LabelBrushController.this.brushCursor.setPosition(x, y);
            LabelBrushController.this.brushCursor.setFontVisible(false);
            LabelBrushController.this.makeLabelVisible();
            this.before = coords = new RealPoint(new float[]{x, y});
            this.paint((RealLocalizable)coords);
            double radius = LabelBrushController.this.getBrushDisplayRadius();
            LabelBrushController.this.fireBitmapChanged(coords, coords, radius);
        }

        @Override
        public void drag(int x, int y) {
            LabelBrushController.this.brushCursor.setPosition(x, y);
            RealPoint coords = new RealPoint(new float[]{x, y});
            this.paint((RealLocalizable)this.before, (RealLocalizable)coords);
            double radius = LabelBrushController.this.getBrushDisplayRadius();
            LabelBrushController.this.fireBitmapChanged(this.before, coords, radius);
            this.before = coords;
        }

        @Override
        public void end(int x, int y) {
            LabelBrushController.this.brushCursor.setPosition(x, y);
            LabelBrushController.this.brushCursor.setFontVisible(true);
        }
    }
}

