/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.downsample;

import java.util.Arrays;
import java.util.function.Function;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.ClampType;
import net.imglib2.algorithm.blocks.ComputationType;
import net.imglib2.algorithm.blocks.DefaultUnaryBlockOperator;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.algorithm.blocks.downsample.DownsampleBlockProcessors;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class Downsample {
    public static long[] getDownsampledDimensions(long[] imgDimensions) {
        long[] destSize = new long[imgDimensions.length];
        Arrays.setAll(destSize, d -> (imgDimensions[d] + 1L) / 2L);
        return destSize;
    }

    public static long[] getDownsampledDimensions(long[] imgDimensions, boolean[] downsampleInDim) {
        boolean[] dDimsX = Util.expandArray(downsampleInDim, imgDimensions.length);
        long[] destSize = new long[imgDimensions.length];
        Arrays.setAll(destSize, d -> dDimsX[d] ? (imgDimensions[d] + 1L) / 2L : imgDimensions[d]);
        return destSize;
    }

    public static long[] getDownsampledDimensions(long[] imgDimensions, int[] downsamplingFactors) {
        int[] dFactorsX = Util.expandArray(downsamplingFactors, imgDimensions.length);
        long[] destSize = new long[imgDimensions.length];
        Arrays.setAll(destSize, d -> (imgDimensions[d] + (long)dFactorsX[d] - 1L) / (long)dFactorsX[d]);
        return destSize;
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> downsample() {
        return Downsample.downsample(Offset.HALF_PIXEL);
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> downsample(Offset offset) {
        return Downsample.downsample(ComputationType.AUTO, offset);
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> downsample(ComputationType computationType, Offset offset) {
        return s -> {
            NativeType type = (NativeType)s.getType();
            int n = s.numDimensions();
            return Downsample.createOperator(type, computationType, offset, n);
        };
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> downsample(ComputationType computationType, Offset offset, boolean[] downsampleInDim) {
        return s -> {
            NativeType type = (NativeType)s.getType();
            int n = s.numDimensions();
            boolean[] expandedDownsampleInDim = Util.expandArray(downsampleInDim, n);
            return Downsample.createOperator(type, computationType, offset, expandedDownsampleInDim);
        };
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> downsample(int[] downsamplingFactors) {
        return Downsample.downsample(ComputationType.AUTO, downsamplingFactors);
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> downsample(ComputationType computationType, int[] downsamplingFactors) {
        return s -> {
            NativeType type = (NativeType)s.getType();
            int n = s.numDimensions();
            int[] expandedDownsamplingFactors = Util.expandArray(downsamplingFactors, n);
            return Downsample.createOperator(type, computationType, expandedDownsamplingFactors);
        };
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> createOperator(T type, ComputationType computationType, Offset offset, boolean[] downsampleInDim) {
        UnaryBlockOperator<AbstractRealType, AbstractRealType> op = Downsample.processAsFloat(computationType, type) ? Downsample.downsampleFloat(offset, downsampleInDim) : Downsample.downsampleDouble(offset, downsampleInDim);
        return op.adaptSourceType(type, ClampType.NONE).adaptTargetType(type, ClampType.NONE);
    }

    private static <T extends NativeType<T>> boolean processAsFloat(ComputationType computationType, T type) {
        switch (computationType) {
            case FLOAT: {
                return true;
            }
            case DOUBLE: {
                return true;
            }
        }
        PrimitiveType pt = type.getNativeTypeFactory().getPrimitiveType();
        return pt.equals((Object)PrimitiveType.FLOAT) || pt.getByteCount() < PrimitiveType.FLOAT.getByteCount();
    }

    private static UnaryBlockOperator<FloatType, FloatType> downsampleFloat(Offset offset, boolean[] downsampleInDim) {
        FloatType type = new FloatType();
        int n = downsampleInDim.length;
        return new DefaultUnaryBlockOperator<FloatType, FloatType>(type, type, n, n, offset == Offset.HALF_PIXEL ? new DownsampleBlockProcessors.HalfPixelFloat(downsampleInDim) : new DownsampleBlockProcessors.CenterFloat(downsampleInDim));
    }

    private static UnaryBlockOperator<DoubleType, DoubleType> downsampleDouble(Offset offset, boolean[] downsampleInDim) {
        DoubleType type = new DoubleType();
        int n = downsampleInDim.length;
        return new DefaultUnaryBlockOperator<DoubleType, DoubleType>(type, type, n, n, offset == Offset.HALF_PIXEL ? new DownsampleBlockProcessors.HalfPixelDouble(downsampleInDim) : new DownsampleBlockProcessors.CenterDouble(downsampleInDim));
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> createOperator(T type, ComputationType computationType, Offset offset, int numDimensions) {
        boolean[] downsampleInDim = new boolean[numDimensions];
        Arrays.fill(downsampleInDim, true);
        return Downsample.createOperator(type, computationType, offset, downsampleInDim);
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> createOperator(T type, ComputationType computationType, int[] downsamplingFactors) {
        UnaryBlockOperator<AbstractRealType, AbstractRealType> op = Downsample.processAsFloat(computationType, type) ? Downsample.downsampleFloat(downsamplingFactors) : Downsample.downsampleDouble(downsamplingFactors);
        return op.adaptSourceType(type, ClampType.NONE).adaptTargetType(type, ClampType.NONE);
    }

    private static UnaryBlockOperator<FloatType, FloatType> downsampleFloat(int[] downsamplingFactors) {
        FloatType type = new FloatType();
        int n = downsamplingFactors.length;
        return new DefaultUnaryBlockOperator<FloatType, FloatType>(type, type, n, n, new DownsampleBlockProcessors.AvgBlockFloat(downsamplingFactors));
    }

    private static UnaryBlockOperator<DoubleType, DoubleType> downsampleDouble(int[] downsamplingFactors) {
        DoubleType type = new DoubleType();
        int n = downsamplingFactors.length;
        return new DefaultUnaryBlockOperator<DoubleType, DoubleType>(type, type, n, n, new DownsampleBlockProcessors.AvgBlockDouble(downsamplingFactors));
    }

    public static enum Offset {
        CENTERED,
        HALF_PIXEL;

    }
}

