/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gradient;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.algorithm.gradient.ScaleAsFunctionOfPosition;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public class HessianMatrix {
    public static <T extends RealType<T>, U extends RealType<U>> RandomAccessibleInterval<U> calculateMatrix(RandomAccessible<T> source, RandomAccessibleInterval<U> gaussian, RandomAccessibleInterval<U> gradient, RandomAccessibleInterval<U> hessianMatrix, OutOfBoundsFactory<U, ? super RandomAccessibleInterval<U>> outOfBounds, double ... sigma) throws IncompatibleTypeException {
        if (sigma.length == 1) {
            Gauss3.gauss(sigma[0], source, gaussian);
        } else {
            Gauss3.gauss(sigma, source, gaussian);
        }
        return HessianMatrix.calculateMatrix(Views.extend(gaussian, outOfBounds), gradient, hessianMatrix, outOfBounds);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> calculateMatrix(RandomAccessible<T> source, RandomAccessibleInterval<T> gradient, RandomAccessibleInterval<T> hessianMatrix, OutOfBoundsFactory<T, ? super RandomAccessibleInterval<T>> outOfBounds) {
        int nDim = gradient.numDimensions() - 1;
        for (long d = 0L; d < (long)nDim; ++d) {
            PartialDerivative.gradientCentralDifference(source, Views.hyperSlice(gradient, nDim, d), (int)d);
        }
        return HessianMatrix.calculateMatrix(Views.extend(gradient, outOfBounds), hessianMatrix);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> calculateMatrix(RandomAccessible<T> gradients, RandomAccessibleInterval<T> hessianMatrix) {
        int nDim = gradients.numDimensions() - 1;
        long count = 0L;
        for (long d1 = 0L; d1 < (long)nDim; ++d1) {
            MixedTransformView<T> hs1 = Views.hyperSlice(gradients, nDim, d1);
            for (long d2 = d1; d2 < (long)nDim; ++d2) {
                IntervalView<T> hs2 = Views.hyperSlice(hessianMatrix, nDim, count);
                PartialDerivative.gradientCentralDifference(hs1, hs2, (int)d2);
                ++count;
            }
        }
        return hessianMatrix;
    }

    public static <T extends RealType<T>, U extends RealType<U>> RandomAccessibleInterval<U> calculateMatrix(RandomAccessible<T> source, RandomAccessibleInterval<U> gaussian, RandomAccessibleInterval<U> gradient, RandomAccessibleInterval<U> hessianMatrix, OutOfBoundsFactory<U, ? super RandomAccessibleInterval<U>> outOfBounds, int nTasks, ExecutorService es, double ... sigma) throws IncompatibleTypeException, InterruptedException, ExecutionException {
        if (sigma.length == 1) {
            Gauss3.gauss(IntStream.range(0, source.numDimensions()).mapToDouble(i -> sigma[0]).toArray(), source, gaussian, es);
        } else {
            Gauss3.gauss(sigma, source, gaussian, es);
        }
        return HessianMatrix.calculateMatrix(Views.extend(gaussian, outOfBounds), gradient, hessianMatrix, outOfBounds, nTasks, es);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> calculateMatrix(RandomAccessible<T> source, RandomAccessibleInterval<T> gradient, RandomAccessibleInterval<T> hessianMatrix, OutOfBoundsFactory<T, ? super RandomAccessibleInterval<T>> outOfBounds, int nTasks, ExecutorService es) throws IncompatibleTypeException, InterruptedException, ExecutionException {
        int nDim = gradient.numDimensions() - 1;
        for (long d = 0L; d < (long)nDim; ++d) {
            PartialDerivative.gradientCentralDifferenceParallel(source, Views.hyperSlice(gradient, nDim, d), (int)d, nTasks, es);
        }
        return HessianMatrix.calculateMatrix(Views.extend(gradient, outOfBounds), hessianMatrix, nTasks, es);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> calculateMatrix(RandomAccessible<T> gradient, RandomAccessibleInterval<T> hessianMatrix, int nTasks, ExecutorService es) throws IncompatibleTypeException, InterruptedException, ExecutionException {
        int nDim = gradient.numDimensions() - 1;
        long count = 0L;
        for (long d1 = 0L; d1 < (long)nDim; ++d1) {
            MixedTransformView<T> hs1 = Views.hyperSlice(gradient, nDim, d1);
            for (long d2 = d1; d2 < (long)nDim; ++d2) {
                IntervalView<T> hs2 = Views.hyperSlice(hessianMatrix, nDim, count);
                PartialDerivative.gradientCentralDifferenceParallel(hs1, hs2, (int)d2, nTasks, es);
                ++count;
            }
        }
        return hessianMatrix;
    }

    public static <T extends RealType<T>> IntervalView<T> scaleHessianMatrix(RandomAccessibleInterval<T> hessian, double[] sigma) {
        assert (sigma.length == hessian.numDimensions() - 1);
        assert ((long)(sigma.length * (sigma.length + 1) / 2) == hessian.dimension(sigma.length));
        int maxD = sigma.length;
        double minSigma = Util.min(sigma);
        double minSigmaSq = minSigma * minSigma;
        double[] sigmaSquared = new double[sigma.length * (sigma.length + 1) / 2];
        int k = 0;
        for (int i1 = 0; i1 < sigma.length; ++i1) {
            int i2 = i1;
            while (i2 < sigma.length) {
                sigmaSquared[k] = sigma[i1] * sigma[i2] / minSigmaSq;
                ++i2;
                ++k;
            }
        }
        ScaleAsFunctionOfPosition<T> scaledMatrix = new ScaleAsFunctionOfPosition<T>(hessian, l -> sigmaSquared[l.getIntPosition(maxD)]);
        return Views.interval(scaledMatrix, hessian);
    }
}

