/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.equation;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.imagej.ops.Ops;
import net.imagej.ops.image.equation.EquationOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.RealType;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;

@Plugin(type=Ops.Image.Equation.class)
public class DefaultEquation<T extends RealType<T>>
extends AbstractUnaryHybridCF<String, IterableInterval<T>>
implements EquationOp<T> {
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private LogService log;

    @Override
    public void compute(String input, IterableInterval<T> output) {
        String equation = input + ";";
        ScriptLanguage js = this.scriptService.getLanguageByName("javascript");
        ScriptEngine engine = js.getScriptEngine();
        Bindings bindings = engine.getBindings(100);
        Cursor c = output.localizingCursor();
        long[] pos = new long[output.numDimensions()];
        bindings.put("p", (Object)pos);
        bindings.put("c", (Object)c);
        if (engine instanceof Compilable) {
            try {
                String script = "importClass(Packages.java.lang.Double);\nwhile (c.hasNext()) {\n  c.fwd();\n  c.localize(p);\n  o = " + equation + ";\n  try {\n    c.get().setReal(o);\n  } catch(e) {    c.get().setReal(Double.NaN);\n  }\n}";
                Compilable compiler = (Compilable)((Object)engine);
                CompiledScript compiled = compiler.compile(script);
                compiled.eval(bindings);
            }
            catch (ScriptException e) {
                this.log.warn((Throwable)e);
            }
        }
        try {
            while (c.hasNext()) {
                c.fwd();
                c.localize(pos);
                Object o = engine.eval(equation);
                double d = o instanceof Number ? ((Number)o).doubleValue() : Double.NaN;
                ((RealType)c.get()).setReal(d);
            }
        }
        catch (ScriptException exc) {
            this.log.error((Throwable)exc);
        }
    }

    @Override
    public IterableInterval<T> createOutput(String input) {
        ArrayImg newImage = ArrayImgs.doubles((long[])new long[]{256L, 256L});
        return newImage;
    }
}

