/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class XPM_Writer
implements PlugIn {
    public void run(String arg) {
        int i;
        ImagePlus image = WindowManager.getCurrentImage();
        if (image == null) {
            IJ.error((String)"No image is open");
            return;
        }
        byte[] pixels = null;
        try {
            pixels = (byte[])image.getProcessor().getPixels();
        }
        catch (ClassCastException e) {
            IJ.error((String)"Can only handle 8-bit images");
            return;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        char[] letters = new char[256];
        int currentAsciiValue = 32;
        for (i = 0; i < w * h; ++i) {
            int value = pixels[i] & 0xFF;
            if (letters[value] != '\u0000') continue;
            if (currentAsciiValue > 125) {
                IJ.error((String)"This image needs more than 95colors.\nPlease convert to RGB and then to 8-bit Color, reducing the number of colors.");
                return;
            }
            letters[value] = (char)currentAsciiValue++;
        }
        currentAsciiValue = 32;
        for (i = 0; i < letters.length; ++i) {
            if (letters[i] <= '\u0000') continue;
            letters[i] = (char)currentAsciiValue++;
            if (letters[i] < '\"') continue;
            int n = i;
            letters[n] = (char)(letters[n] + '\u0001');
        }
        String name = image.getTitle();
        String path = arg;
        if (path == null || path.length() < 1) {
            SaveDialog sd = new SaveDialog("Save as XPM", name, ".xpm");
            String directory = sd.getDirectory();
            if (directory == null) {
                return;
            }
            if (!directory.endsWith("/")) {
                directory = directory + "/";
            }
            name = sd.getFileName();
            path = directory + name;
        }
        try {
            PrintStream out = new PrintStream(new FileOutputStream(path));
            this.writeHeader(out, name, w, h, currentAsciiValue - 32);
            this.writeColorTable(out, letters, image.createLut());
            this.writeImage(out, w, h, pixels, letters);
            out.close();
        }
        catch (IOException e) {
            IJ.error((String)("Could not write to '" + path + "'"));
        }
    }

    protected void writeHeader(PrintStream out, String name, int w, int h, int colorCount) throws IOException {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || i != 0 && c >= '0' && c <= '9') continue;
            name = name.substring(0, i) + '_' + name.substring(i + 1);
        }
        out.println("/* XPM */");
        out.println("static char* " + name + "[] = {");
        out.println("\"" + w + " " + h + " " + colorCount + " 1\",");
    }

    protected static String toHex(byte b) {
        String hex = "0123456789abcdef";
        return "" + "0123456789abcdef".charAt((b & 0xF0) >> 4) + "0123456789abcdef".charAt(b & 0xF);
    }

    protected void writeColorTable(PrintStream out, char[] letters, LookUpTable lut) throws IOException {
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        for (int i = 0; i < letters.length; ++i) {
            if (letters[i] <= '\u0000') continue;
            out.println("\"" + letters[i] + " c #" + XPM_Writer.toHex(reds[i]) + XPM_Writer.toHex(greens[i]) + XPM_Writer.toHex(blues[i]) + "\",");
        }
    }

    protected void writeImage(PrintStream out, int w, int h, byte[] pixels, char[] letters) throws IOException {
        for (int j = 0; j < h; ++j) {
            String line = "\"";
            for (int i = 0; i < w; ++i) {
                line = line + letters[pixels[i + j * w]];
            }
            line = line + "\"" + (j < h - 1 ? "," : "};");
            out.println(line);
        }
    }
}

